/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.pool.ObjectPool;
import org.batoo.jpa.common.log.BLogger;
import org.batoo.jpa.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.jdbc.PreparedStatementFactory;
import org.batoo.jpa.core.impl.jdbc.PreparedStatementImpl;
import org.batoo.jpa.core.impl.manager.OperationTookLongTimeWarning;
import org.batoo.jpa.core.pool.GenericKeyedPool;

public class ConnectionImpl
implements Connection {
    private static final BLogger LOG = BLoggerFactory.getLogger(ConnectionImpl.class);
    private static AtomicLong no = new AtomicLong(0L);
    private Connection connection;
    private final ObjectPool<ConnectionImpl> pool;
    final long connNo;
    private final long opened;
    private boolean closed;
    private volatile long callNo = 0L;
    private volatile long statements = 0L;
    volatile long executes = 0L;
    private volatile long transactions = 0L;
    private final GenericKeyedPool<String, PreparedStatementImpl> preparedStatementPool;
    private boolean debug;

    public ConnectionImpl(Connection connection, ObjectPool<ConnectionImpl> pool) {
        this.connection = connection;
        this.pool = pool;
        this.connNo = no.incrementAndGet();
        this.opened = System.currentTimeMillis();
        this.preparedStatementPool = new GenericKeyedPool(new PreparedStatementFactory(this));
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.throwNotImplemented();
    }

    @Override
    public void close() throws SQLException {
        if (this.pool != null) {
            try {
                this.pool.returnObject((Object)this);
                this.closed = true;
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new SQLException(e);
            }
        } else {
            this.close0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close0() throws SQLException {
        long callNo = ++this.callNo;
        LOG.trace("{0}:{1} close()", this.connNo, callNo);
        long start = System.currentTimeMillis();
        try {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (Exception e) {
                this.handlePoolException(e);
            }
            LOG.trace("Connection {0}, used for {1} msecs, transactions= {2}, statements= {3}, executes= {4}", this.connNo, System.currentTimeMillis() - this.opened, this.transactions, this.statements, this.executes);
        }
        catch (Throwable throwable) {
            long time = System.currentTimeMillis() - start;
            if (time > 2500L) {
                LOG.warn(new OperationTookLongTimeWarning(), "{0}:{1} {2} msecs, close()", this.connNo, callNo, time);
            } else {
                LOG.trace("{0}:{1} {2} msecs, close()", this.connNo, callNo, time);
            }
            throw throwable;
        }
        long time = System.currentTimeMillis() - start;
        if (time > 2500L) {
            LOG.warn(new OperationTookLongTimeWarning(), "{0}:{1} {2} msecs, close()", this.connNo, callNo, time);
        } else {
            LOG.trace("{0}:{1} {2} msecs, close()", this.connNo, callNo, time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        if (!this.debug) {
            this.connection.commit();
            return;
        }
        long callNo = ++this.callNo;
        LOG.trace("{0}:{1} commit()", this.connNo, callNo);
        long start = System.currentTimeMillis();
        try {
            this.connection.commit();
        }
        catch (Throwable throwable) {
            long time = System.currentTimeMillis() - start;
            if (time > 2500L) {
                LOG.warn(new OperationTookLongTimeWarning(), "{0}:{1} {2} msecs, commit()", this.connNo, callNo, time);
            } else {
                LOG.trace("{0}:{1} {2} msecs, commit()", this.connNo, callNo, time);
            }
            throw throwable;
        }
        long time = System.currentTimeMillis() - start;
        if (time > 2500L) {
            LOG.warn(new OperationTookLongTimeWarning(), "{0}:{1} {2} msecs, commit()", this.connNo, callNo, time);
        } else {
            LOG.trace("{0}:{1} {2} msecs, commit()", this.connNo, callNo, time);
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.throwNotImplemented();
        return false;
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.connection.getClientInfo();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.connection.getClientInfo(name);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.connection.getNetworkTimeout();
    }

    @Override
    public String getSchema() throws SQLException {
        return this.connection.getSchema();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    private void handlePoolException(Exception e) throws SQLException {
        if (e instanceof SQLException) {
            throw (SQLException)e;
        }
        throw new SQLException(e);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.connection.isValid(timeout);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.connection.isWrapperFor(iface);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.connection.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.preparedStatementPool != null) {
            try {
                return this.preparedStatementPool.borrowObject(sql).reset();
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new SQLException(e);
            }
        }
        return this.prepareStatement0(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PreparedStatementImpl prepareStatement0(String sql) throws SQLException {
        PreparedStatementImpl preparedStatementImpl;
        if (!LOG.isDebugEnabled()) {
            return new PreparedStatementImpl(this, sql, this.connection.prepareStatement(sql), this.preparedStatementPool);
        }
        long callNo = ++this.callNo;
        LOG.trace("{0}:{1} prepareStatement(String): {2}", this.connNo, callNo, LOG.lazyBoxed(sql));
        long start = System.currentTimeMillis();
        try {
            preparedStatementImpl = new PreparedStatementImpl(this, sql, this.connection.prepareStatement(sql), this.preparedStatementPool);
        }
        catch (Throwable throwable) {
            long time = System.currentTimeMillis() - start;
            if (time > 2500L) {
                LOG.warn(new OperationTookLongTimeWarning(), "{0}:{1} {2} msecs, prepareStatement(String): {3}", this.connNo, callNo, time, LOG.lazyBoxed(sql));
            } else {
                LOG.debug("{0}:{1} {2} msecs, prepareStatement(String)", this.connNo, callNo, time);
            }
            throw throwable;
        }
        long time = System.currentTimeMillis() - start;
        if (time > 2500L) {
            LOG.warn(new OperationTookLongTimeWarning(), "{0}:{1} {2} msecs, prepareStatement(String): {3}", this.connNo, callNo, time, LOG.lazyBoxed(sql));
        } else {
            LOG.debug("{0}:{1} {2} msecs, prepareStatement(String)", this.connNo, callNo, time);
        }
        return preparedStatementImpl;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.throwNotImplemented();
    }

    public void reset() {
        this.debug = LOG.isDebugEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        long time;
        long start;
        long callNo;
        block8: {
            if (!this.debug) {
                if (this.connection != null) {
                    this.connection.rollback();
                }
                return;
            }
            callNo = ++this.callNo;
            LOG.trace("{0}:{1} rollback()", this.connNo, callNo);
            start = System.currentTimeMillis();
            try {
                if (this.connection == null) break block8;
                this.connection.rollback();
            }
            catch (Throwable throwable) {
                long time2 = System.currentTimeMillis() - start;
                if (time2 > 2500L) {
                    LOG.warn(new OperationTookLongTimeWarning(), "{0}:{1} {2} msecs, rollback()", this.connNo, callNo, time2);
                } else {
                    LOG.trace("{0}:{1} {2} msecs, rollback()", this.connNo, callNo, time2);
                }
                throw throwable;
            }
        }
        if ((time = System.currentTimeMillis() - start) > 2500L) {
            LOG.warn(new OperationTookLongTimeWarning(), "{0}:{1} {2} msecs, rollback()", this.connNo, callNo, time);
        } else {
            LOG.trace("{0}:{1} {2} msecs, rollback()", this.connNo, callNo, time);
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.throwNotImplemented();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (!this.debug) {
            this.connection.setAutoCommit(autoCommit);
            return;
        }
        long callNo = ++this.callNo;
        LOG.trace("{0}:{1} setAutoCommit(boolean): {2}", this.connNo, callNo, autoCommit);
        long start = System.currentTimeMillis();
        try {
            this.connection.setAutoCommit(autoCommit);
        }
        catch (Throwable throwable) {
            LOG.trace("{0}:{1} {2} msecs, setAutoCommit(boolean): {3}", this.connNo, callNo, System.currentTimeMillis() - start, autoCommit);
            throw throwable;
        }
        LOG.trace("{0}:{1} {2} msecs, setAutoCommit(boolean): {3}", this.connNo, callNo, System.currentTimeMillis() - start, autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.connection.setCatalog(catalog);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.connection.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.setClientInfo(name, value);
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.closed = false;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.connection.setHoldability(holdability);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.connection.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.connection.setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.connection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.connection.setSavepoint(name);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.connection.setSchema(schema);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.connection.setTransactionIsolation(level);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    private void throwNotImplemented() {
        throw new NotImplementedException();
    }

    public String toString() {
        return "ConnectionImpl [connNo=" + this.connNo + ", connected=" + (this.connection != null) + ", opened=" + this.opened + ", callNo=" + this.callNo + ", statements=" + this.statements + ", executes=" + this.executes + ", transactions=" + this.transactions + "]";
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.throwNotImplemented();
        return null;
    }
}

