/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import java.lang.reflect.Method;
import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import org.batoo.jpa.core.impl.jdbc.AbstractColumn;
import org.batoo.jpa.core.impl.jdbc.AbstractTable;
import org.batoo.jpa.core.impl.jdbc.CollectionTable;
import org.batoo.jpa.core.impl.jdbc.TypeFactory;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.core.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.impl.AbstractLocator;
import org.batoo.jpa.parser.metadata.ColumnMetadata;

public class ElementColumn
extends AbstractColumn {
    private final CollectionTable table;
    private final int sqlType;
    private final String columnDefinition;
    private final AbstractLocator locator;
    private final String name;
    private final boolean insertable;
    private final boolean nullable;
    private final boolean updatable;
    private final int length;
    private final int precision;
    private final int scale;
    private final boolean unique;
    private final EnumType enumType;
    private final Enum<?>[] values;
    private final Method method;

    public ElementColumn(JdbcAdaptor jdbcAdaptor, CollectionTable table, String name, Class<?> javaType, EnumType enumType, TemporalType temporalType, boolean lob, ColumnMetadata metadata) {
        this.locator = metadata != null ? metadata.getLocator() : null;
        this.table = table;
        this.sqlType = TypeFactory.getSqlType(javaType, temporalType, enumType, lob);
        this.name = jdbcAdaptor.escape(name);
        this.columnDefinition = metadata != null ? metadata.getColumnDefinition() : null;
        this.length = metadata != null ? metadata.getLength() : 255;
        this.precision = metadata != null ? metadata.getPrecision() : 0;
        this.scale = metadata != null ? metadata.getScale() : 0;
        this.insertable = metadata != null ? metadata.isInsertable() : true;
        this.nullable = metadata != null ? metadata.isNullable() : true;
        this.unique = metadata != null ? metadata.isUnique() : false;
        boolean bl = this.updatable = metadata != null ? metadata.isUpdatable() : true;
        if (javaType.isEnum()) {
            this.enumType = enumType != null ? enumType : EnumType.ORDINAL;
            try {
                if (this.enumType == EnumType.ORDINAL) {
                    this.values = (Enum[])javaType.getMethod("values", new Class[0]).invoke(null, new Object[0]);
                    this.method = null;
                }
                this.values = null;
                this.method = javaType.getMethod("valueOf", String.class);
            }
            catch (Exception e) {
                throw new MappingException("Unable to map enum type", this.locator);
            }
        } else {
            this.enumType = null;
            this.values = null;
            this.method = null;
        }
        this.table.addColumn(this);
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public AbstractLocator getLocator() {
        return this.locator;
    }

    @Override
    public Mapping<?, ?, ?> getMapping() {
        return null;
    }

    @Override
    public String getMappingName() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public int getSqlType() {
        return this.sqlType;
    }

    @Override
    public AbstractTable getTable() {
        return this.table;
    }

    @Override
    public String getTableName() {
        return this.table.getName();
    }

    @Override
    public Object getValue(Object instance) {
        if (instance == null) {
            return null;
        }
        if (this.enumType == null) {
            return instance;
        }
        Enum enumValue = (Enum)instance;
        if (this.enumType == EnumType.ORDINAL) {
            return enumValue.ordinal();
        }
        return enumValue.name();
    }

    @Override
    public boolean isInsertable() {
        return this.insertable;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public boolean isUpdatable() {
        return this.updatable;
    }

    @Override
    public void setTable(AbstractTable table) {
    }

    @Override
    public void setValue(Object instance, Object value) {
        if (value != null && this.enumType != null) {
            if (this.enumType == EnumType.ORDINAL) {
                value = this.values[(Integer)value];
            } else {
                try {
                    value = this.method.invoke(null, value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

