/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.jdbc.AbstractColumn;
import org.batoo.jpa.core.impl.jdbc.AbstractTable;
import org.batoo.jpa.core.impl.jdbc.BasicColumn;
import org.batoo.jpa.core.impl.jdbc.ConnectionImpl;
import org.batoo.jpa.core.impl.jdbc.DiscriminatorColumn;
import org.batoo.jpa.core.impl.jdbc.JoinColumn;
import org.batoo.jpa.core.impl.jdbc.PkColumn;
import org.batoo.jpa.core.impl.jdbc.dbutils.QueryRunner;
import org.batoo.jpa.core.impl.jdbc.dbutils.SingleValueHandler;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.jdbc.IdType;
import org.batoo.jpa.core.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.parser.metadata.TableMetadata;

public class EntityTable
extends AbstractTable {
    private final EntityTypeImpl<?> entity;
    private final Map<String, AbstractColumn> pkColumns = Maps.newHashMap();
    private final JdbcAdaptor jdbcAdaptor;
    private PkColumn identityColumn;
    private String removeSql;
    private AbstractColumn[] removeColumns;
    private final Map<String, BasicColumn[]> indexes = Maps.newHashMap();

    public EntityTable(EntityTypeImpl<?> entity, TableMetadata metadata) {
        super(entity.getName(), metadata);
        this.entity = entity;
        this.jdbcAdaptor = entity.getMetamodel().getJdbcAdaptor();
    }

    @Override
    public void addColumn(AbstractColumn column) {
        JoinColumn joinColumn;
        super.addColumn(column);
        if (column instanceof PkColumn) {
            PkColumn pkColumn = (PkColumn)column;
            this.pkColumns.put(pkColumn.getMappingName(), pkColumn);
            if (pkColumn.getIdType() == IdType.IDENTITY) {
                this.identityColumn = (PkColumn)column;
            }
        } else if (column instanceof JoinColumn && (joinColumn = (JoinColumn)column).isPrimaryKey()) {
            this.pkColumns.put(column.getMappingName(), joinColumn);
        }
    }

    public boolean addIndex(String name, BasicColumn ... columns) {
        if (this.indexes.containsKey(name)) {
            return true;
        }
        this.indexes.put(name, columns);
        return false;
    }

    public EntityTypeImpl<?> getEntity() {
        return this.entity;
    }

    public Map<String, BasicColumn[]> getIndexes() {
        return this.indexes;
    }

    protected JdbcAdaptor getJdbcAdaptor() {
        return this.jdbcAdaptor;
    }

    @Override
    public Set<String> getPkColumnNames() {
        return this.pkColumns.keySet();
    }

    public Collection<AbstractColumn> getPkColumns() {
        return this.pkColumns.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRemoveSql() {
        if (this.removeSql != null) {
            return this.removeSql;
        }
        EntityTable entityTable = this;
        synchronized (entityTable) {
            if (this.removeSql != null) {
                return this.removeSql;
            }
            this.removeColumns = new AbstractColumn[this.pkColumns.size()];
            this.pkColumns.values().toArray(this.removeColumns);
            Collection restrictions = Collections2.transform(this.pkColumns.values(), (Function)new Function<AbstractColumn, String>(){

                public String apply(AbstractColumn input) {
                    return input.getName() + " = ?";
                }
            });
            this.removeSql = "DELETE FROM " + this.getQName() + " WHERE " + Joiner.on((String)" AND ").join((Iterable)restrictions);
            return this.removeSql;
        }
    }

    public void performInsert(ConnectionImpl connection, ManagedInstance<?> managedInstance) throws SQLException {
        EntityTypeImpl<?> entityType = managedInstance.getType();
        Object instance = managedInstance.getInstance();
        String insertSql = this.getInsertSql(entityType);
        AbstractColumn[] insertColumns = this.getInsertColumns(entityType);
        Object[] params = new Object[insertColumns.length];
        for (int i = 0; i < insertColumns.length; ++i) {
            AbstractColumn column = insertColumns[i];
            params[i] = column instanceof DiscriminatorColumn ? managedInstance.getType().getDiscriminatorValue() : column.getValue(instance);
        }
        QueryRunner runner = new QueryRunner(this.jdbcAdaptor.isPmdBroken());
        runner.update((Connection)connection, insertSql, params);
        if (this.identityColumn != null) {
            String selectLastIdSql = this.jdbcAdaptor.getSelectLastIdentitySql(this.identityColumn);
            Number id = (Number)runner.query(connection, selectLastIdSql, new SingleValueHandler());
            this.identityColumn.setValue(managedInstance.getInstance(), id);
        }
    }

    public void performRemove(ConnectionImpl connection, ManagedInstance<?> managedInstance) throws SQLException {
        String removeSql = this.getRemoveSql();
        Object[] params = new Object[this.removeColumns.length];
        for (int i = 0; i < this.removeColumns.length; ++i) {
            AbstractColumn column = this.removeColumns[i];
            params[i] = column.getValue(managedInstance.getInstance());
        }
        QueryRunner runner = new QueryRunner(this.jdbcAdaptor.isPmdBroken());
        runner.update((Connection)connection, removeSql, params);
    }

    public Object performSelectVersion(ConnectionImpl connection, ManagedInstance<?> managedInstance) throws SQLException {
        Object instance = managedInstance.getInstance();
        String updateSql = this.getSelectVersionSql(this.pkColumns);
        AbstractColumn[] selectVersionColumns = this.getSelectVersionColumns();
        Object[] params = new Object[selectVersionColumns.length];
        for (int i = 0; i < selectVersionColumns.length; ++i) {
            AbstractColumn column = selectVersionColumns[i];
            params[i] = column.getValue(instance);
        }
        QueryRunner runner = new QueryRunner(this.jdbcAdaptor.isPmdBroken());
        return runner.query((Connection)connection, updateSql, new SingleValueHandler(), params);
    }

    public void performUpdate(ConnectionImpl connection, ManagedInstance<?> managedInstance) throws SQLException {
        EntityTypeImpl<?> entityType = managedInstance.getType();
        Object instance = managedInstance.getInstance();
        String updateSql = this.getUpdateSql(entityType, this.pkColumns);
        AbstractColumn[] updateColumns = this.getUpdateColumns(entityType);
        Object[] params = new Object[updateColumns.length];
        for (int i = 0; i < updateColumns.length; ++i) {
            AbstractColumn column = updateColumns[i];
            params[i] = column.getValue(instance);
        }
        QueryRunner runner = new QueryRunner(this.jdbcAdaptor.isPmdBroken());
        runner.update((Connection)connection, updateSql, params);
    }

    public boolean performUpdateWithUpdatability(ConnectionImpl connection, ManagedInstance<?> managedInstance) throws SQLException {
        EntityTypeImpl<?> entityType = managedInstance.getType();
        Object instance = managedInstance.getInstance();
        String updateSql = this.getUpdateSql(entityType, this.pkColumns);
        AbstractColumn[] updateColumns = this.getUpdateColumns(entityType);
        Object[] params = new Object[updateColumns.length];
        for (int i = 0; i < updateColumns.length; ++i) {
            AbstractColumn column = updateColumns[i];
            if (i == 0 && column.isPrimaryKey()) {
                return false;
            }
            params[i] = column.getValue(instance);
        }
        QueryRunner runner = new QueryRunner(this.jdbcAdaptor.isPmdBroken());
        runner.update((Connection)connection, updateSql, params);
        return true;
    }

    public void performVersionUpdate(ConnectionImpl connection, ManagedInstance<?> managedInstance) throws SQLException {
        Object instance = managedInstance.getInstance();
        String updateSql = this.getVersionUpdateSql(this.pkColumns);
        AbstractColumn[] versionUpdateColumns = this.getVersionUpdateColumns();
        Object[] params = new Object[versionUpdateColumns.length];
        for (int i = 0; i < versionUpdateColumns.length; ++i) {
            AbstractColumn column = versionUpdateColumns[i];
            params[i] = column.getValue(instance);
        }
        QueryRunner runner = new QueryRunner(this.jdbcAdaptor.isPmdBroken());
        runner.update((Connection)connection, updateSql, params);
    }

    public String toString() {
        String columns = Joiner.on((String)", ").join((Iterable)Collections2.transform(this.getColumns(), (Function)new Function<AbstractColumn, String>(){

            public String apply(AbstractColumn input) {
                StringBuffer out = new StringBuffer();
                out.append(input instanceof PkColumn ? "ID [" : "COL [");
                out.append("name=");
                out.append(input.getName());
                out.append(", type=");
                out.append(input.getSqlType());
                out.append("]");
                return out.toString();
            }
        }));
        return "Table [owner=" + this.entity.getName() + ", name=" + this.getQName() + ", columns=[" + columns + "]]";
    }
}

