/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc.dbutils;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;

public abstract class AbstractQueryRunner {
    private volatile boolean pmdKnownBroken = false;
    protected final DataSource ds;

    public AbstractQueryRunner() {
        this.ds = null;
    }

    public AbstractQueryRunner(boolean pmdKnownBroken) {
        this.pmdKnownBroken = pmdKnownBroken;
        this.ds = null;
    }

    public AbstractQueryRunner(DataSource ds) {
        this.ds = ds;
    }

    public AbstractQueryRunner(DataSource ds, boolean pmdKnownBroken) {
        this.pmdKnownBroken = pmdKnownBroken;
        this.ds = ds;
    }

    protected void close(Connection conn) throws SQLException {
        DbUtils.close((Connection)conn);
    }

    protected void close(ResultSet rs) throws SQLException {
        DbUtils.close((ResultSet)rs);
    }

    protected void close(Statement stmt) throws SQLException {
        DbUtils.close((Statement)stmt);
    }

    public void fillStatement(PreparedStatement stmt, Object ... params) throws SQLException {
        ParameterMetaData pmd = null;
        if (!this.pmdKnownBroken) {
            int paramsCount;
            pmd = stmt.getParameterMetaData();
            int stmtCount = pmd.getParameterCount();
            int n = paramsCount = params == null ? 0 : params.length;
            if (stmtCount != paramsCount) {
                throw new SQLException("Wrong number of parameters: expected " + stmtCount + ", was given " + paramsCount);
            }
        }
        if (params == null) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            if (params[i] != null) {
                stmt.setObject(i + 1, params[i]);
                continue;
            }
            int sqlType = 12;
            if (!this.pmdKnownBroken) {
                try {
                    sqlType = pmd.getParameterType(i + 1);
                }
                catch (SQLException e) {
                    this.pmdKnownBroken = true;
                }
            }
            stmt.setNull(i + 1, sqlType);
        }
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    public boolean isPmdKnownBroken() {
        return this.pmdKnownBroken;
    }

    protected Connection prepareConnection() throws SQLException {
        if (this.getDataSource() == null) {
            throw new SQLException("QueryRunner requires a DataSource to be invoked in this way, or a Connection should be passed in");
        }
        return this.getDataSource().getConnection();
    }

    protected PreparedStatement prepareStatement(Connection conn, String sql) throws SQLException {
        return conn.prepareStatement(sql);
    }

    protected void rethrow(SQLException cause, String sql, Object ... params) throws SQLException {
        String causeMessage = cause.getMessage();
        if (causeMessage == null) {
            causeMessage = "";
        }
        StringBuffer msg = new StringBuffer(causeMessage);
        msg.append(" Query: ");
        msg.append(sql);
        msg.append(" Parameters: ");
        if (params == null) {
            msg.append("[]");
        } else {
            msg.append(Arrays.deepToString(params));
        }
        SQLException e = new SQLException(msg.toString(), cause.getSQLState(), cause.getErrorCode());
        e.setNextException(cause);
        throw e;
    }

    protected ResultSet wrap(ResultSet rs) {
        return rs;
    }
}

