/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model;

import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.parser.impl.AbstractLocator;
import org.batoo.jpa.parser.metadata.GeneratorMetadata;

public abstract class AbstractGenerator {
    public static final String DEFAULT_NAME = "BATOO_ID";
    private final AbstractLocator locator;
    private final String catalog;
    private final String schema;
    private final String name;
    private final int initialValue;
    private final int allocationSize;

    public AbstractGenerator(GeneratorMetadata metadata) {
        this.locator = metadata != null ? metadata.getLocator() : null;
        this.catalog = metadata != null ? metadata.getCatalog() : null;
        this.name = metadata != null ? metadata.getName() : DEFAULT_NAME;
        this.schema = metadata != null && StringUtils.isNotBlank((String)metadata.getSchema()) ? metadata.getSchema() : null;
        this.initialValue = metadata != null ? metadata.getInitialValue() : 1;
        this.allocationSize = metadata != null ? metadata.getAllocationSize() : 50;
    }

    public int getAllocationSize() {
        return this.allocationSize;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public AbstractLocator getLocator() {
        return this.locator;
    }

    public String getName() {
        return this.name;
    }

    public abstract String getQName();

    public String getSchema() {
        return this.schema;
    }
}

