/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.PersistenceException;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MappedSuperclassType;
import javax.persistence.metamodel.Metamodel;
import org.batoo.jpa.common.log.BLogger;
import org.batoo.jpa.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.jdbc.AbstractTable;
import org.batoo.jpa.core.impl.jdbc.DataSourceImpl;
import org.batoo.jpa.core.impl.jdbc.EntityTable;
import org.batoo.jpa.core.impl.jdbc.ForeignKey;
import org.batoo.jpa.core.impl.jdbc.JoinTable;
import org.batoo.jpa.core.impl.manager.CallbackAvailability;
import org.batoo.jpa.core.impl.manager.CallbackManager;
import org.batoo.jpa.core.impl.manager.EntityManagerFactoryImpl;
import org.batoo.jpa.core.impl.model.SequenceGenerator;
import org.batoo.jpa.core.impl.model.SequenceQueue;
import org.batoo.jpa.core.impl.model.TableGenerator;
import org.batoo.jpa.core.impl.model.TableIdQueue;
import org.batoo.jpa.core.impl.model.mapping.AssociationMapping;
import org.batoo.jpa.core.impl.model.mapping.PluralMapping;
import org.batoo.jpa.core.impl.model.type.BasicTypeImpl;
import org.batoo.jpa.core.impl.model.type.EmbeddableTypeImpl;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.type.IdentifiableTypeImpl;
import org.batoo.jpa.core.impl.model.type.ManagedTypeImpl;
import org.batoo.jpa.core.impl.model.type.MappedSuperclassTypeImpl;
import org.batoo.jpa.core.impl.model.type.TypeImpl;
import org.batoo.jpa.core.jdbc.DDLMode;
import org.batoo.jpa.core.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.impl.metadata.MetadataImpl;
import org.batoo.jpa.parser.metadata.EntityListenerMetadata;
import org.batoo.jpa.parser.metadata.NamedQueryMetadata;
import org.batoo.jpa.parser.metadata.SequenceGeneratorMetadata;
import org.batoo.jpa.parser.metadata.TableGeneratorMetadata;
import org.batoo.jpa.parser.metadata.type.EmbeddableMetadata;
import org.batoo.jpa.parser.metadata.type.EntityMetadata;
import org.batoo.jpa.parser.metadata.type.ManagedTypeMetadata;
import org.batoo.jpa.parser.metadata.type.MappedSuperclassMetadata;

public class MetamodelImpl
implements Metamodel {
    private static final BLogger LOG = BLoggerFactory.getLogger(MetamodelImpl.class);
    private static final long POLL_TIMEOUT = 60L;
    private EntityManagerFactoryImpl emf;
    private final JdbcAdaptor jdbcAdaptor;
    private final Map<Class<?>, BasicTypeImpl<?>> basics = Maps.newHashMap();
    private final Map<Class<?>, MappedSuperclassType<?>> mappedSuperclasses = Maps.newHashMap();
    private final Map<Class<?>, EmbeddableType<?>> embeddables = Maps.newHashMap();
    private final Map<Class<?>, EntityTypeImpl<?>> entities = Maps.newHashMap();
    private final Map<String, EntityTypeImpl<?>> entitiesByName = Maps.newHashMap();
    private final Map<String, NamedQueryMetadata> namedQueries = Maps.newHashMap();
    private final CallbackManager callbackManager;
    private final Map<String, SequenceGenerator> sequenceGenerators = Maps.newHashMap();
    private final Map<String, TableGenerator> tableGenerators = Maps.newHashMap();
    private final Map<String, SequenceQueue> sequenceQueues = Maps.newHashMap();
    private final Map<String, TableIdQueue> tableIdQueues = Maps.newHashMap();
    private ThreadPoolExecutor idGeneratorExecuter;

    public MetamodelImpl(EntityManagerFactoryImpl entityManagerFactory, JdbcAdaptor jdbcAdaptor, MetadataImpl metadata) {
        this.emf = entityManagerFactory;
        this.jdbcAdaptor = jdbcAdaptor;
        ArrayList entities = Lists.newArrayList(metadata.getEntityMappings());
        ArrayList sortedEntities = Lists.newArrayList();
        Collections.sort(entities, new Comparator<ManagedTypeMetadata>(){

            @Override
            public int compare(ManagedTypeMetadata o1, ManagedTypeMetadata o2) {
                if (o1 instanceof EmbeddableMetadata) {
                    return -1;
                }
                if (o2 instanceof EmbeddableMetadata) {
                    return 1;
                }
                return 0;
            }
        });
        try {
            while (entities.size() > 0) {
                Iterator i = entities.iterator();
                while (i.hasNext()) {
                    ManagedTypeMetadata entity = (ManagedTypeMetadata)i.next();
                    Class<?> c1 = this.emf.getClassloader().loadClass(entity.getClassName());
                    boolean independent = true;
                    for (ManagedTypeMetadata entity2 : entities) {
                        Class<?> c2;
                        if (entity == entity2 || !(c2 = this.emf.getClassloader().loadClass(entity2.getClassName())).isAssignableFrom(c1)) continue;
                        independent = false;
                        break;
                    }
                    if (!independent) continue;
                    i.remove();
                    sortedEntities.add(entity);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        for (ManagedTypeMetadata type : sortedEntities) {
            try {
                Class<?> clazz = this.emf.getClassloader().loadClass(type.getClassName());
                ManagedType parent = null;
                for (Class<?> currentClass = clazz.getSuperclass(); currentClass != Object.class && parent == null; currentClass = currentClass.getSuperclass()) {
                    parent = this.managedType(currentClass);
                }
                if (type instanceof EntityMetadata) {
                    if (parent != null && !(parent instanceof IdentifiableTypeImpl)) {
                        throw new MappingException("Entities can only extend MappedSuperclasses or other Entities.", type.getLocator(), parent.getLocator());
                    }
                    EntityTypeImpl entity = new EntityTypeImpl(this, (IdentifiableTypeImpl)parent, clazz, (EntityMetadata)type);
                    this.entities.put(entity.getJavaType(), entity);
                    this.entitiesByName.put(entity.getName(), entity);
                    this.entitiesByName.put(entity.getJavaType().getName(), entity);
                } else if (type instanceof MappedSuperclassMetadata) {
                    if (parent != null && !(parent instanceof MappedSuperclassTypeImpl)) {
                        throw new MappingException("MappedSuperclasses can only extend other MappedSuperclasses.", type.getLocator(), parent.getLocator());
                    }
                    MappedSuperclassTypeImpl mappedSuperclass = new MappedSuperclassTypeImpl(this, (MappedSuperclassTypeImpl)parent, clazz, (MappedSuperclassMetadata)type);
                    this.mappedSuperclasses.put(mappedSuperclass.getJavaType(), mappedSuperclass);
                }
                if (!(type instanceof EmbeddableMetadata)) continue;
                if (parent != null && !(parent instanceof EmbeddableTypeImpl)) {
                    throw new MappingException("Embeddables can only extend a other Embeddables.", type.getLocator(), parent.getLocator());
                }
                EmbeddableTypeImpl embeddable = new EmbeddableTypeImpl(this, clazz, (EmbeddableMetadata)type);
                this.embeddables.put(embeddable.getJavaType(), embeddable);
            }
            catch (ClassNotFoundException e) {}
        }
        this.callbackManager = new CallbackManager(metadata.getEntityListeners());
        this.addNamedQueries(metadata.getNamedQueries());
        for (ManagedTypeMetadata entity : entities) {
            if (!(entity instanceof EntityMetadata)) continue;
            this.addNamedQueries(((EntityMetadata)entity).getNamedQueries());
        }
    }

    private void addNamedQueries(List<NamedQueryMetadata> namedQueries) {
        for (NamedQueryMetadata namedQuery : namedQueries) {
            NamedQueryMetadata existing = this.namedQueries.put(namedQuery.getName(), namedQuery);
            if (existing == null) continue;
            throw new MappingException("Duplicate named query with the name: " + namedQuery.getName(), existing.getLocator(), namedQuery.getLocator());
        }
    }

    public synchronized void addSequenceGenerator(SequenceGeneratorMetadata metadata) {
        SequenceGenerator sequenceGenerator = new SequenceGenerator(metadata);
        this.sequenceGenerators.put(sequenceGenerator.getName(), sequenceGenerator);
    }

    public synchronized void addTableGenerator(TableGeneratorMetadata metadata) {
        TableGenerator tableGenerator = new TableGenerator(metadata);
        this.tableGenerators.put(tableGenerator.getName(), tableGenerator);
    }

    public <T> BasicTypeImpl<T> createBasicType(Class<T> clazz) {
        BasicTypeImpl<?> basicType = this.basics.get(clazz);
        if (basicType != null) {
            return basicType;
        }
        return this.lazyCreateBasicType(clazz);
    }

    public void dropAllTables(DataSourceImpl datasource) {
        HashSet tables = Sets.newHashSet();
        for (EntityTypeImpl<?> entity : this.entities.values()) {
            AbstractTable table;
            for (EntityTable entityTable : entity.getTables()) {
                if (entityTable.getEntity() != entity) continue;
                tables.add(entityTable);
            }
            for (AssociationMapping<?, ?, ?> associationMapping : entity.getAssociations()) {
                table = associationMapping.getTable();
                if (table == null || table.getEntity() != entity) continue;
                tables.add(table);
            }
            for (PluralMapping<?, ?, ?> pluralMapping : entity.getMappingsPlural()) {
                if (pluralMapping.isAssociation() || (table = (AbstractTable)((Object)pluralMapping.getTable())) == null) continue;
                tables.add(table);
            }
        }
        try {
            this.jdbcAdaptor.dropAllForeignKeys(datasource, tables);
            this.jdbcAdaptor.dropAllTables(datasource, tables);
            this.jdbcAdaptor.dropAllSequences(datasource, this.sequenceGenerators.values());
        }
        catch (SQLException e) {
            throw new PersistenceException("Cannot drop tables", (Throwable)e);
        }
    }

    public <X> EmbeddableTypeImpl<X> embeddable(Class<X> clazz) {
        return (EmbeddableTypeImpl)this.embeddables.get(clazz);
    }

    public <X> EntityTypeImpl<X> entity(Class<X> clazz) {
        return this.entities.get(clazz);
    }

    public <X> EntityTypeImpl<X> entity(String name) {
        return this.entitiesByName.get(name);
    }

    public void fireCallbacks(Object instance, EntityListenerMetadata.EntityListenerType type) {
        this.callbackManager.fireCallbacks(instance, type);
    }

    public CallbackManager getCallbackManager() {
        return this.callbackManager;
    }

    public Set<EmbeddableType<?>> getEmbeddables() {
        return Sets.newHashSet(this.embeddables.values());
    }

    public Set<EntityType<?>> getEntities() {
        HashSet entities = Sets.newHashSet();
        for (EntityType entityType : this.entities.values()) {
            entities.add(entityType);
        }
        return entities;
    }

    public EntityTypeImpl<?> getEntity(Class<?> clazz) {
        EntityType entity = null;
        while (entity == null && clazz != Object.class && (entity = this.entity(clazz)) == null) {
            clazz = clazz.getSuperclass();
        }
        return entity;
    }

    public EntityManagerFactoryImpl getEntityManagerFactory() {
        return this.emf;
    }

    public Set<IdentifiableType<?>> getIdentifiables() {
        HashSet identifiables = Sets.newHashSet();
        identifiables.addAll(this.mappedSuperclasses.values());
        identifiables.addAll(this.entities.values());
        return identifiables;
    }

    public JdbcAdaptor getJdbcAdaptor() {
        return this.jdbcAdaptor;
    }

    public Set<ManagedType<?>> getManagedTypes() {
        HashSet managedTypes = Sets.newHashSet();
        managedTypes.addAll(this.embeddables.values());
        managedTypes.addAll(this.mappedSuperclasses.values());
        managedTypes.addAll(this.entities.values());
        return managedTypes;
    }

    public Collection<NamedQueryMetadata> getNamedQueries() {
        return this.namedQueries.values();
    }

    public Long getNextSequence(String generator) {
        try {
            return this.sequenceQueues.get(generator).poll(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new PersistenceException("Unable to retrieve next sequence " + generator + " in allowed " + 60L + " seconds");
        }
    }

    public Object getNextTableValue(String generator) {
        try {
            return this.tableIdQueues.get(generator).poll(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new PersistenceException("Unable to retrieve next sequence " + generator + " in allowed " + 60L + " seconds");
        }
    }

    private synchronized <X> BasicTypeImpl<X> lazyCreateBasicType(Class<X> clazz) {
        if (clazz.getAnnotation(Entity.class) != null || clazz.getAnnotation(MappedSuperclass.class) != null || clazz.getAnnotation(Embeddable.class) != null) {
            return null;
        }
        if (Serializable.class.isAssignableFrom(clazz) || clazz.isPrimitive()) {
            BasicTypeImpl<X> basicType = new BasicTypeImpl<X>(this, clazz);
            this.basics.put(clazz, basicType);
            return basicType;
        }
        return null;
    }

    public <X> ManagedTypeImpl<X> managedType(Class<X> clazz) {
        ManagedTypeImpl managedType = (ManagedTypeImpl)this.embeddables.get(clazz);
        if (managedType != null) {
            return managedType;
        }
        managedType = (ManagedTypeImpl)this.mappedSuperclasses.get(clazz);
        if (managedType != null) {
            return managedType;
        }
        return this.entities.get(clazz);
    }

    public void performForeignKeysDdl(DataSourceImpl datasource, DDLMode ddlMode, EntityTypeImpl<?> entity) {
        AbstractTable table;
        if (ddlMode == DDLMode.NONE) {
            return;
        }
        LOG.info("Performing foreign key DDL operations for entiy {0}, mode {1}", new Object[]{entity.getName(), ddlMode});
        for (EntityTable entityTable : entity.getTables()) {
            if (entityTable.getEntity() != entity) continue;
            LOG.info("Performing foreign key DDL operations for table {0}, mode {1}", new Object[]{entityTable.getName(), ddlMode});
            for (ForeignKey foreignKey : entityTable.getForeignKeys()) {
                this.jdbcAdaptor.createForeignKey(datasource, foreignKey);
            }
        }
        for (AssociationMapping<?, ?, ?> associationMapping : entity.getAssociations()) {
            table = associationMapping.getTable();
            if (table == null || ((JoinTable)table).getEntity() != entity) continue;
            LOG.info("Performing foreign key DDL operations for join table {0}, mode {1}", new Object[]{table.getName(), ddlMode});
            for (ForeignKey foreignKey : table.getForeignKeys()) {
                this.jdbcAdaptor.createForeignKey(datasource, foreignKey);
            }
        }
        for (PluralMapping<?, ?, ?> pluralMapping : entity.getMappingsPlural()) {
            if (pluralMapping.isAssociation()) continue;
            table = (AbstractTable)((Object)pluralMapping.getTable());
            LOG.info("Performing foreign key DDL operations for join table {0}, mode {1}", new Object[]{table.getName(), ddlMode});
            for (ForeignKey foreignKey : table.getForeignKeys()) {
                this.jdbcAdaptor.createForeignKey(datasource, foreignKey);
            }
        }
    }

    public void performSequencesDdl(DataSourceImpl datasource, DDLMode ddlMode) {
        for (SequenceGenerator sequenceGenerator : this.sequenceGenerators.values()) {
            LOG.info("Performing DDL operations for sequence generators for {0}, mode {1}", new Object[]{sequenceGenerator.getName(), ddlMode});
            this.jdbcAdaptor.createSequenceIfNecessary(datasource, sequenceGenerator);
        }
    }

    public void performTableGeneratorsDdl(DataSourceImpl datasource, DDLMode ddlMode) {
        for (TableGenerator tableGenerator : this.tableGenerators.values()) {
            LOG.info("Performing DDL operations for sequence generators for mode table {1}, mode {0}", new Object[]{tableGenerator.getName(), ddlMode});
            this.jdbcAdaptor.createTableGeneratorIfNecessary(datasource, tableGenerator);
        }
    }

    public void performTablesDdl(DataSourceImpl datasource, DDLMode ddlMode, EntityTypeImpl<?> entity) {
        AbstractTable table;
        LOG.info("Performing DDL operations for entity {0}, mode {1}", new Object[]{entity.getName(), ddlMode});
        for (EntityTable entityTable : entity.getTables()) {
            if (entityTable.getEntity() != entity) continue;
            LOG.info("Performing DDL operations for {0}, mode {1}", new Object[]{entityTable.getName(), ddlMode});
            this.jdbcAdaptor.createOrUpdateTable(entityTable, datasource, ddlMode);
        }
        for (AssociationMapping<?, ?, ?> associationMapping : entity.getAssociations()) {
            table = associationMapping.getTable();
            if (table == null || table.getEntity() != entity) continue;
            this.jdbcAdaptor.createOrUpdateTable(associationMapping.getTable(), datasource, ddlMode);
        }
        for (PluralMapping<?, ?, ?> pluralMapping : entity.getMappingsPlural()) {
            if (pluralMapping.isAssociation()) continue;
            table = (AbstractTable)((Object)pluralMapping.getTable());
            this.jdbcAdaptor.createOrUpdateTable(table, datasource, ddlMode);
        }
    }

    public void preFillGenerators(DataSourceImpl datasource) {
        int nThreads = Runtime.getRuntime().availableProcessors();
        this.idGeneratorExecuter = new ThreadPoolExecutor(1, nThreads, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new GeneratorThreadFactory());
        for (SequenceGenerator sequenceGenerator : this.sequenceGenerators.values()) {
            this.sequenceQueues.put(sequenceGenerator.getName(), new SequenceQueue(this.jdbcAdaptor, datasource, this.idGeneratorExecuter, sequenceGenerator.getSequenceName(), sequenceGenerator.getAllocationSize()));
        }
        for (TableGenerator tableGenerator : this.tableGenerators.values()) {
            this.tableIdQueues.put(tableGenerator.getName(), new TableIdQueue(this.jdbcAdaptor, datasource, this.idGeneratorExecuter, tableGenerator));
        }
    }

    public void stopIdGenerators() {
        this.idGeneratorExecuter.shutdownNow();
        try {
            this.idGeneratorExecuter.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <X> TypeImpl<X> type(Class<X> clazz) {
        BasicTypeImpl<?> basic = this.basics.get(clazz);
        if (basic != null) {
            return basic;
        }
        return this.managedType((Class)clazz);
    }

    public CallbackAvailability updateAvailability(CallbackAvailability availability) {
        return availability.updateAvailability(this.callbackManager);
    }

    private static class GeneratorThreadFactory
    implements ThreadFactory {
        private static volatile int nextThreadNo = 1;

        private GeneratorThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "Id Generator - " + nextThreadNo++);
            thread.setPriority(10);
            return thread;
        }
    }
}

