/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.attribute;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.persistence.EnumType;
import javax.persistence.PersistenceException;
import javax.persistence.TemporalType;
import javax.persistence.metamodel.Attribute;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.attribute.SingularAttributeImpl;
import org.batoo.jpa.core.impl.model.type.BasicTypeImpl;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.type.IdentifiableTypeImpl;
import org.batoo.jpa.core.impl.model.type.ManagedTypeImpl;
import org.batoo.jpa.core.jdbc.IdType;
import org.batoo.jpa.core.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.parser.metadata.GeneratedValueMetadata;
import org.batoo.jpa.parser.metadata.IndexMetadata;
import org.batoo.jpa.parser.metadata.attribute.BasicAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.IdAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.PhysicalAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.VersionAttributeMetadata;

public final class BasicAttribute<X, T>
extends SingularAttributeImpl<X, T> {
    private final BasicTypeImpl<T> type;
    private final boolean optional;
    private final boolean version;
    private final IdType idType;
    private final String generator;
    private final boolean lob;
    private final TemporalType temporalType;
    private final EnumType enumType;
    private final IndexMetadata index;

    public BasicAttribute(IdentifiableTypeImpl<X> declaringType, VersionAttributeMetadata metadata) {
        super(declaringType, metadata);
        this.version = true;
        this.optional = false;
        this.idType = null;
        this.generator = null;
        this.lob = false;
        this.enumType = null;
        this.index = null;
        this.type = this.getDeclaringType().getMetamodel().createBasicType(this.getJavaType());
        this.temporalType = this.getJavaType() == Timestamp.class ? TemporalType.TIMESTAMP : (this.getJavaType() == Date.class ? TemporalType.DATE : (this.getJavaType() == Time.class ? TemporalType.TIME : (this.getJavaType() == java.util.Date.class || this.getJavaType() == Calendar.class ? (metadata.getTemporalType() != null ? metadata.getTemporalType() : TemporalType.TIMESTAMP) : null)));
    }

    public BasicAttribute(ManagedTypeImpl<X> declaringType, BasicAttributeMetadata metadata) {
        super(declaringType, metadata);
        this.version = false;
        this.idType = null;
        this.generator = null;
        this.lob = metadata.isLob();
        this.type = this.getDeclaringType().getMetamodel().createBasicType(this.getJavaType());
        this.optional = metadata.isOptional();
        this.index = metadata.getIndex();
        this.temporalType = java.util.Date.class.isAssignableFrom(this.getJavaType()) || Calendar.class.isAssignableFrom(this.getJavaType()) ? (metadata.getTemporalType() == null ? TemporalType.TIMESTAMP : metadata.getTemporalType()) : null;
        this.enumType = this.getJavaType().getSuperclass() == Enum.class ? (metadata.getEnumType() != null ? metadata.getEnumType() : EnumType.ORDINAL) : null;
    }

    public BasicAttribute(ManagedTypeImpl<X> declaringType, IdAttributeMetadata metadata) {
        super(declaringType, metadata);
        this.version = false;
        this.optional = false;
        this.lob = false;
        this.enumType = null;
        this.index = null;
        this.type = this.getDeclaringType().getMetamodel().createBasicType(this.getJavaType());
        this.temporalType = metadata.getTemporalType();
        JdbcAdaptor jdbcAdaptor = declaringType.getMetamodel().getJdbcAdaptor();
        MetamodelImpl metamodel = declaringType.getMetamodel();
        GeneratedValueMetadata generatedValue = metadata.getGeneratedValue();
        if (generatedValue != null) {
            this.idType = jdbcAdaptor.supports(generatedValue.getStrategy());
            if (StringUtils.isNotBlank((String)generatedValue.getGenerator())) {
                this.generator = generatedValue.getGenerator();
            } else {
                this.generator = "BATOO_ID";
                if (this.idType == IdType.SEQUENCE) {
                    metamodel.addSequenceGenerator(null);
                } else if (this.idType == IdType.TABLE) {
                    metamodel.addTableGenerator(null);
                }
            }
            if (metadata.getSequenceGenerator() != null) {
                metamodel.addSequenceGenerator(metadata.getSequenceGenerator());
            }
            if (metadata.getTableGenerator() != null) {
                metamodel.addTableGenerator(metadata.getTableGenerator());
            }
        } else {
            this.generator = null;
            this.idType = IdType.MANUAL;
        }
    }

    public boolean fillValue(EntityTypeImpl<?> type, ManagedInstance<?> managedInstance, Object instance) {
        Object value = this.get(instance);
        if (value != null) {
            return true;
        }
        if (this.idType == null) {
            if (value == null && (value = type.getMappedId(this.getName(), managedInstance.getInstance())) != null) {
                this.set(instance, value);
                return true;
            }
            throw new PersistenceException("Ids should be manually assigned");
        }
        switch (this.idType) {
            case IDENTITY: {
                return false;
            }
            case MANUAL: {
                if (value == null) {
                    throw new PersistenceException("Manual id cannot be null");
                }
            }
            case SEQUENCE: {
                this.set(instance, this.getMetamodel().getNextSequence(this.generator));
                break;
            }
            case TABLE: {
                this.set(instance, this.getMetamodel().getNextTableValue(this.generator));
            }
        }
        return true;
    }

    public EnumType getEnumType() {
        return this.enumType;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public IndexMetadata getIndex() {
        return this.index;
    }

    @Override
    public PhysicalAttributeMetadata getMetadata() {
        return (PhysicalAttributeMetadata)super.getMetadata();
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        return Attribute.PersistentAttributeType.BASIC;
    }

    public TemporalType getTemporalType() {
        return this.temporalType;
    }

    public BasicTypeImpl<T> getType() {
        return this.type;
    }

    public boolean isAssociation() {
        return false;
    }

    public boolean isId() {
        return this.idType != null;
    }

    public boolean isLob() {
        return this.lob;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isVersion() {
        return this.version;
    }
}

