/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.mapping;

import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.jdbc.AbstractTable;
import org.batoo.jpa.core.impl.jdbc.BasicColumn;
import org.batoo.jpa.core.impl.jdbc.PkColumn;
import org.batoo.jpa.core.impl.jdbc.TypeFactory;
import org.batoo.jpa.core.impl.model.attribute.AttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.BasicAttribute;
import org.batoo.jpa.core.impl.model.mapping.ElementMapping;
import org.batoo.jpa.core.impl.model.mapping.EmbeddedMapping;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.core.impl.model.mapping.ParentMapping;
import org.batoo.jpa.core.impl.model.mapping.SingularMapping;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.type.MappedSuperclassTypeImpl;
import org.batoo.jpa.core.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.metadata.ColumnMetadata;

public class BasicMapping<Z, X>
extends Mapping<Z, X, X>
implements SingularMapping<Z, X> {
    private final BasicAttribute<? super Z, X> attribute;
    private final BasicColumn column;

    public BasicMapping(ParentMapping<?, Z> parent, BasicAttribute<? super Z, X> attribute) {
        super(parent, attribute, attribute.getJavaType(), attribute.getName());
        this.attribute = attribute;
        ColumnMetadata columnMetadata = this.getColumnMetadata();
        int sqlType = TypeFactory.getSqlType(this.attribute.getJavaType(), attribute.getTemporalType(), attribute.getEnumType(), attribute.isLob());
        JdbcAdaptor jdbcAdaptor = attribute.getMetamodel().getJdbcAdaptor();
        this.column = this.attribute.isId() || this.getParent().isId() ? new PkColumn(jdbcAdaptor, this, sqlType, columnMetadata) : new BasicColumn(jdbcAdaptor, this, sqlType, columnMetadata);
        String tableName = this.column.getTableName();
        if (this.getRoot().isEntity()) {
            EntityTypeImpl type = (EntityTypeImpl)this.getRoot().getType();
            if (StringUtils.isBlank((String)tableName)) {
                this.column.setTable(type.getPrimaryTable());
            } else {
                AbstractTable table = type.getTable(tableName);
                if (table == null) {
                    throw new MappingException("Table " + tableName + " could not be found", this.column.getLocator());
                }
                this.column.setTable(table);
            }
        } else {
            this.column.setTable(((ElementMapping)this.getRoot()).getCollectionTable());
        }
    }

    @Override
    public boolean fillValue(EntityTypeImpl<?> type, ManagedInstance<?> managedInstance, Object instance) {
        return this.attribute.fillValue(type, managedInstance, instance);
    }

    @Override
    public BasicAttribute<? super Z, X> getAttribute() {
        return this.attribute;
    }

    public BasicColumn getColumn() {
        return this.column;
    }

    private ColumnMetadata getColumnMetadata() {
        ColumnMetadata metadata = null;
        String path = this.getParent().getRootPath(this.attribute.getName());
        AttributeImpl<Z, Z> rootAttribute = this.getParent().getRootAttribute(this.attribute);
        if (rootAttribute.getDeclaringType() == this.getRoot().getType() && this.getParent() instanceof EmbeddedMapping && (metadata = ((EmbeddedMapping)this.getParent()).getAttributeOverride(path)) != null) {
            return metadata;
        }
        if (rootAttribute.getDeclaringType() == this.getRoot().getType() && this.getParent() instanceof EmbeddedMapping && (metadata = ((EmbeddedMapping)this.getParent()).getAttributeOverride(path)) != null) {
            return metadata;
        }
        if (rootAttribute.getDeclaringType() instanceof MappedSuperclassTypeImpl && (metadata = ((EntityTypeImpl)this.getRoot().getType()).getAttributeOverride(path)) != null) {
            return metadata;
        }
        if (this.getParent() instanceof EmbeddedMapping && (metadata = ((EmbeddedMapping)this.getParent()).getAttributeOverride(path)) != null) {
            return metadata;
        }
        return this.attribute.getMetadata().getColumn();
    }
}

