/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.mapping;

import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.attribute.AttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.EmbeddedAttribute;
import org.batoo.jpa.core.impl.model.mapping.EmbeddedMapping;
import org.batoo.jpa.core.impl.model.mapping.ParentMapping;
import org.batoo.jpa.core.impl.model.mapping.RootMapping;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;

public abstract class Mapping<Z, X, Y> {
    private final ParentMapping<?, Z> parent;
    private final String path;
    private final Class<X> javaType;
    private final String name;
    private final MetamodelImpl metamodel;
    private final boolean root;
    private final boolean inherited;
    private final EntityTypeImpl<?> entity;
    private final AttributeImpl<? super Z, X> attribute;
    private int h;

    public Mapping(ParentMapping<?, Z> parent, AttributeImpl<? super Z, X> attribute, Class<X> javaType, String name) {
        this.javaType = javaType;
        this.parent = parent;
        this.attribute = attribute;
        this.name = name;
        this.metamodel = attribute != null ? attribute.getMetamodel() : null;
        this.path = parent != null && parent.getPath() != null ? parent.getPath() + "." + name : name;
        this.root = parent instanceof RootMapping;
        this.entity = (EntityTypeImpl)(this.getRoot().isEntity() ? this.getRoot().getType() : null);
        this.inherited = this.entity != null && this.entity.getRootType().getInheritanceType() != null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Mapping other = (Mapping)obj;
        return this.getPath().equals(other.getPath());
    }

    public final X get(Object instance) {
        if (!this.root && (instance = this.getParent().get(instance)) == null) {
            return null;
        }
        return this.attribute.get(instance);
    }

    public abstract AttributeImpl<? super Z, X> getAttribute();

    public Class<X> getJavaType() {
        return this.javaType;
    }

    public String getName() {
        return this.name;
    }

    public ParentMapping<?, Z> getParent() {
        return this.parent;
    }

    public String getPath() {
        return this.path;
    }

    public RootMapping<?> getRoot() {
        return this.parent.getRoot();
    }

    public int hashCode() {
        if (this.h != 0) {
            return this.h;
        }
        StringBuilder sb = new StringBuilder(this.getRoot().getType().getName());
        if (this.path != null) {
            sb.append(".").append(this.path);
        }
        this.h = this.path.toString().hashCode();
        return this.h;
    }

    public final void set(Object instance, Object value) {
        if (!this.root) {
            Object newInstance = this.parent.get(instance);
            if (newInstance == null) {
                newInstance = ((EmbeddedAttribute)((EmbeddedMapping)this.parent).getAttribute()).newInstance();
                this.parent.set(instance, newInstance);
                instance = newInstance;
            } else {
                instance = newInstance;
            }
        }
        if (!this.inherited) {
            this.attribute.set(instance, value);
        } else {
            EntityTypeImpl<?> type = this.metamodel.getEntity(instance.getClass());
            if (type.extendz(this.entity)) {
                this.attribute.set(instance, value);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getAttribute().toString();
    }
}

