/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.mapping;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.metamodel.Attribute;
import org.batoo.jpa.core.impl.model.attribute.AssociatedSingularAttribute;
import org.batoo.jpa.core.impl.model.attribute.AttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.BasicAttribute;
import org.batoo.jpa.core.impl.model.attribute.EmbeddedAttribute;
import org.batoo.jpa.core.impl.model.attribute.PluralAttributeImpl;
import org.batoo.jpa.core.impl.model.mapping.AssociationMapping;
import org.batoo.jpa.core.impl.model.mapping.BasicMapping;
import org.batoo.jpa.core.impl.model.mapping.ElementCollectionMapping;
import org.batoo.jpa.core.impl.model.mapping.EmbeddedMapping;
import org.batoo.jpa.core.impl.model.mapping.JoinedMapping;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.core.impl.model.mapping.PluralAssociationMapping;
import org.batoo.jpa.core.impl.model.mapping.PluralMapping;
import org.batoo.jpa.core.impl.model.mapping.SingularAssociationMapping;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.type.ManagedTypeImpl;
import org.batoo.jpa.core.impl.model.type.MappedSuperclassTypeImpl;

public abstract class ParentMapping<Z, X>
extends Mapping<Z, X, X> {
    private final Map<String, Mapping<? super X, ?, ?>> children = Maps.newHashMap();
    private JoinedMapping<?, ?, ?>[] eagerMappings;

    public ParentMapping(ParentMapping<?, Z> parent, EmbeddedAttribute<? super Z, X> attribute, Class<X> javaType, String name) {
        super(parent, attribute, javaType, name);
    }

    public void addAssociations(List<AssociationMapping<?, ?, ?>> associations) {
        for (Mapping<? super X, ?, ?> mapping : this.children.values()) {
            if (mapping instanceof AssociationMapping) {
                associations.add((AssociationMapping)mapping);
                continue;
            }
            if (!(mapping instanceof ParentMapping)) continue;
            ((ParentMapping)mapping).addAssociations(associations);
        }
    }

    public void addBasicMappings(List<BasicMapping<?, ?>> mappings) {
        for (Mapping<? super X, ?, ?> mapping : this.children.values()) {
            if (mapping instanceof BasicMapping) {
                mappings.add((BasicMapping)mapping);
                continue;
            }
            if (!(mapping instanceof ParentMapping)) continue;
            ((ParentMapping)mapping).addBasicMappings(mappings);
        }
    }

    public void addJoinedMappings(List<JoinedMapping<?, ?, ?>> mappingsJoined) {
        for (Mapping<? super X, ?, ?> mapping : this.children.values()) {
            if (mapping instanceof JoinedMapping) {
                JoinedMapping joinedMapping = (JoinedMapping)((Object)mapping);
                if (!joinedMapping.isJoined()) continue;
                mappingsJoined.add(joinedMapping);
                continue;
            }
            if (!(mapping instanceof ParentMapping)) continue;
            ((ParentMapping)mapping).addJoinedMappings(mappingsJoined);
        }
    }

    public void addPluralMappings(List<PluralMapping<?, ?, ?>> elementCollections) {
        for (Mapping<? super X, ?, ?> mapping : this.children.values()) {
            if (mapping instanceof PluralMapping) {
                elementCollections.add((PluralMapping)((Object)mapping));
                continue;
            }
            if (!(mapping instanceof ParentMapping)) continue;
            ((ParentMapping)mapping).addPluralMappings(elementCollections);
        }
    }

    public void addSingularMappings(List<Mapping<?, ?, ?>> mappings) {
        for (Mapping<X, ?, ?> mapping : this.children.values()) {
            if (mapping instanceof ParentMapping) {
                ((ParentMapping)mapping).addSingularMappings(mappings);
                continue;
            }
            if (mapping.getAttribute().isCollection()) continue;
            mappings.add(mapping);
        }
    }

    private <Y> void createBasicMapping(BasicAttribute<? super X, Y> attribute) {
        this.children.put(attribute.getName(), new BasicMapping<X, Y>(this, attribute));
    }

    private <C, E> void createElementCollectionMapping(PluralAttributeImpl<? super X, C, E> attribute) {
        this.children.put(attribute.getName(), new ElementCollectionMapping<X, C, E>(this, attribute));
    }

    private <Y> void createEmbeddedMapping(EmbeddedAttribute<? super X, Y> attribute) {
        EmbeddedMapping<X, Y> mapping = new EmbeddedMapping<X, Y>(this, attribute);
        this.children.put(attribute.getName(), mapping);
        mapping.createMappings();
    }

    private void createMapping(Attribute<? super X, ?> attribute) {
        switch (attribute.getPersistentAttributeType()) {
            case BASIC: {
                this.createBasicMapping((BasicAttribute)attribute);
                break;
            }
            case ELEMENT_COLLECTION: {
                this.createElementCollectionMapping((PluralAttributeImpl)attribute);
                break;
            }
            case ONE_TO_ONE: 
            case MANY_TO_ONE: {
                this.createSingularAssociationMapping((AssociatedSingularAttribute)attribute);
                break;
            }
            case MANY_TO_MANY: 
            case ONE_TO_MANY: {
                this.createPluralAssociationMapping((PluralAttributeImpl)attribute);
                break;
            }
            case EMBEDDED: {
                this.createEmbeddedMapping((EmbeddedAttribute)attribute);
            }
        }
    }

    public void createMappings() {
        for (Attribute<X, ?> attribute : this.getType().getAttributes()) {
            EntityTypeImpl type;
            if (attribute.getDeclaringType() != this.getType() && (attribute.getDeclaringType() instanceof MappedSuperclassTypeImpl ? (type = (EntityTypeImpl)this.getType()).getRootType() != type : attribute.getDeclaringType() instanceof EntityTypeImpl)) continue;
            this.createMapping(attribute);
        }
    }

    private <C, E> void createPluralAssociationMapping(PluralAttributeImpl<? super X, C, E> attribute) {
        this.children.put(attribute.getName(), new PluralAssociationMapping<X, C, E>(this, attribute));
    }

    private <Y> void createSingularAssociationMapping(AssociatedSingularAttribute<? super X, Y> attribute) {
        this.children.put(attribute.getName(), new SingularAssociationMapping<X, Y>(this, attribute));
    }

    public Mapping<? super X, ?, ?> getChild(String name) {
        return this.children.get(name);
    }

    public Collection<Mapping<? super X, ?, ?>> getChildren() {
        return this.children.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JoinedMapping<?, ?, ?>[] getEagerMappings() {
        if (this.eagerMappings != null) {
            return this.eagerMappings;
        }
        ParentMapping parentMapping = this;
        synchronized (parentMapping) {
            if (this.eagerMappings != null) {
                return this.eagerMappings;
            }
            ArrayList eagerMappings = Lists.newArrayList();
            for (Mapping<? super X, ?, ?> mapping : this.children.values()) {
                JoinedMapping joinedMapping;
                if (!(mapping instanceof JoinedMapping) || !(joinedMapping = (JoinedMapping)((Object)mapping)).isEager()) continue;
                eagerMappings.add(joinedMapping);
            }
            JoinedMapping[] eagerMappings0 = new JoinedMapping[eagerMappings.size()];
            eagerMappings.toArray(eagerMappings0);
            this.eagerMappings = eagerMappings0;
            return eagerMappings0;
        }
    }

    public AttributeImpl<?, ?> getRootAttribute(AttributeImpl<?, ?> attribute) {
        return this.getParent() instanceof EmbeddedMapping ? this.getParent().getAttribute() : attribute;
    }

    public String getRootPath(String path) {
        return this.getParent() instanceof EmbeddedMapping ? this.getParent().getAttribute().getName() + "." + path : path;
    }

    public abstract ManagedTypeImpl<? super X> getType();

    protected void inherit(Collection<Mapping<? super X, ?, ?>> children) {
        for (Mapping<X, ?, ?> mapping : children) {
            this.children.put(mapping.getName(), mapping);
        }
    }

    public abstract boolean isId();
}

