/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.mapping;

import java.sql.SQLException;
import java.util.IdentityHashMap;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.TypedQuery;
import javax.persistence.metamodel.Attribute;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.jdbc.ConnectionImpl;
import org.batoo.jpa.core.impl.jdbc.ForeignKey;
import org.batoo.jpa.core.impl.jdbc.JoinTable;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.attribute.AssociatedSingularAttribute;
import org.batoo.jpa.core.impl.model.attribute.BasicAttribute;
import org.batoo.jpa.core.impl.model.mapping.AssociationMapping;
import org.batoo.jpa.core.impl.model.mapping.BasicMapping;
import org.batoo.jpa.core.impl.model.mapping.JoinedMapping;
import org.batoo.jpa.core.impl.model.mapping.ParentMapping;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.util.Pair;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.impl.AbstractLocator;
import org.batoo.jpa.parser.metadata.AssociationMetadata;

public class SingularAssociationMapping<Z, X>
extends AssociationMapping<Z, X, X> {
    private final AssociatedSingularAttribute<? super Z, X> attribute;
    private final JoinTable joinTable;
    private final ForeignKey foreignKey;
    private EntityTypeImpl<X> type;
    private AssociationMapping<?, ?, ?> inverse;

    public SingularAssociationMapping(ParentMapping<?, Z> parent, AssociatedSingularAttribute<? super Z, X> attribute) {
        super(parent, attribute.getMetadata(), attribute);
        this.attribute = attribute;
        AssociationMetadata metadata = this.getAssociationMetadata();
        if (this.isOwner()) {
            if (metadata.getJoinTable() != null) {
                this.joinTable = new JoinTable((EntityTypeImpl)this.getRoot().getType(), metadata.getJoinTable());
                this.foreignKey = null;
            } else {
                this.foreignKey = new ForeignKey(this.getAttribute().getMetamodel().getJdbcAdaptor(), metadata.getJoinColumns());
                this.joinTable = null;
            }
        } else {
            this.joinTable = null;
            this.foreignKey = null;
        }
    }

    @Override
    public void checkTransient(ManagedInstance<?> managedInstance) {
        Object instanceId;
        Object instance = this.get(managedInstance.getInstance());
        if (instance != null && (instanceId = this.type.getInstanceId(instance)) == null) {
            throw new PersistenceException("Instance " + instance + " is not managed");
        }
    }

    @Override
    public Object extractKey(X value) {
        return null;
    }

    @Override
    public void flush(ConnectionImpl connection, ManagedInstance<?> managedInstance, boolean removals, boolean force) throws SQLException {
        if (this.getTable() != null && !removals) {
            Object entity = this.get(managedInstance.getInstance());
            this.getTable().performInsert(connection, managedInstance.getInstance(), null, entity, -1);
        }
    }

    @Override
    public AssociatedSingularAttribute<? super Z, X> getAttribute() {
        return this.attribute;
    }

    @Override
    public ForeignKey getForeignKey() {
        return this.foreignKey;
    }

    @Override
    public AssociationMapping<?, ?, ?> getInverse() {
        return this.inverse;
    }

    @Override
    public JoinedMapping.MappingType getMappingType() {
        return JoinedMapping.MappingType.SINGULAR_ASSOCIATION;
    }

    @Override
    public JoinTable getTable() {
        return this.joinTable;
    }

    @Override
    public EntityTypeImpl<X> getType() {
        return this.type;
    }

    @Override
    public void initialize(ManagedInstance<?> managedInstance) {
        EntityManagerImpl em = managedInstance.getSession().getEntityManager();
        TypedQuery q = em.createQuery(this.getSelectCriteria());
        EntityTypeImpl<?> rootType = managedInstance.getType();
        Object id = managedInstance.getId().getId();
        if (rootType.hasSingleIdAttribute()) {
            q.setParameter(0, id);
        } else {
            int i = 0;
            for (Pair<BasicMapping<?, ?>, BasicAttribute<?, ?>> pair : rootType.getIdMappings()) {
                q.setParameter(i++, pair.getSecond().get(id));
            }
        }
        try {
            Object newParent;
            Object child = q.getSingleResult();
            Object instance = managedInstance.getInstance();
            if (this.getInverse() != null && (newParent = this.getInverse().get(child)) == null && newParent != this) {
                this.getInverse().set(child, instance);
            }
        }
        catch (NoResultException e) {
            // empty catch block
        }
    }

    @Override
    public boolean isAssociation() {
        return true;
    }

    @Override
    public boolean isJoined() {
        return this.joinTable != null || this.foreignKey != null;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public void link() throws MappingException {
        MetamodelImpl metamodel = this.getAttribute().getMetamodel();
        this.type = metamodel.entity(this.attribute.getJavaType());
        if (!this.isOwner()) {
            this.inverse = (AssociationMapping)this.type.getRootMapping().getMapping(this.getMappedBy());
            if (this.inverse == null) {
                throw new MappingException("Cannot find the mappedBy attribute " + this.getMappedBy() + " specified on " + this.attribute.getJavaMember(), new AbstractLocator[0]);
            }
            this.inverse.setInverse(this);
        } else {
            EntityTypeImpl entity = (EntityTypeImpl)this.getRoot().getType();
            if (this.joinTable != null) {
                this.joinTable.link(entity, this.type);
            } else {
                this.foreignKey.link(this, this.type);
            }
        }
    }

    @Override
    public void mergeWith(EntityManagerImpl entityManager, ManagedInstance<?> instance, Object entity, MutableBoolean requiresFlush, IdentityHashMap<Object, Object> processed) {
        Object newEntity = entityManager.mergeImpl(this.get(entity), requiresFlush, processed, this.cascadesMerge());
        Object oldEntity = this.get(instance.getInstance());
        if (oldEntity == newEntity) {
            return;
        }
        if (oldEntity != null && (this.removesOrphans() || this.inverse != null)) {
            if (this.removesOrphans()) {
                entityManager.remove(oldEntity);
            }
            if (this.inverse != null && this.inverse.getAttribute().getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE) {
                ManagedInstance oldInstance = instance.getSession().get(oldEntity);
                this.inverse.set(oldInstance.getInstance(), null);
            }
        }
        this.set(instance.getInstance(), newEntity);
    }

    @Override
    public boolean references(Object instance, Object reference) {
        return this.get(instance) == reference;
    }

    @Override
    public void setInverse(AssociationMapping<?, ?, ?> inverse) {
        this.inverse = inverse;
    }
}

