/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.type;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.InheritanceType;
import javax.persistence.LockModeType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.FetchParent;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.common.reflect.ConstructorAccessor;
import org.batoo.jpa.common.reflect.ReflectHelper;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaBuilderImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.PredicateImpl;
import org.batoo.jpa.core.impl.instance.EnhancedInstance;
import org.batoo.jpa.core.impl.instance.Enhancer;
import org.batoo.jpa.core.impl.instance.ManagedId;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.jdbc.AbstractTable;
import org.batoo.jpa.core.impl.jdbc.BasicColumn;
import org.batoo.jpa.core.impl.jdbc.ConnectionImpl;
import org.batoo.jpa.core.impl.jdbc.DiscriminatorColumn;
import org.batoo.jpa.core.impl.jdbc.EntityTable;
import org.batoo.jpa.core.impl.jdbc.SecondaryTable;
import org.batoo.jpa.core.impl.manager.EntityManagerFactoryImpl;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.attribute.AssociatedSingularAttribute;
import org.batoo.jpa.core.impl.model.attribute.AttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.BasicAttribute;
import org.batoo.jpa.core.impl.model.mapping.AssociationMapping;
import org.batoo.jpa.core.impl.model.mapping.BasicMapping;
import org.batoo.jpa.core.impl.model.mapping.EmbeddedMapping;
import org.batoo.jpa.core.impl.model.mapping.EntityMapping;
import org.batoo.jpa.core.impl.model.mapping.JoinedMapping;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.core.impl.model.mapping.PluralAssociationMapping;
import org.batoo.jpa.core.impl.model.mapping.PluralMapping;
import org.batoo.jpa.core.impl.model.mapping.SingularAssociationMapping;
import org.batoo.jpa.core.impl.model.mapping.SingularMapping;
import org.batoo.jpa.core.impl.model.type.EmbeddableTypeImpl;
import org.batoo.jpa.core.impl.model.type.IdentifiableTypeImpl;
import org.batoo.jpa.core.impl.model.type.TypeImpl;
import org.batoo.jpa.core.util.Pair;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.metadata.AssociationMetadata;
import org.batoo.jpa.parser.metadata.AttributeOverrideMetadata;
import org.batoo.jpa.parser.metadata.ColumnMetadata;
import org.batoo.jpa.parser.metadata.EntityListenerMetadata;
import org.batoo.jpa.parser.metadata.IndexMetadata;
import org.batoo.jpa.parser.metadata.SecondaryTableMetadata;
import org.batoo.jpa.parser.metadata.type.EntityMetadata;
import org.batoo.jpa.util.BatooUtils;

public class EntityTypeImpl<X>
extends IdentifiableTypeImpl<X>
implements EntityType<X> {
    private static final int MAX_DEPTH = 5;
    private final EntityMetadata metadata;
    private final String name;
    private EntityTable primaryTable;
    private final Map<String, EntityTable> tableMap = Maps.newHashMap();
    private EntityTable[] tables;
    private EntityTable[] updateTables;
    private EntityTable[] allTables;
    private final HashMap<String, AssociatedSingularAttribute<? super X, ?>> idMap = Maps.newHashMap();
    private final boolean cachable;
    private final ConstructorAccessor constructor;
    private CriteriaQueryImpl<X> selectCriteria;
    private CriteriaQueryImpl<X> refreshCriteria;
    private int dependencyCount;
    private final HashMap<EntityTypeImpl<?>, AssociationMapping<?, ?, ?>[]> dependencyMap = Maps.newHashMap();
    private BasicMapping<?, ?>[] basicMappings;
    private Mapping<?, ?, ?>[] singularMappings;
    private PluralMapping<?, ?, ?>[] mappingsPluralSorted;
    private PluralMapping<?, ?, ?>[] mappingsPlural;
    private JoinedMapping<?, ?, ?>[] mappingsJoined;
    private AssociationMapping<?, ?, ?>[] associations;
    private AssociationMapping<?, ?, ?>[] associationsDetachable;
    private AssociationMapping<?, ?, ?>[] associationsJoined;
    private AssociationMapping<?, ?, ?>[] associationsNotPersistable;
    private AssociationMapping<?, ?, ?>[] associationsPersistable;
    private AssociationMapping<?, ?, ?>[] associationsRemovable;
    private PluralAssociationMapping<?, ?, ?>[] associationsPlural;
    private SingularAssociationMapping<?, ?>[] associationsSingular;
    private SingularAssociationMapping<?, ?>[] associationsSingularLazy;
    private final Map<Method, Method> idMethods = Maps.newHashMap();
    private SingularMapping<? super X, ?> idMapping;
    private Pair<BasicMapping<? super X, ?>, BasicAttribute<?, ?>>[] idMappings;
    private final InheritanceType inheritanceType;
    private final Map<String, EntityTypeImpl<? extends X>> children = Maps.newHashMap();
    private final String discriminatorValue;
    private DiscriminatorColumn discriminatorColumn;
    private EntityTypeImpl<? super X> rootType;
    private final EntityMapping<X> entityMapping;
    private final List<IndexMetadata> indexes;

    public EntityTypeImpl(MetamodelImpl metamodel, IdentifiableTypeImpl<? super X> parent, Class<X> javaType, EntityMetadata metadata) {
        super(metamodel, parent, javaType, metadata);
        this.name = metadata.getName();
        this.metadata = metadata;
        this.indexes = metadata.getIndexes();
        this.inheritanceType = metadata.getInheritanceType();
        this.discriminatorValue = StringUtils.isNotBlank((String)metadata.getDiscriminatorValue()) ? metadata.getDiscriminatorValue() : this.name;
        this.addAttributes(metadata);
        this.initTables(metadata);
        this.entityMapping = new EntityMapping(this);
        this.linkMappings();
        this.initIndexes();
        this.cachable = this.getCachable(metamodel.getEntityManagerFactory(), metadata);
        if (metadata.getTableGenerator() != null) {
            metamodel.addTableGenerator(metadata.getTableGenerator());
        }
        if (metadata.getSequenceGenerator() != null) {
            metamodel.addSequenceGenerator(metadata.getSequenceGenerator());
        }
        this.constructor = this.enhance();
    }

    @Override
    protected void addAttribute(AttributeImpl<? super X, ?> attribute) {
        AssociatedSingularAttribute singularAttribute;
        super.addAttribute(attribute);
        if ((attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_ONE || attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE) && (singularAttribute = (AssociatedSingularAttribute)attribute).getMapsId() != null) {
            this.idMap.put(singularAttribute.getMapsId(), singularAttribute);
        }
    }

    private ConstructorAccessor enhance() {
        try {
            Class enhancedClass = Enhancer.enhance(this);
            Constructor constructor = enhancedClass.getConstructor(Class.class, SessionImpl.class, Object.class, Boolean.TYPE);
            return ReflectHelper.createConstructor(constructor);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot enhance class: " + this.getJavaType(), e);
        }
    }

    public boolean extendz(EntityTypeImpl<?> parent) {
        EntityTypeImpl supertype = this;
        do {
            if (supertype != parent) continue;
            return true;
        } while ((supertype = supertype.getSupertype()) != null);
        return false;
    }

    public void fireCallbacks(Object instance, EntityListenerMetadata.EntityListenerType type) {
        this.fireCallbacks(true, instance, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityTable[] getAllTables() {
        if (this.allTables != null) {
            return this.allTables;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.allTables != null) {
                return this.allTables;
            }
            HashMap tableMap = Maps.newHashMap();
            this.getAllTables(tableMap);
            EntityTable[] tables = new EntityTable[tableMap.size()];
            tableMap.values().toArray(tables);
            Arrays.sort(tables, new Comparator<EntityTable>(){

                @Override
                public int compare(EntityTable o1, EntityTable o2) {
                    if (o1 instanceof SecondaryTable && !(o2 instanceof SecondaryTable)) {
                        return 1;
                    }
                    if (o2 instanceof SecondaryTable && !(o1 instanceof SecondaryTable)) {
                        return -1;
                    }
                    return o1.getName().compareTo(o2.getName());
                }
            });
            this.allTables = tables;
            return tables;
        }
    }

    private void getAllTables(Map<String, EntityTable> tableMap) {
        tableMap.putAll(this.tableMap);
        for (EntityTypeImpl<? extends X> entityTypeImpl : this.children.values()) {
            if (entityTypeImpl == this) continue;
            super.getAllTables(tableMap);
            tableMap.putAll(entityTypeImpl.tableMap);
        }
    }

    public AssociationMetadata getAssociationOverride(String path) {
        for (AssociationMetadata override : this.metadata.getAssociationOverrides()) {
            if (!override.getName().equals(path)) continue;
            return override;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssociationMapping<?, ?, ?>[] getAssociations() {
        if (this.associations != null) {
            return this.associations;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.associations != null) {
                return this.associations;
            }
            ArrayList associations = Lists.newArrayList();
            this.entityMapping.addAssociations(associations);
            AssociationMapping[] associatedAttributes0 = new AssociationMapping[associations.size()];
            associations.toArray(associatedAttributes0);
            this.associations = associatedAttributes0;
            return associatedAttributes0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssociationMapping<?, ?, ?>[] getAssociationsDetachable() {
        if (this.associationsDetachable != null) {
            return this.associationsDetachable;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.associationsDetachable != null) {
                return this.associationsDetachable;
            }
            ArrayList associationsDetachable = Lists.newArrayList();
            for (AssociationMapping<?, ?, ?> association : this.getAssociations()) {
                if (!association.cascadesDetach()) continue;
                associationsDetachable.add(association);
            }
            AssociationMapping[] associationsDetachable0 = new AssociationMapping[associationsDetachable.size()];
            associationsDetachable.toArray(associationsDetachable0);
            this.associationsDetachable = associationsDetachable0;
            return associationsDetachable0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssociationMapping<?, ?, ?>[] getAssociationsJoined() {
        if (this.associationsJoined != null) {
            return this.associationsJoined;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.associationsJoined != null) {
                return this.associationsJoined;
            }
            ArrayList joinedAssociations = Lists.newArrayList();
            for (AssociationMapping<?, ?, ?> association : this.getAssociations()) {
                if (association.getTable() == null) continue;
                joinedAssociations.add(association);
            }
            AssociationMapping[] joinedAssociations0 = new AssociationMapping[joinedAssociations.size()];
            joinedAssociations.toArray(joinedAssociations0);
            this.associationsJoined = joinedAssociations0;
            return joinedAssociations0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssociationMapping<?, ?, ?>[] getAssociationsNotPersistable() {
        if (this.associationsNotPersistable != null) {
            return this.associationsNotPersistable;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.associationsNotPersistable != null) {
                return this.associationsNotPersistable;
            }
            ArrayList associationsNotPersistable = Lists.newArrayList();
            for (AssociationMapping<?, ?, ?> mapping : this.getAssociations()) {
                if (mapping.cascadesPersist()) continue;
                associationsNotPersistable.add(mapping);
            }
            AssociationMapping[] associationsNotPersistable0 = new AssociationMapping[associationsNotPersistable.size()];
            associationsNotPersistable.toArray(associationsNotPersistable0);
            this.associationsNotPersistable = associationsNotPersistable0;
            return associationsNotPersistable0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssociationMapping<?, ?, ?>[] getAssociationsPersistable() {
        if (this.associationsPersistable != null) {
            return this.associationsPersistable;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.associationsPersistable != null) {
                return this.associationsPersistable;
            }
            ArrayList persistableAssociations = Lists.newArrayList();
            for (AssociationMapping<?, ?, ?> association : this.getAssociations()) {
                if (!association.cascadesPersist()) continue;
                persistableAssociations.add(association);
            }
            AssociationMapping[] persistableAssociations0 = new AssociationMapping[persistableAssociations.size()];
            persistableAssociations.toArray(persistableAssociations0);
            this.associationsPersistable = persistableAssociations0;
            return persistableAssociations0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluralAssociationMapping<?, ?, ?>[] getAssociationsPlural() {
        if (this.associationsPlural != null) {
            return this.associationsPlural;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.associationsPlural != null) {
                return this.associationsPlural;
            }
            ArrayList associationsPlural = Lists.newArrayList();
            for (AssociationMapping<?, ?, ?> mapping : this.getAssociations()) {
                if (!(mapping instanceof PluralAssociationMapping)) continue;
                associationsPlural.add((PluralAssociationMapping)mapping);
            }
            PluralAssociationMapping[] associationsPlural0 = new PluralAssociationMapping[associationsPlural.size()];
            associationsPlural.toArray(associationsPlural0);
            this.associationsPlural = associationsPlural0;
            return associationsPlural0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssociationMapping<?, ?, ?>[] getAssociationsRemovable() {
        if (this.associationsRemovable != null) {
            return this.associationsRemovable;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.associationsRemovable != null) {
                return this.associationsRemovable;
            }
            ArrayList associationsRemovable = Lists.newArrayList();
            for (AssociationMapping<?, ?, ?> association : this.getAssociations()) {
                if (!association.cascadesRemove() && !association.removesOrphans()) continue;
                associationsRemovable.add(association);
            }
            AssociationMapping[] associationsRemovable0 = new AssociationMapping[associationsRemovable.size()];
            associationsRemovable.toArray(associationsRemovable0);
            this.associationsRemovable = associationsRemovable0;
            return associationsRemovable0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingularAssociationMapping<?, ?>[] getAssociationsSingular() {
        if (this.associationsSingular != null) {
            return this.associationsSingular;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.associationsSingular != null) {
                return this.associationsSingular;
            }
            ArrayList associationsSingular = Lists.newArrayList();
            for (AssociationMapping<?, ?, ?> association : this.getAssociations()) {
                if (!(association instanceof SingularAssociationMapping)) continue;
                associationsSingular.add((SingularAssociationMapping)association);
            }
            SingularAssociationMapping[] associationsSingular0 = new SingularAssociationMapping[associationsSingular.size()];
            associationsSingular.toArray(associationsSingular0);
            this.associationsSingular = associationsSingular0;
            return associationsSingular0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingularAssociationMapping<?, ?>[] getAssociationsSingularOwnerLazy() {
        if (this.associationsSingularLazy != null) {
            return this.associationsSingularLazy;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.associationsSingularLazy != null) {
                return this.associationsSingularLazy;
            }
            ArrayList associationsSingularLazy = Lists.newArrayList();
            for (AssociationMapping<?, ?, ?> mapping : this.getAssociations()) {
                SingularAssociationMapping singularMapping;
                if (!(mapping instanceof SingularAssociationMapping) || !(singularMapping = (SingularAssociationMapping)mapping).isOwner() || singularMapping.isEager()) continue;
                associationsSingularLazy.add(singularMapping);
            }
            SingularAssociationMapping[] associationsSingularLazy0 = new SingularAssociationMapping[associationsSingularLazy.size()];
            associationsSingularLazy.toArray(associationsSingularLazy0);
            this.associationsSingularLazy = associationsSingularLazy0;
            return associationsSingularLazy0;
        }
    }

    public ColumnMetadata getAttributeOverride(String path) {
        for (AttributeOverrideMetadata override : this.metadata.getAttributeOverrides()) {
            if (!override.getName().equals(path)) continue;
            return override.getColumn();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicMapping<?, ?>[] getBasicMappings() {
        if (this.basicMappings != null) {
            return this.basicMappings;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.basicMappings != null) {
                return this.basicMappings;
            }
            ArrayList basicMappings = Lists.newArrayList();
            this.entityMapping.addBasicMappings(basicMappings);
            BasicMapping[] basicMappings0 = new BasicMapping[basicMappings.size()];
            basicMappings.toArray(basicMappings0);
            this.basicMappings = basicMappings0;
            return basicMappings0;
        }
    }

    public Class<X> getBindableJavaType() {
        return this.getJavaType();
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.ENTITY_TYPE;
    }

    private boolean getCachable(EntityManagerFactoryImpl emf, EntityMetadata metadata) {
        switch (emf.getCache().getCacheMode()) {
            case ALL: {
                return true;
            }
            case DISABLE_SELECTIVE: {
                return metadata.getCacheable() == null || metadata.getCacheable() != false;
            }
            case UNSPECIFIED: 
            case ENABLE_SELECTIVE: {
                return metadata.getCacheable() != null && metadata.getCacheable() != false;
            }
        }
        return false;
    }

    public EntityTypeImpl<? extends X> getChildType(Object discriminatorValue) {
        return this.children.get(discriminatorValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CriteriaQueryImpl<X> getCriteriaRefresh() {
        if (this.refreshCriteria != null) {
            return this.refreshCriteria;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.refreshCriteria != null) {
                return this.refreshCriteria;
            }
            CriteriaBuilderImpl cb = this.getMetamodel().getEntityManagerFactory().getCriteriaBuilder();
            Object q = cb.createQuery(this.getJavaType());
            ((AbstractCriteriaQueryImpl)q).internal();
            Root r = ((AbstractCriteriaQueryImpl)q).from(this);
            q = ((CriteriaQueryImpl)q).select((Selection)r);
            r.alias(BatooUtils.acronym(this.name).toLowerCase());
            if (this.getRootType().hasSingleIdAttribute()) {
                SingularMapping<X, ?> idMapping = this.getRootType().getIdMapping();
                ParameterExpression pe = cb.parameter(idMapping.getAttribute().getJavaType());
                Path path = r.get(idMapping.getAttribute());
                Predicate predicate = cb.equal((Expression)path, (Expression)pe);
                this.selectCriteria = ((CriteriaQueryImpl)q).where((Expression)predicate);
                return this.selectCriteria;
            }
            ArrayList predicates = Lists.newArrayList();
            for (Pair<BasicMapping<X, ?>, BasicAttribute<?, ?>> pair : this.getIdMappings()) {
                BasicMapping<X, ?> idMapping = pair.getFirst();
                ParameterExpression pe = cb.parameter(idMapping.getAttribute().getJavaType());
                Path path = r.get((SingularAttribute)idMapping.getAttribute());
                Predicate predicate = cb.equal((Expression)path, (Expression)pe);
                predicates.add(predicate);
            }
            this.refreshCriteria = ((CriteriaQueryImpl)q).where(predicates.toArray(new PredicateImpl[predicates.size()]));
            return this.refreshCriteria;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CriteriaQueryImpl<X> getCriteriaSelect() {
        if (this.selectCriteria != null) {
            return this.selectCriteria;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.selectCriteria != null) {
                return this.selectCriteria;
            }
            CriteriaBuilderImpl cb = this.getMetamodel().getEntityManagerFactory().getCriteriaBuilder();
            Object q = cb.createQuery(this.getJavaType());
            ((AbstractCriteriaQueryImpl)q).internal();
            Root r = ((AbstractCriteriaQueryImpl)q).from(this);
            q = ((CriteriaQueryImpl)q).select((Selection)r);
            r.alias(BatooUtils.acronym(this.name).toLowerCase());
            this.prepareEagerJoins((FetchParent<?, ?>)r, 0, null);
            if (this.getRootType().hasSingleIdAttribute()) {
                SingularMapping<X, ?> idMapping = this.getRootType().getIdMapping();
                ParameterExpression pe = cb.parameter(idMapping.getAttribute().getJavaType());
                Path path = r.get(idMapping.getAttribute());
                Predicate predicate = cb.equal((Expression)path, (Expression)pe);
                this.selectCriteria = ((CriteriaQueryImpl)q).where((Expression)predicate);
                return this.selectCriteria;
            }
            ArrayList predicates = Lists.newArrayList();
            for (Pair<BasicMapping<X, ?>, BasicAttribute<?, ?>> pair : this.getIdMappings()) {
                BasicMapping<X, ?> idMapping = pair.getFirst();
                ParameterExpression pe = cb.parameter(idMapping.getAttribute().getJavaType());
                Path path = r.get((SingularAttribute)idMapping.getAttribute());
                Predicate predicate = cb.equal((Expression)path, (Expression)pe);
                predicates.add(predicate);
            }
            this.selectCriteria = ((CriteriaQueryImpl)q).where(predicates.toArray(new PredicateImpl[predicates.size()]));
            return this.selectCriteria;
        }
    }

    public AssociationMapping<?, ?, ?>[] getDependenciesFor(EntityTypeImpl<?> associate) {
        return this.dependencyMap.get(associate);
    }

    public int getDependencyCount() {
        return this.dependencyCount;
    }

    public DiscriminatorColumn getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    public Set<String> getDiscriminators() {
        return this.children.keySet();
    }

    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public SingularMapping<? super X, ?> getIdMapping() {
        if (this.idMapping != null) {
            return this.idMapping;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.idMapping != null) {
                return this.idMapping;
            }
            for (Mapping mapping : this.entityMapping.getChildren()) {
                if (!(mapping instanceof SingularMapping) || !((SingularMapping)((Object)mapping)).getAttribute().isId()) continue;
                this.idMapping = (SingularMapping)((Object)mapping);
                return this.idMapping;
            }
            throw new NullPointerException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<BasicMapping<? super X, ?>, BasicAttribute<?, ?>>[] getIdMappings() {
        if (this.idMappings != null) {
            return this.idMappings;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.idMappings != null) {
                return this.idMappings;
            }
            EmbeddableTypeImpl idType = (EmbeddableTypeImpl)this.getIdType();
            ArrayList idMappings = Lists.newArrayList();
            for (Mapping mapping : this.entityMapping.getChildren()) {
                if (!(mapping instanceof SingularMapping) || !((SingularMapping)((Object)mapping)).getAttribute().isId()) continue;
                BasicMapping basicMapping = (BasicMapping)mapping;
                Attribute attribute = idType.getAttribute(mapping.getName());
                if (attribute == null || attribute.getJavaType() != mapping.getJavaType()) {
                    throw new MappingException("Attribute types mismatch: " + attribute.getJavaMember() + ", " + mapping.getJavaType(), attribute.getLocator(), basicMapping.getAttribute().getLocator());
                }
                BasicAttribute basicAttribute = (BasicAttribute)attribute;
                idMappings.add(new Pair<BasicMapping, BasicAttribute>(basicMapping, basicAttribute));
            }
            Pair[] idMappings0 = new Pair[idMappings.size()];
            idMappings.toArray(idMappings0);
            this.idMappings = idMappings0;
        }
        return this.idMappings;
    }

    public InheritanceType getInheritanceType() {
        return this.inheritanceType;
    }

    public Object getInstanceId(X instance) {
        if (this.getIdMapping() != null) {
            return this.idMapping.get(instance);
        }
        Object id = ((EmbeddableTypeImpl)this.getIdType()).newInstance();
        for (Pair<BasicMapping<X, ?>, BasicAttribute<?, ?>> pair : this.getIdMappings()) {
            Object value = pair.getSecond().get(instance);
            pair.getFirst().getAttribute().set(id, value);
        }
        return id;
    }

    public ManagedInstance<X> getManagedInstance(SessionImpl session, X instance) {
        if (instance == null) {
            throw new NullPointerException();
        }
        return new ManagedInstance<X>(this, session, instance);
    }

    public ManagedInstance<X> getManagedInstanceById(SessionImpl session, ManagedId<X> id, boolean lazy) {
        try {
            Object instance = this.constructor.newInstance(new Object[]{this.getJavaType(), session, id.getId(), !lazy});
            ManagedInstance<Object> managedInstance = new ManagedInstance<Object>(this, session, instance, id);
            ((EnhancedInstance)instance).__enhanced__$$__setManagedInstance(managedInstance);
            return managedInstance;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getMappedId(String name, Object instance) {
        AssociatedSingularAttribute<X, ?> attribute = this.idMap.get(name);
        if (attribute == null) {
            return null;
        }
        Object mappedEntity = attribute.get(instance);
        if (mappedEntity == null) {
            return null;
        }
        EntityType entity = this.getMetamodel().entity(mappedEntity.getClass());
        if (entity.hasSingleIdAttribute()) {
            SingularMapping<X, ?> idMapping = entity.getIdMapping();
            return idMapping.get(mappedEntity);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JoinedMapping<?, ?, ?>[] getMappingsJoined() {
        if (this.mappingsJoined != null) {
            return this.mappingsJoined;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.mappingsJoined != null) {
                return this.mappingsJoined;
            }
            ArrayList mappingsJoined = Lists.newArrayList();
            this.entityMapping.addJoinedMappings(mappingsJoined);
            JoinedMapping[] mappingsJoined0 = new JoinedMapping[mappingsJoined.size()];
            mappingsJoined.toArray(mappingsJoined0);
            this.mappingsJoined = mappingsJoined0;
            return mappingsJoined0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluralMapping<?, ?, ?>[] getMappingsPlural() {
        if (this.mappingsPlural != null) {
            return this.mappingsPlural;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.mappingsPlural != null) {
                return this.mappingsPlural;
            }
            ArrayList mappingsPlural = Lists.newArrayList();
            this.entityMapping.addPluralMappings(mappingsPlural);
            PluralMapping[] mappingsPlural0 = new PluralMapping[mappingsPlural.size()];
            mappingsPlural.toArray(mappingsPlural0);
            this.mappingsPlural = mappingsPlural0;
            return mappingsPlural0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluralMapping<?, ?, ?>[] getMappingsPluralSorted() {
        if (this.mappingsPluralSorted != null) {
            return this.mappingsPluralSorted;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.mappingsPluralSorted != null) {
                return this.mappingsPluralSorted;
            }
            ArrayList mappingsPluralSorted = Lists.newArrayList();
            for (PluralMapping<?, ?, ?> mapping : this.getMappingsPlural()) {
                if (!StringUtils.isNotBlank((String)mapping.getOrderBy())) continue;
                mappingsPluralSorted.add(mapping);
            }
            PluralMapping[] mappingsPluralSorted0 = new PluralMapping[mappingsPluralSorted.size()];
            mappingsPluralSorted.toArray(mappingsPluralSorted0);
            this.mappingsPluralSorted = mappingsPluralSorted0;
            return mappingsPluralSorted0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mapping<?, ?, ?>[] getMappingsSingular() {
        if (this.singularMappings != null) {
            return this.singularMappings;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.singularMappings != null) {
                return this.singularMappings;
            }
            ArrayList singularMappings = Lists.newArrayList();
            this.entityMapping.addSingularMappings(singularMappings);
            Mapping[] singularMappings0 = new Mapping[singularMappings.size()];
            singularMappings.toArray(singularMappings0);
            this.singularMappings = singularMappings0;
            return singularMappings0;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public EntityTypeImpl<? super X> getParent() {
        if (this.isRoot()) {
            return null;
        }
        return (EntityTypeImpl)this.getSupertype();
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.ENTITY;
    }

    public EntityTable getPrimaryTable() {
        return this.primaryTable;
    }

    public EntityMapping<X> getRootMapping() {
        return this.entityMapping;
    }

    public EntityTypeImpl<? super X> getRootType() {
        if (this.rootType != null) {
            return this.rootType;
        }
        EntityTypeImpl supertype = this;
        while (supertype.getSupertype() instanceof EntityTypeImpl) {
            supertype = (EntityTypeImpl)supertype.getSupertype();
        }
        this.rootType = supertype;
        return this.rootType;
    }

    public AbstractTable getTable(String tableName) {
        if (StringUtils.isBlank((String)tableName)) {
            return this.primaryTable;
        }
        return this.tableMap.get(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityTable[] getTables() {
        if (this.tables != null) {
            return this.tables;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.tables != null) {
                return this.tables;
            }
            EntityTable[] tables = new EntityTable[this.tableMap.size()];
            this.tableMap.values().toArray(tables);
            Arrays.sort(tables, new Comparator<EntityTable>(){

                @Override
                public int compare(EntityTable o1, EntityTable o2) {
                    if (o1 instanceof SecondaryTable && !(o2 instanceof SecondaryTable)) {
                        return 1;
                    }
                    if (o2 instanceof SecondaryTable && !(o1 instanceof SecondaryTable)) {
                        return -1;
                    }
                    return o1.getName().compareTo(o2.getName());
                }
            });
            this.tables = tables;
            return tables;
        }
    }

    private void initIndexes() {
        for (BasicMapping<?, ?> basicMapping : this.getBasicMappings()) {
            EntityTable table;
            IndexMetadata index = ((BasicAttribute)basicMapping.getAttribute()).getIndex();
            if (index == null) continue;
            EntityTable entityTable = table = StringUtils.isNotBlank((String)index.getTable()) ? this.tableMap.get(index.getTable()) : this.primaryTable;
            if (table == null) {
                throw new MappingException("Cannot locate table for index " + index.getName(), index.getLocator());
            }
            if (!table.addIndex(index.getName(), basicMapping.getColumn())) continue;
            throw new MappingException("Duplicate index with the same name " + index.getName(), index.getLocator());
        }
        for (IndexMetadata index : this.indexes) {
            EntityTable table;
            EntityTable entityTable = table = StringUtils.isNotBlank((String)index.getTable()) ? this.tableMap.get(index.getTable()) : this.primaryTable;
            if (table == null) {
                throw new MappingException("Cannot locate table for index " + index.getName(), index.getLocator());
            }
            ArrayList columns = Lists.newArrayList();
            for (String path : index.getColumnNames()) {
                Mapping<?, ?, ?> mapping = this.getRootMapping().getMapping(path);
                if (!(mapping instanceof BasicMapping)) {
                    throw new MappingException("Cannot locate the basic path " + path + " for index " + index.getName(), index.getLocator());
                }
                columns.add(((BasicMapping)mapping).getColumn());
            }
            table.addIndex(index.getName(), columns.toArray(new BasicColumn[columns.size()]));
        }
    }

    private void initTables(EntityMetadata metadata) {
        if (this.getRootType().getInheritanceType() != null) {
            switch (this.getRootType().getInheritanceType()) {
                case SINGLE_TABLE: {
                    if (this.getRootType() == this) {
                        this.primaryTable = new EntityTable(this, metadata.getTable());
                        this.tableMap.put(this.primaryTable.getName(), this.primaryTable);
                        break;
                    }
                    EntityTypeImpl supertype = (EntityTypeImpl)this.getSupertype();
                    this.primaryTable = supertype.primaryTable;
                    this.tableMap.putAll(supertype.tableMap);
                    break;
                }
                case JOINED: {
                    if (this.getRootType() == this) {
                        this.primaryTable = new EntityTable(this, metadata.getTable());
                        this.tableMap.put(this.primaryTable.getName(), this.primaryTable);
                        break;
                    }
                    EntityTypeImpl supertype = (EntityTypeImpl)this.getSupertype();
                    this.tableMap.putAll(supertype.tableMap);
                    this.primaryTable = new SecondaryTable(this, metadata.getTable());
                    this.tableMap.put(this.primaryTable.getName(), this.primaryTable);
                    break;
                }
                case TABLE_PER_CLASS: {
                    throw new MappingException("TABLE_PER_CLASS inheritence type is not yet supported", this.getRootType().getLocator());
                }
            }
        } else {
            this.primaryTable = new EntityTable(this, metadata.getTable());
            this.tableMap.put(this.primaryTable.getName(), this.primaryTable);
        }
        for (SecondaryTableMetadata secondaryTableMetadata : metadata.getSecondaryTables()) {
            SecondaryTable secondaryTable = new SecondaryTable(this, secondaryTableMetadata);
            this.tableMap.put(secondaryTableMetadata.getName(), secondaryTable);
        }
    }

    public boolean isCachable() {
        return this.cachable;
    }

    public boolean isIdMethod(Method method) {
        if (this.idMethods.containsKey(method)) {
            return true;
        }
        String methodName = method.getName();
        if (methodName.startsWith("get") && methodName.length() > 3) {
            for (SingularAttribute attribute : this.getSingularAttributes()) {
                String getterName = "get" + StringUtils.capitalize((String)attribute.getName());
                if (!attribute.isId() || !getterName.equals(method.getName())) continue;
                this.idMethods.put(method, method);
                return true;
            }
        }
        return false;
    }

    public boolean isRoot() {
        return this.getRootType() == this;
    }

    private void linkMappings() {
        if (this.getRootType().getInheritanceType() != null) {
            EntityTypeImpl parent = this;
            do {
                parent.children.put(this.discriminatorValue, this);
            } while ((parent = parent.getSupertype()) instanceof EntityTypeImpl);
        }
        if (this.getRootType() == this && this.inheritanceType != null) {
            this.discriminatorColumn = new DiscriminatorColumn(this, this.metadata.getDiscriminatorColumn());
        }
        this.entityMapping.createMappings();
        for (EntityTable table : this.tableMap.values()) {
            if (!(table instanceof SecondaryTable)) continue;
            ((SecondaryTable)table).link();
        }
    }

    public void performInsert(ConnectionImpl connection, ManagedInstance<X> instance) throws SQLException {
        for (EntityTable table : this.getTables()) {
            table.performInsert(connection, instance);
        }
    }

    public void performRefresh(ConnectionImpl connection, ManagedInstance<X> instance, LockModeType lockMode) {
        SessionImpl session = instance.getSession();
        TypedQuery q = session.getEntityManager().createQuery(this.getCriteriaRefresh());
        q.setLockMode(lockMode);
        Object id = instance.getId().getId();
        if (this.hasSingleIdAttribute()) {
            q.setParameter(0, id);
        } else {
            int i = 0;
            for (Pair<BasicMapping<X, ?>, BasicAttribute<?, ?>> pair : this.getIdMappings()) {
                q.setParameter(i++, pair.getSecond().get(id));
            }
        }
        instance.setRefreshing(true);
        q.getSingleResult();
    }

    public void performRemove(ConnectionImpl connection, ManagedInstance<X> instance) throws SQLException {
        for (EntityTable table : this.getTables()) {
            table.performRemove(connection, instance);
        }
    }

    public X performSelect(EntityManagerImpl entityManager, Object id, LockModeType lockMode) {
        TypedQuery q = entityManager.createQuery(this.getCriteriaSelect());
        q.setLockMode(lockMode);
        if (this.hasSingleIdAttribute()) {
            q.setParameter(0, id);
        } else {
            int i = 0;
            for (Pair<BasicMapping<X, ?>, BasicAttribute<?, ?>> pair : this.getIdMappings()) {
                q.setParameter(i++, pair.getSecond().get(id));
            }
        }
        return q.getSingleResult();
    }

    public Object performSelectVersion(ConnectionImpl connection, ManagedInstance<? extends X> instance) throws SQLException {
        return this.getTables()[0].performSelectVersion(connection, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performUpdate(ConnectionImpl connection, ManagedInstance<X> instance) throws SQLException {
        if (this.updateTables != null) {
            for (EntityTable table : this.updateTables) {
                table.performUpdate(connection, instance);
            }
        } else {
            EntityTypeImpl entityTypeImpl = this;
            synchronized (entityTypeImpl) {
                if (this.updateTables != null) {
                    for (EntityTable table : this.updateTables) {
                        table.performUpdate(connection, instance);
                    }
                } else {
                    ArrayList updateTables = Lists.newArrayList((Object[])this.getTables());
                    Iterator i = updateTables.iterator();
                    while (i.hasNext()) {
                        if (((EntityTable)i.next()).performUpdateWithUpdatability(connection, instance)) continue;
                        i.remove();
                    }
                    this.updateTables = updateTables.toArray(new EntityTable[updateTables.size()]);
                }
            }
        }
    }

    public void performVersionUpdate(ConnectionImpl connection, ManagedInstance<? extends X> instance) throws SQLException {
        this.getTables()[0].performVersionUpdate(connection, instance);
    }

    public void prepareDependenciesFor(EntityTypeImpl<?> associate) {
        HashSet attributes = Sets.newHashSet();
        for (AssociationMapping<?, ?, ?> association : this.getAssociations()) {
            Class javaType;
            if (!association.isOwner() || association.getAttribute().getPersistentAttributeType() != Attribute.PersistentAttributeType.ONE_TO_ONE && association.getAttribute().getPersistentAttributeType() != Attribute.PersistentAttributeType.MANY_TO_ONE || !(javaType = association.getAttribute().getJavaType()).isAssignableFrom(associate.getBindableJavaType())) continue;
            attributes.add(association);
        }
        AssociationMapping[] dependencies = new AssociationMapping[attributes.size()];
        attributes.toArray(dependencies);
        this.dependencyCount += dependencies.length;
        this.dependencyMap.put(associate, dependencies);
    }

    public void prepareEagerJoins(FetchParent<?, ?> r, int depth, AssociationMapping<?, ?, ?> parent) {
        if (depth < 5) {
            this.prepareEagerJoins(r, depth, parent, this.entityMapping.getEagerMappings());
        }
    }

    private void prepareEagerJoins(FetchParent<?, ?> r, int depth, AssociationMapping<?, ?, ?> parent, JoinedMapping<?, ?, ?>[] mappings) {
        for (JoinedMapping<?, ?, ?> mapping : mappings) {
            if (mapping.getMappingType() == JoinedMapping.MappingType.ELEMENT_COLLECTION) {
                r.fetch(mapping.getAttribute().getName(), JoinType.LEFT);
                continue;
            }
            if (mapping.getMappingType() == JoinedMapping.MappingType.EMBEDDABLE) {
                Fetch r2 = r.fetch(mapping.getAttribute().getName(), JoinType.LEFT);
                this.prepareEagerJoins((FetchParent<?, ?>)r2, depth, parent, ((EmbeddedMapping)mapping).getEagerMappings());
                continue;
            }
            AssociationMapping association = (AssociationMapping)mapping;
            if (parent != null && association.getInverse() == parent && parent.getAttribute().getPersistentAttributeType() != Attribute.PersistentAttributeType.MANY_TO_ONE) continue;
            Fetch r2 = r.fetch(mapping.getAttribute().getName(), JoinType.LEFT);
            TypeImpl type = association.getType();
            ((EntityTypeImpl)type).prepareEagerJoins((FetchParent<?, ?>)r2, depth + 1, association);
        }
    }

    public void runValidators(EntityManagerFactoryImpl entityManagerFactory, ManagedInstance<?> instance) {
        Class[] groups;
        ValidatorFactory factory = entityManagerFactory.getValidationFactory();
        Validator validator = factory.usingContext().getValidator();
        switch (instance.getStatus()) {
            case NEW: {
                groups = entityManagerFactory.getPersistValidators();
                break;
            }
            case MANAGED: {
                groups = entityManagerFactory.getUpdateValidators();
                break;
            }
            default: {
                groups = entityManagerFactory.getRemoveValidators();
            }
        }
        Set result = validator.validate(instance.getInstance(), groups);
        if (result != null && result.size() > 0) {
            HashSet violations = Sets.newHashSet();
            for (Object violation : result) {
                violations.add((ConstraintViolation)violation);
            }
            throw new ConstraintViolationException((Set)violations);
        }
    }

    public String toString() {
        return "EntityTypeImpl [name=" + this.name + "]";
    }
}

