/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.type;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.attribute.AssociatedSingularAttribute;
import org.batoo.jpa.core.impl.model.attribute.AttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.BasicAttribute;
import org.batoo.jpa.core.impl.model.attribute.CollectionAttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.EmbeddedAttribute;
import org.batoo.jpa.core.impl.model.attribute.ListAttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.PluralAttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.SetAttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.SingularAttributeImpl;
import org.batoo.jpa.core.impl.model.type.TypeImpl;
import org.batoo.jpa.parser.impl.AbstractLocator;
import org.batoo.jpa.parser.metadata.attribute.AttributesMetadata;
import org.batoo.jpa.parser.metadata.attribute.BasicAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.ElementCollectionAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.EmbeddedAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.ManyToManyAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.ManyToOneAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.OneToManyAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.OneToOneAttributeMetadata;
import org.batoo.jpa.parser.metadata.type.ManagedTypeMetadata;

public abstract class ManagedTypeImpl<X>
extends TypeImpl<X>
implements ManagedType<X> {
    private final AbstractLocator locator;
    private final Map<String, AttributeImpl<X, ?>> declaredAttributes = Maps.newHashMap();
    private final Map<String, SingularAttributeImpl<X, ?>> declaredSingularAttributes = Maps.newHashMap();
    private final Map<String, PluralAttributeImpl<X, ?, ?>> declaredPluralAttributes = Maps.newHashMap();
    private final Map<String, AttributeImpl<? super X, ?>> attributes = Maps.newHashMap();
    private final Map<String, SingularAttributeImpl<? super X, ?>> singularAttributes = Maps.newHashMap();
    private final Map<String, PluralAttributeImpl<? super X, ?, ?>> pluralAttributes = Maps.newHashMap();

    public ManagedTypeImpl(MetamodelImpl metamodel, Class<X> clazz, ManagedTypeMetadata metadata) {
        super(metamodel, clazz);
        this.locator = metadata.getLocator();
    }

    protected void addAttribute(AttributeImpl<? super X, ?> attribute) {
        if (attribute.getDeclaringType() == this) {
            this.declaredAttributes.put(attribute.getName(), attribute);
        }
        this.attributes.put(attribute.getName(), attribute);
        if (attribute instanceof SingularAttribute) {
            if (attribute.getDeclaringType() == this) {
                this.declaredSingularAttributes.put(attribute.getName(), (SingularAttributeImpl)attribute);
            }
            this.singularAttributes.put(attribute.getName(), (SingularAttributeImpl)attribute);
        } else {
            if (attribute.getDeclaringType() == this) {
                this.declaredPluralAttributes.put(attribute.getName(), (PluralAttributeImpl)attribute);
            }
            this.pluralAttributes.put(attribute.getName(), (PluralAttributeImpl)attribute);
        }
    }

    protected void addAttributes(ManagedTypeMetadata typeMetadata) {
        AttributesMetadata attributesMetadata = typeMetadata.getAttributes();
        for (BasicAttributeMetadata basicAttributeMetadata : attributesMetadata.getBasics()) {
            this.addAttribute(new BasicAttribute(this, basicAttributeMetadata));
        }
        for (ElementCollectionAttributeMetadata elementCollectionAttributeMetadata : attributesMetadata.getElementCollections()) {
            this.addAttribute(PluralAttributeImpl.create(this, elementCollectionAttributeMetadata, Attribute.PersistentAttributeType.ELEMENT_COLLECTION));
        }
        for (ManyToOneAttributeMetadata manyToOneAttributeMetadata : attributesMetadata.getManyToOnes()) {
            this.addAttribute(new AssociatedSingularAttribute(this, Attribute.PersistentAttributeType.MANY_TO_ONE, manyToOneAttributeMetadata));
        }
        for (OneToOneAttributeMetadata oneToOneAttributeMetadata : attributesMetadata.getOneToOnes()) {
            this.addAttribute(new AssociatedSingularAttribute(this, Attribute.PersistentAttributeType.ONE_TO_ONE, oneToOneAttributeMetadata));
        }
        for (OneToManyAttributeMetadata oneToManyAttributeMetadata : attributesMetadata.getOneToManies()) {
            this.addAttribute(PluralAttributeImpl.create(this, oneToManyAttributeMetadata, Attribute.PersistentAttributeType.ONE_TO_MANY));
        }
        for (ManyToManyAttributeMetadata manyToManyAttributeMetadata : attributesMetadata.getManyToManies()) {
            this.addAttribute(PluralAttributeImpl.create(this, manyToManyAttributeMetadata, Attribute.PersistentAttributeType.MANY_TO_MANY));
        }
        for (EmbeddedAttributeMetadata embeddedAttributeMetadata : attributesMetadata.getEmbeddeds()) {
            this.addAttribute(new EmbeddedAttribute(this, embeddedAttributeMetadata));
        }
    }

    public AttributeImpl<? super X, ?> getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Set<Attribute<? super X, ?>> getAttributes() {
        HashSet attributes = Sets.newHashSet();
        attributes.addAll(this.attributes.values());
        return attributes;
    }

    public CollectionAttributeImpl<? super X, ?> getCollection(String name) {
        return (CollectionAttributeImpl)this.getAttribute(name);
    }

    public <E> CollectionAttributeImpl<? super X, E> getCollection(String name, Class<E> elementType) {
        return (CollectionAttributeImpl)this.getAttribute(name);
    }

    public AttributeImpl<X, ?> getDeclaredAttribute(String name) {
        return this.declaredAttributes.get(name);
    }

    public Set<Attribute<X, ?>> getDeclaredAttributes() {
        HashSet attributes = Sets.newHashSet();
        attributes.addAll(this.declaredAttributes.values());
        return attributes;
    }

    public CollectionAttributeImpl<X, ?> getDeclaredCollection(String name) {
        return (CollectionAttributeImpl)this.getDeclaredAttribute(name);
    }

    public <E> CollectionAttributeImpl<X, E> getDeclaredCollection(String name, Class<E> elementType) {
        return (CollectionAttributeImpl)this.getDeclaredAttribute(name);
    }

    public ListAttributeImpl<X, ?> getDeclaredList(String name) {
        return (ListAttributeImpl)this.getDeclaredAttribute(name);
    }

    public <E> ListAttributeImpl<X, E> getDeclaredList(String name, Class<E> elementType) {
        return (ListAttributeImpl)this.getDeclaredAttribute(name);
    }

    public MapAttribute<X, ?, ?> getDeclaredMap(String name) {
        return (MapAttribute)this.getDeclaredAttribute(name);
    }

    public <K, V> MapAttribute<X, K, V> getDeclaredMap(String name, Class<K> keyType, Class<V> valueType) {
        return (MapAttribute)this.getDeclaredAttribute(name);
    }

    public Set<PluralAttribute<X, ?, ?>> getDeclaredPluralAttributes() {
        HashSet attributes = Sets.newHashSet();
        attributes.addAll(this.declaredPluralAttributes.values());
        return attributes;
    }

    public SetAttributeImpl<X, ?> getDeclaredSet(String name) {
        return (SetAttributeImpl)this.getDeclaredAttribute(name);
    }

    public <E> SetAttributeImpl<X, E> getDeclaredSet(String name, Class<E> elementType) {
        return (SetAttributeImpl)this.getDeclaredAttribute(name);
    }

    public SingularAttributeImpl<X, ?> getDeclaredSingularAttribute(String name) {
        return (SingularAttributeImpl)this.getDeclaredAttribute(name);
    }

    public <Y> SingularAttributeImpl<X, Y> getDeclaredSingularAttribute(String name, Class<Y> type) {
        return (SingularAttributeImpl)this.getDeclaredAttribute(name);
    }

    public Set<SingularAttribute<X, ?>> getDeclaredSingularAttributes() {
        HashSet attributes = Sets.newHashSet();
        attributes.addAll(this.declaredSingularAttributes.values());
        return attributes;
    }

    public ListAttributeImpl<? super X, ?> getList(String name) {
        return (ListAttributeImpl)this.getAttribute(name);
    }

    public <E> ListAttributeImpl<? super X, E> getList(String name, Class<E> elementType) {
        return (ListAttributeImpl)this.getAttribute(name);
    }

    public AbstractLocator getLocator() {
        return this.locator;
    }

    public MapAttribute<? super X, ?, ?> getMap(String name) {
        return (MapAttribute)this.getAttribute(name);
    }

    public <K, V> MapAttribute<? super X, K, V> getMap(String name, Class<K> keyType, Class<V> valueType) {
        return this.getMap(name);
    }

    public String getName() {
        return this.getJavaType().getSimpleName();
    }

    public Set<PluralAttribute<? super X, ?, ?>> getPluralAttributes() {
        HashSet attributes = Sets.newHashSet();
        attributes.addAll(this.pluralAttributes.values());
        return attributes;
    }

    public SetAttributeImpl<? super X, ?> getSet(String name) {
        return (SetAttributeImpl)this.getAttribute(name);
    }

    public <E> SetAttributeImpl<? super X, E> getSet(String name, Class<E> elementType) {
        return (SetAttributeImpl)this.getAttribute(name);
    }

    public SingularAttributeImpl<? super X, ?> getSingularAttribute(String name) {
        return (SingularAttributeImpl)this.getAttribute(name);
    }

    public <Y> SingularAttributeImpl<? super X, Y> getSingularAttribute(String name, Class<Y> type) {
        return (SingularAttributeImpl)this.getAttribute(name);
    }

    public Set<SingularAttribute<? super X, ?>> getSingularAttributes() {
        HashSet attributes = Sets.newHashSet();
        attributes.addAll(this.singularAttributes.values());
        return attributes;
    }
}

