/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.jdbc.adapter;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.persistence.GenerationType;
import javax.persistence.LockModeType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.common.log.BLogger;
import org.batoo.jpa.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.criteria.expression.NumericFunctionExpression;
import org.batoo.jpa.core.impl.jdbc.AbstractColumn;
import org.batoo.jpa.core.impl.jdbc.AbstractJdbcAdaptor;
import org.batoo.jpa.core.impl.jdbc.AbstractTable;
import org.batoo.jpa.core.impl.jdbc.BasicColumn;
import org.batoo.jpa.core.impl.jdbc.ConnectionImpl;
import org.batoo.jpa.core.impl.jdbc.DataSourceImpl;
import org.batoo.jpa.core.impl.jdbc.EntityTable;
import org.batoo.jpa.core.impl.jdbc.ForeignKey;
import org.batoo.jpa.core.impl.jdbc.JoinColumn;
import org.batoo.jpa.core.impl.jdbc.PkColumn;
import org.batoo.jpa.core.impl.jdbc.dbutils.QueryRunner;
import org.batoo.jpa.core.impl.model.SequenceGenerator;
import org.batoo.jpa.core.impl.model.TableGenerator;
import org.batoo.jpa.core.jdbc.DDLMode;
import org.batoo.jpa.core.jdbc.IdType;
import org.batoo.jpa.core.jdbc.adapter.JdbcColumn;
import org.batoo.jpa.core.jdbc.adapter.JdbcForeignKey;
import org.batoo.jpa.core.jdbc.adapter.JdbcTable;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.impl.AbstractLocator;
import org.batoo.jpa.util.BatooUtils;

public abstract class JdbcAdaptor
extends AbstractJdbcAdaptor {
    private static final String[] TABLE_OR_VIEW = new String[]{"TABLE", "VIEW"};
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final BLogger LOG = BLoggerFactory.getLogger(JdbcAdaptor.class);
    private List<String> words;
    private final Map<AbstractTable, JdbcTable> tables = Maps.newHashMap();

    public JdbcAdaptor() {
        this.loadReservedWords();
    }

    public abstract String applyConcat(List<String> var1);

    public abstract String applyLikeEscape(String var1);

    public abstract String applyLock(String var1, LockModeType var2);

    public abstract String applyPagination(String var1, int var2, int var3);

    public String applySubStr(String innerFragment, String startFragment, String endFragment) {
        return "SUBSTR(" + Joiner.on((String)", ").skipNulls().join(new Object[]{innerFragment, startFragment, endFragment}) + ")";
    }

    public String applyTrim(CriteriaBuilder.Trimspec trimspec, String trimChar, String argument) {
        StringBuilder builder = new StringBuilder("TRIM(");
        if (trimspec != null) {
            builder.append(trimspec.toString()).append(" ");
        }
        if (trimChar != null) {
            builder.append(trimChar).append(" ");
        }
        if (trimspec != null || trimChar != null) {
            builder.append("FROM ");
        }
        return builder.append(argument).append(")").toString();
    }

    public String castBoolean(String sqlFragment) {
        return sqlFragment;
    }

    private String createAlterTableStatement(AbstractTable table, List<AbstractColumn> columnsToAdd) {
        ArrayList ddlColumns = Lists.newArrayList();
        for (AbstractColumn column : columnsToAdd) {
            ddlColumns.add("ADD COLUMN " + this.createColumnDDL(column));
        }
        StringBuilder statement = new StringBuilder();
        statement.append("ALTER TABLE ").append(table.getQName()).append("\n\t");
        statement.append(Joiner.on((String)"\n\t").join((Iterable)ddlColumns));
        return statement.toString();
    }

    public abstract String createColumnDDL(AbstractColumn var1);

    private String createCreateTableStatement(AbstractTable table) {
        ArrayList ddlColumns = Lists.newArrayList();
        ArrayList pkColumns = Lists.newArrayList();
        Collection<AbstractColumn> columns = this.getColumns(table);
        for (AbstractColumn column : columns) {
            ddlColumns.add(this.createColumnDDL(column));
            if (!column.isPrimaryKey()) continue;
            pkColumns.add(column.getName());
        }
        return this.createCreateTableStatement(table, ddlColumns, pkColumns);
    }

    public String createCreateTableStatement(AbstractTable table, List<String> ddlColumns, List<String> pkColumns) {
        String columns = Joiner.on((String)",\n\t").join(ddlColumns);
        String keys = Joiner.on((String)", ").join(pkColumns);
        StringBuilder statement = new StringBuilder();
        statement.append("CREATE TABLE ").append(table.getQName()).append(" (\n\t");
        statement.append(columns);
        if (StringUtils.isNotBlank((String)keys)) {
            statement.append(",");
            statement.append("\nPRIMARY KEY(").append(keys).append(")");
        }
        statement.append(")");
        return statement.toString();
    }

    public synchronized void createForeignKey(DataSourceImpl datasource, ForeignKey foreignKey) {
        QueryRunner runner = new QueryRunner(datasource, this.isPmdBroken());
        try {
            JdbcTable tableMetadata = this.getTableMetadata(datasource, foreignKey.getTable());
            JdbcForeignKey foreignKeyMetadata = tableMetadata.getForeignKey(foreignKey.getName());
            if (foreignKeyMetadata != null) {
                if (!foreignKeyMetadata.matches(foreignKey)) {
                    String sql = this.getDropForeignKeySql(tableMetadata.getSchema(), tableMetadata.getName(), foreignKey.getName());
                    runner.update(sql);
                } else {
                    return;
                }
            }
            String referenceTableName = foreignKey.getReferencedTableName();
            String tableName = foreignKey.getTable().getName();
            String foreignKeyColumns = Joiner.on((String)", ").join((Iterable)Lists.transform(foreignKey.getJoinColumns(), (Function)new Function<JoinColumn, String>(){

                public String apply(JoinColumn input) {
                    return input.getReferencedColumnName();
                }
            }));
            String keyColumns = Joiner.on((String)", ").join((Iterable)Lists.transform(foreignKey.getJoinColumns(), (Function)new Function<JoinColumn, String>(){

                public String apply(JoinColumn input) {
                    return input.getName();
                }
            }));
            String sql = "ALTER TABLE " + tableName + "\n\tADD CONSTRAINT " + foreignKey.getName() + " FOREIGN KEY (" + keyColumns + ")" + "\n\tREFERENCES " + referenceTableName + "(" + foreignKeyColumns + ")";
            runner.update(sql);
        }
        catch (SQLException e) {
            this.logRelaxed(e, "Cannot (re)create foreign key.");
        }
    }

    protected void createIndex(DataSourceImpl datasource, EntityTable table, String indexName, BasicColumn[] columns) throws SQLException {
        String columnNames = Joiner.on((String)", ").join((Iterable)Lists.transform((List)Lists.newArrayList((Object[])columns), (Function)new Function<BasicColumn, String>(){

            public String apply(BasicColumn input) {
                return input.getName();
            }
        }));
        new QueryRunner(datasource, this.isPmdBroken()).update("CREATE INDEX " + indexName + " ON " + table.getQName() + "(" + columnNames + ")");
    }

    private void createIndexes(DataSourceImpl datasource, AbstractTable table) {
        if (table instanceof EntityTable) {
            Map<String, BasicColumn[]> indexes = ((EntityTable)table).getIndexes();
            for (Map.Entry<String, BasicColumn[]> entry : indexes.entrySet()) {
                try {
                    this.createIndex(datasource, (EntityTable)table, entry.getKey(), entry.getValue());
                }
                catch (SQLException e) {
                    LOG.warn(e, "Cannot create index {0}", entry.getKey());
                }
            }
        }
    }

    public void createOrUpdateTable(AbstractTable table, DataSourceImpl datasource, DDLMode ddlMode) {
        try {
            if (ddlMode == DDLMode.DROP || ddlMode == DDLMode.CREATE) {
                JdbcTable tableMetadata = this.getTableMetadata(datasource, table);
                if (tableMetadata == null) {
                    this.createTable(datasource, table);
                }
            } else if (ddlMode == DDLMode.UPDATE) {
                JdbcTable tableMetadata = this.getTableMetadata(datasource, table);
                if (tableMetadata == null) {
                    this.createTable(datasource, table);
                } else {
                    this.updateTable(datasource, table);
                }
            }
        }
        catch (SQLException e) {
            this.logRelaxed(e, "Table DDL Failed for table " + table.getName());
        }
    }

    public abstract void createSequenceIfNecessary(DataSource var1, SequenceGenerator var2);

    private void createTable(DataSourceImpl datasource, AbstractTable table) {
        try {
            new QueryRunner(datasource, this.isPmdBroken()).update(this.createCreateTableStatement(table));
        }
        catch (SQLException e) {
            this.logRelaxed(e, "Cannot create table " + table.getName());
        }
        this.createIndexes(datasource, table);
    }

    public final void createTableGeneratorIfNecessary(DataSourceImpl datasource, TableGenerator table) {
        try {
            if (this.getTableMetadata(datasource, table.getCatalog(), table.getSchema(), table.getTable()) == null) {
                String sql = "CREATE TABLE " + table.getQName() + " (" + "\n\t" + table.getPkColumnName() + " VARCHAR(255)," + "\n\t" + table.getValueColumnName() + " INT," + "\nPRIMARY KEY(" + table.getPkColumnName() + "))";
                new QueryRunner(datasource, this.isPmdBroken()).update(sql);
            }
        }
        catch (SQLException e) {
            this.logRelaxed(e, "Cannot create table generator " + table.getTable());
        }
    }

    public void dropAllForeignKeys(DataSourceImpl datasource, Set<AbstractTable> tables) {
        for (AbstractTable table : tables) {
            JdbcTable tableMetadata = null;
            try {
                tableMetadata = this.getTableMetadata(datasource, table);
            }
            catch (SQLException e) {
                this.logRelaxed(e, "Cannot drop foreign keys for table " + table.getName());
            }
            if (tableMetadata == null) continue;
            for (JdbcForeignKey foreignKey : tableMetadata.getForeignKeys()) {
                try {
                    new QueryRunner(datasource, this.isPmdBroken()).update(this.getDropForeignKeySql(table.getSchema(), table.getName(), foreignKey.getName()));
                }
                catch (SQLException e) {
                    this.logRelaxed(e, "Cannot drop foreign key " + foreignKey.getName());
                }
            }
        }
    }

    public void dropAllSequences(DataSourceImpl datasource, Collection<SequenceGenerator> sequences) throws SQLException {
        QueryRunner runner = new QueryRunner(datasource, this.isPmdBroken());
        for (SequenceGenerator sequence : sequences) {
            try {
                this.dropSequence(runner, sequence);
            }
            catch (SQLException e) {
                this.logRelaxed(e, "Cannot drop sequence.");
            }
        }
    }

    public void dropAllTables(DataSourceImpl datasource, Collection<AbstractTable> tables) throws SQLException {
        QueryRunner runner = new QueryRunner(datasource, this.isPmdBroken());
        for (AbstractTable table : tables) {
            try {
                JdbcTable tableMetadata = this.getTableMetadata(datasource, table);
                this.tables.remove(table);
                if (tableMetadata == null) continue;
                runner.update("DROP TABLE " + table.getQName());
            }
            catch (SQLException e) {
                this.logRelaxed(e, "Cannot drop table " + table.getName());
            }
        }
    }

    protected void dropSequence(QueryRunner runner, SequenceGenerator sequence) throws SQLException {
        runner.update("DROP SEQUENCE " + sequence.getQName());
    }

    public String escape(String name) {
        if (name == null) {
            return null;
        }
        if (this.words.contains(name.toUpperCase(Locale.ENGLISH))) {
            return name + "_";
        }
        return name;
    }

    protected Collection<AbstractColumn> getColumns(AbstractTable table) {
        ArrayList columns = Lists.newArrayList(table.getColumns());
        Collections.sort(columns, new Comparator<AbstractColumn>(){

            @Override
            public int compare(AbstractColumn o1, AbstractColumn o2) {
                if (o1.isPrimaryKey() && !o2.isPrimaryKey()) {
                    return -1;
                }
                if (o2.isPrimaryKey() && !o1.isPrimaryKey()) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        return columns;
    }

    protected String getColumnType(AbstractColumn cd, int sqlType) {
        switch (sqlType) {
            case 2004: {
                return "BLOB(" + cd.getLength() + ")";
            }
            case 2005: {
                return "CLOB(" + cd.getLength() + ")";
            }
            case 12: {
                return "VARCHAR(" + cd.getLength() + ")";
            }
            case 92: {
                return "TIME";
            }
            case 91: {
                return "DATE";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 1: {
                return "CHAR";
            }
            case 16: {
                return "BOOLEAN";
            }
            case -6: 
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT" + (cd.getPrecision() > 0 ? "(" + cd.getPrecision() + ")" : "");
            }
            case 8: {
                return "DOUBLE" + (cd.getPrecision() > 0 ? "(" + cd.getPrecision() + ")" : "");
            }
            case 3: {
                return "DECIMAL" + (cd.getPrecision() > 0 ? "(" + cd.getPrecision() + (cd.getScale() > 0 ? "," + cd.getScale() : "") + ")" : "");
            }
        }
        throw new IllegalArgumentException("Unhandled sql type: " + sqlType);
    }

    public String getCurrentDate() {
        return "CURRENT_DATE";
    }

    public String getCurrentTime() {
        return "CURRENT_TIME";
    }

    public String getCurrentTimeStamp() {
        return "CURRENT_TIMESTAMP";
    }

    protected abstract String getDatabaseName();

    protected String getDropForeignKeySql(String schema, String table, String foreignKey) {
        String qualifiedName = Joiner.on((String)".").skipNulls().join((Object)schema, (Object)table, new Object[0]);
        return "ALTER TABLE " + qualifiedName + " DROP FOREIGN KEY " + foreignKey;
    }

    public abstract long getNextSequence(DataSourceImpl var1, String var2) throws SQLException;

    public String getNumericFunctionTemplate(NumericFunctionExpression.NumericFunctionType type) {
        switch (type) {
            case ABS: {
                return "ABS({0})";
            }
            case LENGTH: {
                return "LENGTH({0})";
            }
            case MOD: {
                return "MOD({0}, {1})";
            }
        }
        return "SQRT({0})";
    }

    public abstract PaginationParamsOrder getPaginationParamsOrder();

    protected String getPkCreateSql(String schema, String table, Set<String> pkColumns) {
        String qualifiedName = Joiner.on((String)".").skipNulls().join((Object[])new String[]{schema, table});
        return "ALTER TABLE " + qualifiedName + " ADD PRIMARY KEY (" + Joiner.on((String)", ").join(pkColumns) + ")";
    }

    protected String getPkDropSql(String schema, String table, String pkName) {
        String qualifiedName = Joiner.on((String)".").skipNulls().join((Object[])new String[]{schema, table});
        return "ALTER TABLE " + qualifiedName + " DROP PRIMARY KEY";
    }

    public abstract String getSelectLastIdentitySql(PkColumn var1);

    private synchronized JdbcTable getTableMetadata(DataSourceImpl datasource, AbstractTable table) throws SQLException {
        JdbcTable tableMetadata = this.tables.get(table);
        if (tableMetadata != null) {
            return tableMetadata;
        }
        tableMetadata = this.getTableMetadata(datasource, table.getCatalog(), table.getSchema(), table.getName());
        if (tableMetadata != null) {
            this.tables.put(table, tableMetadata);
        }
        return tableMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JdbcTable getTableMetadata(DataSourceImpl datasource, String catalog, String schema, String table) throws SQLException {
        ResultSet tables;
        ConnectionImpl connection;
        block4: {
            JdbcTable jdbcTable;
            connection = datasource.getConnection();
            tables = null;
            try {
                String tableName;
                DatabaseMetaData dbMetadata = connection.getMetaData();
                if (StringUtils.isBlank((String)catalog)) {
                    catalog = null;
                }
                if (StringUtils.isBlank((String)schema)) {
                    schema = null;
                }
                if (!(tables = dbMetadata.storesUpperCaseIdentifiers() ? dbMetadata.getTables(BatooUtils.upper(catalog), BatooUtils.upper(schema), BatooUtils.upper(table), TABLE_OR_VIEW) : (dbMetadata.storesLowerCaseIdentifiers() ? dbMetadata.getTables(BatooUtils.lower(catalog), BatooUtils.lower(schema), BatooUtils.lower(table), TABLE_OR_VIEW) : dbMetadata.getTables(catalog, schema, table, TABLE_OR_VIEW))).next() || !table.equalsIgnoreCase(tableName = tables.getString(TABLE_NAME))) break block4;
                jdbcTable = new JdbcTable(dbMetadata, tables);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly((Connection)connection);
                DbUtils.closeQuietly(tables);
                throw throwable;
            }
            DbUtils.closeQuietly((Connection)connection);
            DbUtils.closeQuietly((ResultSet)tables);
            return jdbcTable;
        }
        DbUtils.closeQuietly((Connection)connection);
        DbUtils.closeQuietly((ResultSet)tables);
        return null;
    }

    public boolean isPmdBroken() {
        return false;
    }

    private void loadReservedWords() throws MappingException {
        String packageName = this.getClass().getPackage().getName().replaceAll("\\.", "/");
        String name = this.getDatabaseName();
        try {
            String fileName = packageName + "/" + name.toLowerCase(Locale.ENGLISH) + ".words";
            List words = IOUtils.readLines((InputStream)this.getClass().getClassLoader().getResourceAsStream(fileName));
            this.words = Lists.transform((List)words, (Function)new Function<String, String>(){

                public String apply(String input) {
                    return input.toUpperCase(Locale.ENGLISH);
                }
            });
        }
        catch (IOException e) {
            throw new MappingException("Broken JDBC Adapter " + this.getClass().getSimpleName() + ". Reserved words for the adapter cannot be loaded", new AbstractLocator[0]);
        }
    }

    protected void logRelaxed(SQLException e, String message) {
        LOG.warn(message + " Check debug log for details: " + e.getMessage());
        LOG.debug(e, message);
    }

    public abstract boolean paginationNeedsMaxResultsAlways();

    public abstract boolean paginationNeedsStartAlways();

    protected String qualified(String schema, String jdbcClassName) {
        if (StringUtils.isBlank((String)schema)) {
            return jdbcClassName;
        }
        return schema + "." + jdbcClassName;
    }

    public abstract IdType supports(GenerationType var1);

    private void updateTable(DataSourceImpl datasource, AbstractTable table) {
        QueryRunner runner = new QueryRunner(datasource, this.isPmdBroken());
        try {
            JdbcTable tableMetadata = this.getTableMetadata(datasource, table);
            HashSet columnsFound = Sets.newHashSet();
            ArrayList columnsToAdd = Lists.newArrayList();
            for (AbstractColumn column : table.getColumns()) {
                JdbcColumn columnMetadata = tableMetadata.getColumn(column.getName());
                if (columnMetadata == null) {
                    columnsToAdd.add(column);
                    continue;
                }
                columnsFound.add(column.getName());
            }
            tableMetadata.logNotNullExtraColumns(table.getColumnNames());
            boolean pkDropped = false;
            if (tableMetadata.requiresPkDrop(table.getPkColumnNames())) {
                try {
                    runner.update(this.getPkDropSql(tableMetadata.getSchema(), table.getName(), tableMetadata.getPkName()));
                    pkDropped = true;
                }
                catch (SQLException e) {
                    LOG.error(e, "Cannot drop the primary key for table {0}. Primary key changes will not be reflected!", table.getName());
                }
            }
            if (columnsToAdd.size() > 0) {
                runner.update(this.createAlterTableStatement(table, columnsToAdd));
            }
            this.createIndexes(datasource, table);
            if (pkDropped) {
                runner.update(this.getPkCreateSql(tableMetadata.getSchema(), table.getName(), table.getPkColumnNames()));
            }
        }
        catch (SQLException e) {
            LOG.error(e, "Unable to update table {0}", table.getName());
        }
    }

    public static enum PaginationParamsOrder {
        SQL_START_MAX(true),
        SQL_MAX_START(true),
        SQL_START_END(true),
        SQL_END_START(true),
        MAX_START_SQL(false),
        START_MAX_SQL(false);

        private final boolean afterMainSql;

        private PaginationParamsOrder(boolean afterMainSql) {
            this.afterMainSql = afterMainSql;
        }

        public boolean isAfterMainSql() {
            return this.afterMainSql;
        }
    }
}

