/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.pool;

import com.google.common.annotations.Beta;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

@Beta
public class GenericKeyedPool<K, V>
implements KeyedObjectPool<K, V> {
    private static final int MIN_SIZE = 1;
    private static final int MAX_SIZE = 15;
    private final KeyedPoolableObjectFactory<K, V> factory;
    private final HashMap<K, LinkedList<V>> poolMap = Maps.newHashMap();

    public GenericKeyedPool(KeyedPoolableObjectFactory<K, V> factory) {
        this.factory = factory;
    }

    public void addObject(K key) throws Exception, IllegalStateException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V borrowObject(K key) throws Exception, NoSuchElementException, IllegalStateException {
        LinkedList<V> pool = this.getPool(key);
        if (pool.size() <= 1) {
            GenericKeyedPool genericKeyedPool = this;
            synchronized (genericKeyedPool) {
                while (pool.size() <= 1) {
                    pool.addLast(this.factory.makeObject(key));
                }
            }
        }
        return pool.pollFirst();
    }

    public void clear() throws Exception, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void clear(K key) throws Exception, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void close() throws Exception {
        Iterator<Map.Entry<K, LinkedList<V>>> i = this.poolMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<K, LinkedList<V>> e = i.next();
            this.shrinkTo(e.getKey(), e.getValue(), 0);
            i.remove();
        }
    }

    public int getNumActive() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int getNumActive(K key) throws UnsupportedOperationException {
        return 0;
    }

    public int getNumIdle() throws UnsupportedOperationException {
        return this.poolMap.size();
    }

    public int getNumIdle(K key) throws UnsupportedOperationException {
        return this.getPool(key).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedList<V> getPool(K key) {
        LinkedList<Object> pool = this.poolMap.get(key);
        if (pool != null) {
            return pool;
        }
        GenericKeyedPool genericKeyedPool = this;
        synchronized (genericKeyedPool) {
            pool = this.poolMap.get(key);
            if (pool != null) {
                return pool;
            }
            pool = new LinkedList();
            this.poolMap.put(key, pool);
            return pool;
        }
    }

    public void invalidateObject(K key, V obj) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void returnObject(K key, V obj) throws Exception {
        LinkedList<V> pool = this.getPool(key);
        pool.addLast(obj);
        this.shrinkTo(key, pool, 15);
    }

    public void setFactory(KeyedPoolableObjectFactory<K, V> factory) throws IllegalStateException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private void shrinkTo(K key, LinkedList<V> pool, int maxSize) throws Exception {
        while (pool.size() > maxSize) {
            V obj = pool.getFirst();
            this.factory.destroyObject(key, obj);
        }
    }
}

