/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.persistence.SharedCacheMode;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.batoo.jpa.common.BatooException;
import org.batoo.jpa.common.log.BLogger;
import org.batoo.jpa.common.log.BLoggerFactory;
import org.batoo.jpa.parser.PersistenceParser;
import org.batoo.jpa.parser.impl.OrmParser;
import org.batoo.jpa.parser.impl.metadata.MetadataImpl;
import org.batoo.jpa.parser.persistence.Persistence;
import org.batoo.jpa.parser.persistence.PersistenceUnitCachingType;
import org.batoo.jpa.parser.persistence.PersistenceUnitValidationModeType;

public class PersistenceParserImpl
implements PersistenceParser {
    public static final String PERSISTENCE_XML = "META-INF/persistence.xml";
    private static final String ORM_XML = "META-INF/orm.xml";
    private static final BLogger LOG = BLoggerFactory.getLogger(PersistenceParserImpl.class);
    private final String puName;
    private final PersistenceUnitInfo persistenceUnitInfo;
    private final ClassLoader classloader;
    private final MetadataImpl metadata;
    private final Persistence.PersistenceUnit persistenceUnit;
    private final Map<String, Object> properties = Maps.newHashMap();
    private final boolean hasValidators;

    public PersistenceParserImpl(PersistenceUnitInfo persistenceUnitInfo, String persistenceUnitName) {
        this.persistenceUnitInfo = persistenceUnitInfo;
        if (this.persistenceUnitInfo != null) {
            this.puName = this.persistenceUnitInfo.getPersistenceUnitName();
            this.classloader = this.persistenceUnitInfo.getClassLoader();
        } else {
            this.puName = persistenceUnitName;
            this.classloader = Thread.currentThread().getContextClassLoader();
        }
        this.persistenceUnit = this.createPersistenceUnit();
        this.readProperties();
        this.hasValidators = this.persistenceUnit.getValidationMode() == PersistenceUnitValidationModeType.AUTO || this.persistenceUnit.getValidationMode() == PersistenceUnitValidationModeType.CALLBACK;
        this.metadata = new MetadataImpl(this.persistenceUnit.getClazzs());
        this.parseOrmXmls();
        if (this.persistenceUnitInfo != null) {
            List<URL> jarFiles = this.persistenceUnitInfo.getJarFileUrls();
            if (jarFiles == null) {
                jarFiles = Collections.emptyList();
            }
            this.metadata.parse(jarFiles, this.classloader);
        } else {
            this.metadata.parse(this.classloader);
        }
    }

    public PersistenceParserImpl(String persistenceUnitName) {
        this(null, persistenceUnitName);
    }

    public PersistenceParserImpl(String emName, Map<String, String> properties, String[] classes) {
        this.persistenceUnitInfo = null;
        this.puName = emName;
        this.classloader = Thread.currentThread().getContextClassLoader();
        this.persistenceUnit = new Persistence.PersistenceUnit();
        for (String clazz : classes) {
            this.persistenceUnit.getClazzs().add(clazz);
        }
        this.properties.putAll(properties);
        this.hasValidators = true;
        this.metadata = new MetadataImpl(this.persistenceUnit.getClazzs());
        this.metadata.parse(this.classloader);
    }

    private Persistence.PersistenceUnit createPersistenceUnit() {
        try {
            LOG.info("Loading persistence.xml");
            Enumeration<URL> xmls = this.classloader.getResources(PERSISTENCE_XML);
            while (xmls.hasMoreElements()) {
                InputStream is = this.classloader.getResourceAsStream(PERSISTENCE_XML);
                if (is == null) {
                    throw new BatooException("persistence.xml not found in the classpath");
                }
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Persistence.class});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                Persistence persistence = (Persistence)unmarshaller.unmarshal(is);
                for (Persistence.PersistenceUnit persistenceUnit : persistence.getPersistenceUnits()) {
                    if (!this.puName.equals(persistenceUnit.getName())) continue;
                    return persistenceUnit;
                }
            }
        }
        catch (Exception e) {
            throw new BatooException("Unable to parse persistence.xml", e);
        }
        throw new BatooException("Persistence unit " + this.puName + " not found.");
    }

    @Override
    public ClassLoader getClassloader() {
        return this.classloader;
    }

    @Override
    public String getJtaDatasource() {
        return this.persistenceUnit.getJtaDataSource();
    }

    @Override
    public MetadataImpl getMetadata() {
        return this.metadata;
    }

    @Override
    public String getNonJtaDatasource() {
        return this.persistenceUnit.getNonJtaDataSource();
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public SharedCacheMode getSharedCacheMode() {
        PersistenceUnitCachingType cacheMode = this.persistenceUnit.getSharedCacheMode();
        return cacheMode == null ? SharedCacheMode.NONE : SharedCacheMode.valueOf((String)cacheMode.name());
    }

    @Override
    public boolean hasValidators() {
        return this.hasValidators;
    }

    private void parseOrmXml(String mappingFile) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(mappingFile);
        if (is != null) {
            OrmParser ormParser = new OrmParser(mappingFile);
            ormParser.consume(is);
            this.metadata.merge(ormParser.getMetadata());
            LOG.trace("Merged metamodel {0}", this.metadata);
        }
    }

    private void parseOrmXmls() {
        if (this.persistenceUnit.getMappingFiles().size() > 0) {
            for (String mappingFile : this.persistenceUnit.getMappingFiles()) {
                this.parseOrmXml(mappingFile);
            }
        } else {
            this.parseOrmXml(ORM_XML);
        }
    }

    private void readProperties() {
        for (Persistence.PersistenceUnit.Properties.Property property : this.persistenceUnit.getProperties().getProperties()) {
            this.properties.put(property.getName(), property.getValue());
        }
    }
}

