/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.metadata;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.AccessType;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.PersistenceException;
import org.batoo.jpa.common.log.BLogger;
import org.batoo.jpa.common.log.BLoggerFactory;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.impl.AbstractLocator;
import org.batoo.jpa.parser.impl.metadata.type.EmbeddableMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.type.EntityMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.type.MappedSuperclassMetadataImpl;
import org.batoo.jpa.parser.metadata.EntityListenerMetadata;
import org.batoo.jpa.parser.metadata.Metadata;
import org.batoo.jpa.parser.metadata.NamedNativeQueryMetadata;
import org.batoo.jpa.parser.metadata.NamedQueryMetadata;
import org.batoo.jpa.parser.metadata.SequenceGeneratorMetadata;
import org.batoo.jpa.parser.metadata.TableGeneratorMetadata;
import org.batoo.jpa.parser.metadata.type.EmbeddableMetadata;
import org.batoo.jpa.parser.metadata.type.EntityMetadata;
import org.batoo.jpa.parser.metadata.type.ManagedTypeMetadata;
import org.batoo.jpa.parser.metadata.type.MappedSuperclassMetadata;

public class MetadataImpl
implements Metadata {
    private static final BLogger LOG = BLoggerFactory.getLogger(MetadataImpl.class);
    private AccessType accessType;
    private boolean xmlMappingMetadataComplete;
    private String schema;
    private String catalog;
    private final List<SequenceGeneratorMetadata> sequenceGenerators = Lists.newArrayList();
    private final List<TableGeneratorMetadata> tableGenerators = Lists.newArrayList();
    private final List<NamedQueryMetadata> namedQueries = Lists.newArrayList();
    private final List<NamedNativeQueryMetadata> namedNativeQueries = Lists.newArrayList();
    private final List<EntityListenerMetadata> entityListeners = Lists.newArrayList();
    private final Map<String, ManagedTypeMetadata> entityMap = Maps.newHashMap();
    private boolean cascadePersist;

    public MetadataImpl(List<String> classes) {
        for (String clazz : classes) {
            this.entityMap.put(clazz, null);
        }
    }

    @Override
    public boolean cascadePersists() {
        return this.cascadePersist;
    }

    private void findClasses(Set<Class<?>> classes, URLClassLoader classPath) {
        try {
            Enumeration<URL> resources = classPath.getResources("");
            while (resources.hasMoreElements()) {
                String root = resources.nextElement().getFile();
                if (root.endsWith("WEB-INF/")) {
                    root = root + "classes/";
                }
                if (!root.endsWith("/")) {
                    root = root + "/";
                }
                this.findClasses(classPath, classes, root.length(), new File(root));
            }
        }
        catch (Exception e) {
            throw new PersistenceException("Cannot scan the classpath", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void findClasses(URLClassLoader classPath, Set<Class<?>> classes, int rootLength, File file) throws IOException {
        if (file.isDirectory()) {
            for (String child : file.list()) {
                this.findClasses(classPath, classes, rootLength, new File(file.getCanonicalPath() + "/" + child));
            }
            return;
        } else {
            String path = file.getPath();
            if (!path.endsWith(".class")) return;
            path = path.substring(rootLength, path.length() - 6).replace("/", ".");
            try {
                Class<?> clazz = classPath.loadClass(path);
                if (clazz.getAnnotation(Embeddable.class) == null && clazz.getAnnotation(MappedSuperclass.class) == null && clazz.getAnnotation(Entity.class) == null) return;
                classes.add(clazz);
                return;
            }
            catch (Exception e) {
                LOG.warn("Cannot load class {0} in {1}", path, file.getPath());
            }
        }
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public List<EntityListenerMetadata> getEntityListeners() {
        return this.entityListeners;
    }

    @Override
    public List<ManagedTypeMetadata> getEntityMappings() {
        return Lists.newArrayList(this.entityMap.values());
    }

    @Override
    public List<NamedNativeQueryMetadata> getNamedNativeQueries() {
        return this.namedNativeQueries;
    }

    @Override
    public List<NamedQueryMetadata> getNamedQueries() {
        return this.namedQueries;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public List<SequenceGeneratorMetadata> getSequenceGenerators() {
        return this.sequenceGenerators;
    }

    @Override
    public List<TableGeneratorMetadata> getTableGenerators() {
        return this.tableGenerators;
    }

    @Override
    public boolean isXmlMappingMetadataComplete() {
        return this.xmlMappingMetadataComplete;
    }

    public void merge(Metadata metadata) {
        this.accessType = metadata.getAccessType();
        this.catalog = metadata.getCatalog();
        this.schema = metadata.getSchema();
        this.xmlMappingMetadataComplete = metadata.isXmlMappingMetadataComplete();
        this.cascadePersist = metadata.cascadePersists();
        this.sequenceGenerators.addAll(metadata.getSequenceGenerators());
        this.tableGenerators.addAll(metadata.getTableGenerators());
        this.entityListeners.addAll(metadata.getEntityListeners());
        this.namedQueries.addAll(metadata.getNamedQueries());
        this.namedNativeQueries.addAll(metadata.getNamedNativeQueries());
        for (ManagedTypeMetadata managedType : metadata.getEntityMappings()) {
            ManagedTypeMetadata existing = this.entityMap.put(managedType.getClassName(), managedType);
            if (existing == null || existing == null) continue;
            throw new MappingException("Duplicate definitions for " + managedType.getClassName(), managedType.getLocator(), existing.getLocator());
        }
    }

    public void parse(ClassLoader classloader) {
        for (Map.Entry<String, ManagedTypeMetadata> entry : this.entityMap.entrySet()) {
            String className = entry.getKey();
            ManagedTypeMetadata metadata = entry.getValue();
            try {
                Class<?> clazz = classloader.loadClass(className);
                if (metadata == null) {
                    if (clazz.getAnnotation(Entity.class) != null) {
                        EntityMetadataImpl entityMetadata = new EntityMetadataImpl(clazz, (EntityMetadata)metadata);
                        this.entityMap.put(className, entityMetadata);
                        this.namedQueries.addAll(entityMetadata.getNamedQueries());
                        continue;
                    }
                    if (clazz.getAnnotation(MappedSuperclass.class) != null) {
                        this.entityMap.put(className, new MappedSuperclassMetadataImpl(clazz, (MappedSuperclassMetadata)metadata));
                        continue;
                    }
                    if (clazz.getAnnotation(Embeddable.class) != null) {
                        this.entityMap.put(className, new EmbeddableMetadataImpl(clazz, (EmbeddableMetadata)metadata));
                        continue;
                    }
                    throw new MappingException("Cannot determine type of class " + className, new AbstractLocator[0]);
                }
                if (metadata instanceof EntityMetadata) {
                    this.entityMap.put(className, new EntityMetadataImpl(clazz, (EntityMetadata)metadata));
                    this.namedQueries.addAll(((EntityMetadata)metadata).getNamedQueries());
                    continue;
                }
                if (!(metadata instanceof MappedSuperclassMetadata)) continue;
                this.entityMap.put(className, new MappedSuperclassMetadataImpl(clazz, (MappedSuperclassMetadata)metadata));
            }
            catch (ClassNotFoundException e) {
                throw new MappingException("Class " + className + " cound not be found.", metadata.getLocator());
            }
        }
    }

    public void parse(List<URL> jarFiles, ClassLoader classloader) {
        URLClassLoader classPath = new URLClassLoader(jarFiles.toArray(new URL[jarFiles.size()]), classloader);
        HashSet classes = Sets.newHashSet();
        this.findClasses(classes, classPath);
        for (Class clazz : classes) {
            if (this.entityMap.containsKey(clazz.getName()) || this.entityMap.containsKey(clazz.getSimpleName())) continue;
            this.entityMap.put(clazz.getName(), null);
        }
        this.parse(classloader);
    }
}

