/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.metadata.attribute;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.List;
import java.util.Set;
import javax.persistence.EnumType;
import javax.persistence.OneToMany;
import javax.persistence.TemporalType;
import org.batoo.jpa.parser.impl.metadata.attribute.AssociationAttributeMetadataImpl;
import org.batoo.jpa.parser.metadata.AttributeOverrideMetadata;
import org.batoo.jpa.parser.metadata.ColumnMetadata;
import org.batoo.jpa.parser.metadata.attribute.OneToManyAttributeMetadata;

public class OneToManyAttributeMetadataImpl
extends AssociationAttributeMetadataImpl
implements OneToManyAttributeMetadata {
    private final String mappedBy;
    private final boolean removesOprhans;
    private final String mapKey;
    private final String mapKeyClassName;
    private final ColumnMetadata mapKeyColumn;
    private final EnumType mapKeyEnumType;
    private final TemporalType mapKeyTemporalType;
    private final ColumnMetadata orderColumn;
    private final String orderBy;
    private final List<AttributeOverrideMetadata> mapKeyAttributeOverrides = Lists.newArrayList();

    public OneToManyAttributeMetadataImpl(Member member, OneToManyAttributeMetadata metadata) {
        super(member, metadata);
        this.mappedBy = metadata.getMappedBy();
        this.removesOprhans = metadata.removesOrphans();
        this.mapKey = metadata.getMapKey();
        this.mapKeyClassName = metadata.getMapKeyClassName();
        this.mapKeyColumn = metadata.getMapKeyColumn();
        this.mapKeyEnumType = metadata.getMapKeyEnumType();
        this.mapKeyTemporalType = metadata.getMapKeyTemporalType();
        this.mapKeyAttributeOverrides.addAll(metadata.getMapKeyAttributeOverrides());
        this.orderBy = metadata.getOrderBy();
        this.orderColumn = metadata.getOrderColumn();
    }

    public OneToManyAttributeMetadataImpl(Member member, String name, OneToMany oneToMany, Set<Class<? extends Annotation>> parsed) {
        super(member, name, parsed, oneToMany.targetEntity().getName(), oneToMany.fetch(), oneToMany.cascade());
        parsed.add(OneToMany.class);
        this.mappedBy = oneToMany.mappedBy();
        this.removesOprhans = oneToMany.orphanRemoval();
        this.mapKey = this.handleMapKey(member, parsed);
        this.mapKeyClassName = this.handleMapKeyClassName(member, parsed);
        this.mapKeyColumn = this.handleMapKeyColumn(member, parsed);
        this.mapKeyEnumType = this.handleMapKeyEnumType(member, parsed);
        this.mapKeyTemporalType = this.handleMapKeyTemporalType(member, parsed);
        this.orderBy = this.handleOrderBy(member, parsed);
        this.orderColumn = this.handleOrderColumn(member, parsed);
    }

    @Override
    public String getMapKey() {
        return this.mapKey;
    }

    @Override
    public List<AttributeOverrideMetadata> getMapKeyAttributeOverrides() {
        return this.mapKeyAttributeOverrides;
    }

    @Override
    public String getMapKeyClassName() {
        return this.mapKeyClassName;
    }

    @Override
    public ColumnMetadata getMapKeyColumn() {
        return this.mapKeyColumn;
    }

    @Override
    public EnumType getMapKeyEnumType() {
        return this.mapKeyEnumType;
    }

    @Override
    public TemporalType getMapKeyTemporalType() {
        return this.mapKeyTemporalType;
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    public ColumnMetadata getOrderColumn() {
        return this.orderColumn;
    }

    @Override
    public boolean removesOrphans() {
        return this.removesOprhans;
    }
}

