/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.orm;

import com.google.common.collect.Maps;
import java.util.Map;
import org.batoo.jpa.parser.impl.orm.Element;
import org.batoo.jpa.parser.impl.orm.HintElement;
import org.batoo.jpa.parser.impl.orm.ParentElement;
import org.batoo.jpa.parser.impl.orm.QueryElement;
import org.batoo.jpa.parser.metadata.NamedNativeQueryMetadata;

public class NamedNativeQueryElement
extends ParentElement
implements NamedNativeQueryMetadata {
    private String name;
    private String query;
    private final Map<String, Object> hints = Maps.newHashMap();
    private String resultClass;
    private String resultSetMapping;

    public NamedNativeQueryElement(ParentElement parent, Map<String, String> attributes) {
        super(parent, attributes, "query", "hint");
    }

    @Override
    protected void generate() {
        this.name = this.getAttribute("name", "");
        this.resultClass = this.getAttribute("result-class", "");
        this.resultSetMapping = this.getAttribute("result-set-mapping", "");
    }

    @Override
    public Map<String, Object> getHints() {
        return this.hints;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public String getResultClass() {
        return this.resultClass;
    }

    @Override
    public String getResultSetMapping() {
        return this.resultSetMapping;
    }

    @Override
    protected void handleChild(Element child) {
        if (child instanceof HintElement) {
            this.hints.put(((HintElement)child).getName(), ((HintElement)child).getValue());
        }
        if (child instanceof QueryElement) {
            this.query = ((QueryElement)child).getQuery();
        }
    }
}

