/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.orm.attribute;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.persistence.EnumType;
import javax.persistence.FetchType;
import javax.persistence.TemporalType;
import org.batoo.jpa.parser.impl.orm.AttributeOverrideElement;
import org.batoo.jpa.parser.impl.orm.Element;
import org.batoo.jpa.parser.impl.orm.MapKeyAttributeOverrideElement;
import org.batoo.jpa.parser.impl.orm.MapKeyClassElement;
import org.batoo.jpa.parser.impl.orm.MapKeyColumnElement;
import org.batoo.jpa.parser.impl.orm.MapKeyElement;
import org.batoo.jpa.parser.impl.orm.MapKeyEnumeratedElement;
import org.batoo.jpa.parser.impl.orm.MapKeyTemporalElement;
import org.batoo.jpa.parser.impl.orm.OrderByElement;
import org.batoo.jpa.parser.impl.orm.OrderColumnElement;
import org.batoo.jpa.parser.impl.orm.ParentElement;
import org.batoo.jpa.parser.impl.orm.PrimaryKeyJoinColumnElement;
import org.batoo.jpa.parser.impl.orm.attribute.AssociationElement;
import org.batoo.jpa.parser.metadata.AttributeOverrideMetadata;
import org.batoo.jpa.parser.metadata.ColumnMetadata;
import org.batoo.jpa.parser.metadata.PrimaryKeyJoinColumnMetadata;
import org.batoo.jpa.parser.metadata.attribute.ManyToManyAttributeMetadata;

public class ManyToManyAttributeElement
extends AssociationElement
implements ManyToManyAttributeMetadata {
    private String mappedBy;
    private String mapKey;
    private String orderBy;
    private ColumnMetadata mapKeyColumn;
    private String mapKeyClassName;
    private EnumType mapKeyEnumType;
    private TemporalType mapKeyTemporalType;
    private OrderColumnElement orderColumn;
    private final List<PrimaryKeyJoinColumnMetadata> primaryKeyJoinColumns = Lists.newArrayList();
    private final List<AttributeOverrideMetadata> mapKeyAttributeOverrides = Lists.newArrayList();

    public ManyToManyAttributeElement(ParentElement parent, Map<String, String> attributes, String ... expectedChildElements) {
        super(parent, attributes, FetchType.LAZY, "cascade", "join-column", "join-table", "primary-key-join-column", "map-key", "map-key-attribute-override", "map-key-class", "map-key-column", "map-key-enumerated", "map-key-temporal", "order-by", "order-column");
    }

    @Override
    protected void generate() {
        super.generate();
        this.mappedBy = this.getAttribute("mapped-by", "");
    }

    @Override
    public String getMapKey() {
        return this.mapKey;
    }

    @Override
    public List<AttributeOverrideMetadata> getMapKeyAttributeOverrides() {
        return this.mapKeyAttributeOverrides;
    }

    @Override
    public String getMapKeyClassName() {
        return this.mapKeyClassName;
    }

    @Override
    public ColumnMetadata getMapKeyColumn() {
        return this.mapKeyColumn;
    }

    @Override
    public EnumType getMapKeyEnumType() {
        return this.mapKeyEnumType;
    }

    @Override
    public TemporalType getMapKeyTemporalType() {
        return this.mapKeyTemporalType;
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    public ColumnMetadata getOrderColumn() {
        return this.orderColumn;
    }

    @Override
    protected void handleChild(Element child) {
        super.handleChild(child);
        if (child instanceof PrimaryKeyJoinColumnElement) {
            this.primaryKeyJoinColumns.add((PrimaryKeyJoinColumnMetadata)((Object)child));
        }
        if (child instanceof MapKeyElement) {
            this.mapKey = ((MapKeyElement)child).getName();
        }
        if (child instanceof MapKeyAttributeOverrideElement) {
            this.mapKeyAttributeOverrides.add((AttributeOverrideElement)child);
        }
        if (child instanceof MapKeyClassElement) {
            this.mapKeyClassName = ((MapKeyClassElement)child).getClazz();
        }
        if (child instanceof MapKeyColumnElement) {
            this.mapKeyColumn = (ColumnMetadata)((Object)child);
        }
        if (child instanceof MapKeyEnumeratedElement) {
            this.mapKeyEnumType = ((MapKeyEnumeratedElement)child).getEnumType();
        }
        if (child instanceof MapKeyTemporalElement) {
            this.mapKeyTemporalType = ((MapKeyTemporalElement)child).getTemporalType();
        }
        if (child instanceof OrderByElement) {
            this.orderBy = ((OrderByElement)child).getOrderBy();
        }
        if (child instanceof OrderColumnElement) {
            this.orderColumn = (OrderColumnElement)child;
        }
    }
}

