/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.orm.attribute;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.persistence.FetchType;
import org.batoo.jpa.parser.impl.orm.Element;
import org.batoo.jpa.parser.impl.orm.ParentElement;
import org.batoo.jpa.parser.impl.orm.PrimaryKeyJoinColumnElement;
import org.batoo.jpa.parser.impl.orm.attribute.AssociationElement;
import org.batoo.jpa.parser.metadata.PrimaryKeyJoinColumnMetadata;
import org.batoo.jpa.parser.metadata.attribute.OneToOneAttributeMetadata;

public class OneToOneAttributeElement
extends AssociationElement
implements OneToOneAttributeMetadata {
    private boolean orphanRemoval;
    private boolean optional;
    private String mappedBy;
    private String mapsId;
    private final List<PrimaryKeyJoinColumnMetadata> primaryKeyJoinColumns = Lists.newArrayList();

    public OneToOneAttributeElement(ParentElement parent, Map<String, String> attributes, String ... expectedChildElements) {
        super(parent, attributes, FetchType.EAGER, "cascade", "join-column", "join-table", "primary-key-join-column");
    }

    @Override
    protected void generate() {
        super.generate();
        this.orphanRemoval = this.getAttribute("orphan-removal", Boolean.FALSE);
        this.optional = this.getAttribute("optional", Boolean.TRUE);
        this.mappedBy = this.getAttribute("mapped-by", "");
        this.mapsId = this.getAttribute("maps-id");
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public String getMapsId() {
        return this.mapsId;
    }

    @Override
    public List<PrimaryKeyJoinColumnMetadata> getPrimaryKeyJoinColumns() {
        return this.primaryKeyJoinColumns;
    }

    @Override
    protected void handleChild(Element child) {
        super.handleChild(child);
        if (child instanceof PrimaryKeyJoinColumnElement) {
            this.primaryKeyJoinColumns.add((PrimaryKeyJoinColumnMetadata)((Object)child));
        }
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean removesOrphans() {
        return this.orphanRemoval;
    }
}

