/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.common.reflect;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.batoo.jpa.common.reflect.AbstractAccessor;
import org.batoo.jpa.common.reflect.ReflectHelper;

public class UnsafeFieldAccessor
extends AbstractAccessor {
    private final Field field;
    private final long fieldOffset;
    private final PrimitiveType primitiveType;
    private Class<?> numberType;

    public UnsafeFieldAccessor(Field field) {
        this.field = field;
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                UnsafeFieldAccessor.this.field.setAccessible(true);
                return null;
            }
        });
        this.primitiveType = this.getPrimitiveType();
        this.fieldOffset = ReflectHelper.unsafe.objectFieldOffset(field);
        if (Number.class.isAssignableFrom(this.field.getType()) || this.field.getType() == Byte.TYPE || this.field.getType() == Short.TYPE || this.field.getType() == Integer.TYPE || this.field.getType() == Long.TYPE) {
            this.numberType = this.field.getType();
        }
    }

    @Override
    public Object get(Object instance) {
        if (this.primitiveType == null) {
            return ReflectHelper.unsafe.getObject(instance, this.fieldOffset);
        }
        switch (this.primitiveType) {
            case BOOLEAN: {
                return ReflectHelper.unsafe.getBoolean(instance, this.fieldOffset);
            }
            case INTEGER: {
                return ReflectHelper.unsafe.getInt(instance, this.fieldOffset);
            }
            case FLOAT: {
                return Float.valueOf(ReflectHelper.unsafe.getFloat(instance, this.fieldOffset));
            }
            case DOUBLE: {
                return ReflectHelper.unsafe.getDouble(instance, this.fieldOffset);
            }
            case LONG: {
                return ReflectHelper.unsafe.getLong(instance, this.fieldOffset);
            }
            case SHORT: {
                return ReflectHelper.unsafe.getShort(instance, this.fieldOffset);
            }
            case BYTE: {
                return ReflectHelper.unsafe.getByte(instance, this.fieldOffset);
            }
        }
        return Character.valueOf(ReflectHelper.unsafe.getChar(instance, this.fieldOffset));
    }

    private PrimitiveType getPrimitiveType() {
        Class<?> type = this.field.getType();
        if (type.isPrimitive()) {
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                if (primitiveType.clazz != type) continue;
                return primitiveType;
            }
        }
        return null;
    }

    @Override
    public void set(Object instance, Object value) {
        if (instance == null) {
            throw new NullPointerException();
        }
        if (this.primitiveType == null) {
            if (this.numberType != null && value != null && this.numberType != value.getClass()) {
                Number number = ReflectHelper.convertNumber((Number)value, this.numberType);
                ReflectHelper.unsafe.putObject(instance, this.fieldOffset, number);
            } else {
                ReflectHelper.unsafe.putObject(instance, this.fieldOffset, value);
            }
        } else {
            switch (this.primitiveType) {
                case BOOLEAN: {
                    if (value instanceof Number) {
                        ReflectHelper.unsafe.putBoolean(instance, this.fieldOffset, ((Number)value).byteValue() != 0);
                        break;
                    }
                    ReflectHelper.unsafe.putBoolean(instance, this.fieldOffset, (Boolean)value);
                    break;
                }
                case INTEGER: {
                    ReflectHelper.unsafe.putInt(instance, this.fieldOffset, ((Number)value).intValue());
                    break;
                }
                case FLOAT: {
                    ReflectHelper.unsafe.putFloat(instance, this.fieldOffset, ((Number)value).floatValue());
                    break;
                }
                case DOUBLE: {
                    ReflectHelper.unsafe.putDouble(instance, this.fieldOffset, ((Number)value).doubleValue());
                    break;
                }
                case LONG: {
                    ReflectHelper.unsafe.putLong(instance, this.fieldOffset, ((Number)value).longValue());
                    break;
                }
                case SHORT: {
                    ReflectHelper.unsafe.putShort(instance, this.fieldOffset, ((Number)value).shortValue());
                    break;
                }
                case BYTE: {
                    ReflectHelper.unsafe.putByte(instance, this.fieldOffset, ((Number)value).byteValue());
                    break;
                }
                default: {
                    if (value == null) {
                        ReflectHelper.unsafe.putChar(instance, this.fieldOffset, '\u0000');
                        break;
                    }
                    ReflectHelper.unsafe.putChar(instance, this.fieldOffset, ((Character)value).charValue());
                }
            }
        }
    }

    private static enum PrimitiveType {
        BOOLEAN(Boolean.TYPE),
        INTEGER(Integer.TYPE),
        FLOAT(Float.TYPE),
        DOUBLE(Double.TYPE),
        BYTE(Byte.TYPE),
        SHORT(Short.TYPE),
        LONG(Long.TYPE),
        CHAR(Character.TYPE);

        private final Class<?> clazz;

        private PrimitiveType(Class<?> clazz) {
            this.clazz = clazz;
        }
    }
}

