/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.CriteriaModify;
import org.batoo.jpa.core.impl.model.MetamodelImpl;

public class CriteriaUpdateImpl<T>
extends CriteriaModify<T> {
    public CriteriaUpdateImpl(MetamodelImpl metamodel) {
        super(metamodel);
    }

    @Override
    public String generateJpql() {
        StringBuilder builder = new StringBuilder();
        builder.append("update " + this.getRoot().getEntity().getName());
        if (this.getRestriction() != null) {
            builder.append("\nwhere\n\t").append(this.getRestriction().generateJpqlRestriction(this));
        }
        return builder.toString();
    }

    @Override
    public String generateSql() {
        String sqlRestriction = this.generateSqlRestriction();
        String updates = "";
        return "UPDATE " + this.getRoot().generateSqlFrom(this) + "\nSET " + "" + (StringUtils.isNotBlank((String)sqlRestriction) ? "\nWHERE " + sqlRestriction : "");
    }

    private String generateSqlRestriction() {
        if (this.getRestriction() == null && this.getRoot().getEntity().getRootType().getInheritanceType() == null) {
            return null;
        }
        String sqlRestriction = this.getRestriction().generateSqlRestriction(this);
        if (this.getRoot().getEntity().getRootType().getInheritanceType() == null) {
            return sqlRestriction;
        }
        return "(" + sqlRestriction + ") AND (" + this.getRoot().generateDiscrimination(true) + ")";
    }

    @Override
    public boolean isQuery() {
        return false;
    }

    @Override
    public CriteriaUpdateImpl<T> where(Expression<Boolean> restriction) {
        return (CriteriaUpdateImpl)super.where(restriction);
    }

    @Override
    public CriteriaUpdateImpl<T> where(Predicate ... restrictions) {
        return (CriteriaUpdateImpl)super.where(restrictions);
    }
}

