/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import org.batoo.jpa.core.impl.criteria.AbstractSelection;

public class TupleImpl
implements Tuple {
    private final List<String> aliases;
    private final List<AbstractSelection<?>> selections;
    private final Object[] values;

    public TupleImpl(List<String> aliases, List<AbstractSelection<?>> selections, Object[] values) {
        this.aliases = aliases;
        this.selections = selections;
        this.values = values;
    }

    public Object get(int i) {
        return this.values[i];
    }

    public <X> X get(int i, Class<X> type) {
        return (X)this.values[i];
    }

    public Object get(String alias) {
        int index = this.aliases.indexOf(alias);
        if (index == -1) {
            throw new NullPointerException();
        }
        return this.values[index];
    }

    public <X> X get(String alias, Class<X> type) {
        int index = this.aliases.indexOf(alias);
        if (index == -1) {
            throw new NullPointerException();
        }
        return (X)this.values[index];
    }

    public <X> X get(TupleElement<X> tupleElement) {
        int index = this.selections.indexOf(tupleElement);
        if (index == -1) {
            throw new NullPointerException();
        }
        return (X)this.values[index];
    }

    public List<TupleElement<?>> getElements() {
        ArrayList tuples = Lists.newArrayList();
        tuples.addAll(this.selections);
        return tuples;
    }

    public Object[] toArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }
}

