/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.expression.ConstantExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class CoalesceExpression<T>
extends AbstractExpression<T>
implements CriteriaBuilder.Coalesce<T> {
    private final List<Expression<? extends T>> values = Lists.newArrayList();
    private String alias;

    public CoalesceExpression() {
        super(Object.class);
    }

    public CoalesceExpression(Expression<? extends T> x, Expression<? extends T> y) {
        this();
        this.value((Expression)x);
        this.value((Expression)y);
    }

    @Override
    public String generateJpqlRestriction(final BaseQueryImpl<?> query) {
        return "coalesce(" + Joiner.on((String)", ").join((Iterable)Lists.transform(this.values, (Function)new Function<Expression<? extends T>, String>(){

            public String apply(Expression<? extends T> input) {
                return ((AbstractExpression)input).generateJpqlRestriction(query);
            }
        })) + ")";
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (StringUtils.isNotBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(final BaseQueryImpl<?> query) {
        return new String[]{"COALESCE(" + Joiner.on((String)", ").join((Iterable)Lists.transform(this.values, (Function)new Function<Expression<? extends T>, String>(){

            public String apply(Expression<? extends T> input) {
                return ((AbstractExpression)input).getSqlRestrictionFragments(query)[0];
            }
        })) + ")"};
    }

    @Override
    public T handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return (T)row.getObject(this.alias);
    }

    public CoalesceExpression<T> value(Expression<? extends T> value) {
        this.values.add(value);
        return this;
    }

    public CoalesceExpression<T> value(T value) {
        return this.value(new ConstantExpression<T>(null, value));
    }
}

