/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class CurrentTemporalExpression<T>
extends AbstractExpression<T> {
    private final TemporalType temporalType;
    private String alias;

    public CurrentTemporalExpression(TemporalType temporalType, Class<T> javaType) {
        super(javaType);
        this.temporalType = temporalType;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        switch (this.temporalType) {
            case DATE: {
                return "current_date";
            }
            case TIME: {
                return "current_time";
            }
        }
        return "current_timestamp";
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (StringUtils.isNotBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        switch (this.temporalType) {
            case DATE: {
                return new String[]{query.getJdbcAdaptor().getCurrentDate()};
            }
            case TIME: {
                return new String[]{query.getJdbcAdaptor().getCurrentTime()};
            }
        }
        return new String[]{query.getJdbcAdaptor().getCurrentTimeStamp()};
    }

    @Override
    public T handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return (T)row.getObject(this.alias);
    }
}

