/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractTypeExpression;
import org.batoo.jpa.core.impl.criteria.path.ParentPath;
import org.batoo.jpa.core.impl.instance.EnhancedInstance;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.jdbc.DiscriminatorColumn;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;

public class EntityTypeExpression<T>
extends AbstractTypeExpression<T> {
    private final DiscriminatorColumn discriminatorColumn;

    public EntityTypeExpression(ParentPath<?, T> path, DiscriminatorColumn discriminatorColumn) {
        super(path);
        this.discriminatorColumn = discriminatorColumn;
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        String tableAlias = this.getPath().getRootPath().getTableAlias(query, this.discriminatorColumn.getTable());
        return new String[]{tableAlias + "." + this.discriminatorColumn.getName()};
    }

    @Override
    public Class<? extends T> handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        Object object = this.getPath().handle(query, session, row);
        if (object == null) {
            return null;
        }
        if (object instanceof EnhancedInstance) {
            ManagedInstance<?> managedInstance = ((EnhancedInstance)object).__enhanced__$$__getManagedInstance();
            EntityTypeImpl<?> type = managedInstance.getType();
            return type.getJavaType();
        }
        return object.getClass();
    }
}

