/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class ExpressionConverter<N> {
    public static final ExpressionConverter<BigDecimal> BIG_DECIMAL = new ExpressionConverter<BigDecimal>(){

        @Override
        public BigDecimal convertImpl(Object original) {
            Number value = (Number)original;
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof Float) {
                return new BigDecimal(value.floatValue());
            }
            if (value instanceof Double) {
                return new BigDecimal(value.doubleValue());
            }
            if (value instanceof Byte) {
                return new BigDecimal(value.byteValue());
            }
            if (value instanceof Integer) {
                return new BigDecimal(value.intValue());
            }
            if (value instanceof Long) {
                return new BigDecimal(value.longValue());
            }
            if (value instanceof Short) {
                return new BigDecimal(value.shortValue());
            }
            if (value instanceof BigInteger) {
                return new BigDecimal((BigInteger)value);
            }
            throw new IllegalArgumentException("Cannot convert from " + value);
        }
    };
    public static final ExpressionConverter<BigInteger> BIG_INTEGER = new ExpressionConverter<BigInteger>(){

        @Override
        public BigInteger convertImpl(Object value) {
            if (value instanceof BigInteger) {
                return (BigInteger)value;
            }
            throw new IllegalArgumentException("Cannot convert from " + value);
        }
    };
    public static final ExpressionConverter<Double> DOUBLE = new ExpressionConverter<Double>(){

        @Override
        protected Double convertImpl(Object value) {
            if (value instanceof Double) {
                return (Double)value;
            }
            return new Double(((Number)value).doubleValue());
        }
    };
    public static final ExpressionConverter<Float> FLOAT = new ExpressionConverter<Float>(){

        @Override
        protected Float convertImpl(Object value) {
            if (value instanceof Float) {
                return (Float)value;
            }
            return new Float(((Number)value).floatValue());
        }
    };
    public static final ExpressionConverter<Short> SHORT = new ExpressionConverter<Short>(){

        @Override
        protected Short convertImpl(Object value) {
            if (value instanceof Short) {
                return (Short)value;
            }
            return new Short(((Number)value).shortValue());
        }
    };
    public static final ExpressionConverter<Long> LONG = new ExpressionConverter<Long>(){

        @Override
        protected Long convertImpl(Object value) {
            if (value instanceof Long) {
                return (Long)value;
            }
            return new Long(((Number)value).longValue());
        }
    };
    public static final ExpressionConverter<Integer> INTEGER = new ExpressionConverter<Integer>(){

        @Override
        protected Integer convertImpl(Object value) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            return new Integer(((Number)value).intValue());
        }
    };
    public static final ExpressionConverter<String> STRING = new ExpressionConverter<String>(){

        @Override
        protected String convertImpl(Object value) {
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof Character) {
                return ((Character)value).toString();
            }
            throw new IllegalArgumentException("Cannot convert from " + value);
        }
    };

    public N convert(Object value) {
        if (value == null) {
            return null;
        }
        return this.convertImpl(value);
    }

    protected abstract N convertImpl(Object var1);
}

