/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Type;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.jdbc.AbstractColumn;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.attribute.SingularAttributeImpl;
import org.batoo.jpa.core.impl.model.type.EmbeddableTypeImpl;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.type.TypeImpl;

public class ParameterExpressionImpl<T>
extends AbstractExpression<T>
implements ParameterExpression<T> {
    private TypeImpl<?> type;
    private Integer position;

    public ParameterExpressionImpl(TypeImpl<T> type, Class<T> paramClass, String name) {
        super(paramClass);
        this.type = type;
        if (StringUtils.isNotBlank((String)name)) {
            this.alias(name);
        }
    }

    protected void ensureAlias(BaseQueryImpl<?> query) {
        if (this.position == null) {
            this.position = query.getAlias(this);
            if (StringUtils.isBlank((String)this.getAlias())) {
                this.alias("param" + this.position);
            }
        }
    }

    private void ensureTypeResolved(MetamodelImpl metamodelImpl) {
        if (this.type == null) {
            this.type = metamodelImpl.type(this.getJavaType());
        }
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        this.ensureAlias(query);
        return ":" + this.getAlias();
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.ensureAlias(query);
        return null;
    }

    public int getExpandedCount(MetamodelImpl metamodelImpl) {
        if (this.getJavaType() == Class.class) {
            return 1;
        }
        this.ensureTypeResolved(metamodelImpl);
        if (this.type.getPersistenceType() == Type.PersistenceType.BASIC) {
            return 1;
        }
        if (this.type.getPersistenceType() == Type.PersistenceType.EMBEDDABLE) {
            return ((EmbeddableTypeImpl)this.type).getAttributeCount();
        }
        return ((EntityTypeImpl)this.type).getPrimaryTable().getPkColumns().size();
    }

    public String getName() {
        return this.getAlias();
    }

    public Class<T> getParameterType() {
        return this.getJavaType();
    }

    public Integer getPosition() {
        return this.position;
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        this.ensureAlias(query);
        query.setNextSqlParam(this);
        String[] restrictions = new String[this.getExpandedCount(query.getMetamodel())];
        for (int i = 0; i < restrictions.length; ++i) {
            restrictions[i] = "?";
        }
        return restrictions;
    }

    @Override
    public T handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        Object value = query.getParameterValue(this);
        return (T)(this.getConverter() != null ? this.getConverter().convert(value) : value);
    }

    public void setParameter(MetamodelImpl metamodel, Object[] parameters, MutableInt sqlIndex, Object value) {
        if (this.getJavaType() == Class.class) {
            EntityType entity = metamodel.entity((Class)value);
            if (entity == null) {
                throw new IllegalArgumentException("Type is not managed: " + value);
            }
            if (entity.getRootType().getInheritanceType() == null) {
                throw new IllegalArgumentException("Entity does not have inheritence: " + entity.getName());
            }
            parameters[sqlIndex.intValue()] = entity.getDiscriminatorValue();
            sqlIndex.increment();
        } else {
            this.ensureTypeResolved(metamodel);
            if (this.type.getPersistenceType() == Type.PersistenceType.BASIC) {
                parameters[sqlIndex.intValue()] = value;
                sqlIndex.increment();
            } else if (this.type.getPersistenceType() == Type.PersistenceType.ENTITY) {
                EntityTypeImpl type = (EntityTypeImpl)this.type;
                this.setParameter(parameters, sqlIndex, value, type);
            } else {
                EmbeddableTypeImpl type = (EmbeddableTypeImpl)this.type;
                this.setParameter(parameters, sqlIndex, value, type);
            }
        }
    }

    private void setParameter(Object[] parameters, MutableInt sqlIndex, Object value, EmbeddableTypeImpl<?> type) {
        SingularAttributeImpl<?, ?>[] attributes;
        block5: for (SingularAttributeImpl<?, ?> attribute : attributes = type.getSingularMappings()) {
            switch (attribute.getPersistentAttributeType()) {
                case BASIC: {
                    parameters[sqlIndex.intValue()] = attribute.get(value);
                    sqlIndex.increment();
                    continue block5;
                }
                case MANY_TO_ONE: 
                case ONE_TO_ONE: {
                    this.setParameter(parameters, sqlIndex, attribute.get(value), (EntityTypeImpl)attribute.getType());
                    continue block5;
                }
                case EMBEDDED: {
                    this.setParameter(parameters, sqlIndex, attribute.get(value), (EmbeddableTypeImpl)this.type);
                }
            }
        }
    }

    private void setParameter(Object[] parameters, MutableInt sqlIndex, Object value, EntityTypeImpl<?> type) {
        for (AbstractColumn column : type.getPrimaryTable().getPkColumns()) {
            parameters[sqlIndex.intValue()] = column.getMapping().get(value);
            sqlIndex.increment();
        }
    }
}

