/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.path;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.StaticTypeExpression;
import org.batoo.jpa.core.impl.criteria.join.FetchParentImpl;
import org.batoo.jpa.core.impl.criteria.join.Joinable;
import org.batoo.jpa.core.impl.criteria.path.ParentPath;
import org.batoo.jpa.core.impl.jdbc.BasicColumn;
import org.batoo.jpa.core.impl.jdbc.JoinColumn;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.attribute.EmbeddedAttribute;
import org.batoo.jpa.core.impl.model.mapping.BasicMapping;
import org.batoo.jpa.core.impl.model.mapping.EmbeddedMapping;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.core.impl.model.mapping.SingularAssociationMapping;

public class EmbeddedAttributePath<Z, X>
extends ParentPath<Z, X> {
    private final EmbeddedMapping<? super Z, X> mapping;
    private final FetchParentImpl<Z, X> fetchRoot;

    public EmbeddedAttributePath(ParentPath<?, Z> parent, EmbeddedMapping<? super Z, X> mapping) {
        super(parent, mapping.getType().getJavaType());
        this.fetchRoot = parent.getFetchRoot().fetch((SingularAttribute)mapping.getAttribute());
        this.mapping = mapping;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getParentPath().generateJpqlRestriction(query));
        builder.append(".").append(this.mapping.getAttribute().getName());
        return builder.toString();
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getParentPath().generateJpqlSelect(query, false));
        builder.append(".").append(this.mapping.getAttribute().getName());
        if (selected && StringUtils.isNotBlank((String)this.getAlias())) {
            builder.append(" as ").append(this.getAlias());
        }
        return builder.toString();
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        ArrayList fragments = Lists.newArrayList();
        this.generateSqlSelect(query, fragments, this.mapping.getSingularMappings());
        return Joiner.on((String)", ").join((Iterable)fragments);
    }

    private void generateSqlSelect(AbstractCriteriaQueryImpl<?> query, List<String> fragments, Mapping<?, ?, ?>[] mappings) {
        for (Mapping<?, ?, ?> mapping : mappings) {
            if (mapping instanceof BasicMapping) {
                BasicColumn column = ((BasicMapping)mapping).getColumn();
                String tableAlias = this.getRootPath().getTableAlias(query, column.getTable());
                fragments.add(tableAlias + "." + column.getName());
            }
            if (mapping instanceof SingularAssociationMapping) {
                SingularAssociationMapping associationMapping = (SingularAssociationMapping)mapping;
                for (JoinColumn column : associationMapping.getForeignKey().getJoinColumns()) {
                    String tableAlias = this.getRootPath().getTableAlias(query, column.getTable());
                    fragments.add(tableAlias + "." + column.getName());
                }
            }
            if (!(mapping instanceof EmbeddedMapping)) continue;
            EmbeddedMapping embeddedMapping = (EmbeddedMapping)mapping;
            this.generateSqlSelect(query, fragments, embeddedMapping.getSingularMappings());
        }
    }

    @Override
    public FetchParentImpl<?, X> getFetchRoot() {
        return this.fetchRoot;
    }

    public EmbeddedMapping<? super Z, X> getMapping() {
        return this.mapping;
    }

    @Override
    protected <C, Y> Mapping<? super X, C, Y> getMapping(String name) {
        Mapping child = this.mapping.getChild(name);
        if (child == null) {
            throw this.cannotDereference(name);
        }
        return child;
    }

    public EmbeddedAttribute<?, X> getModel() {
        return this.mapping.getAttribute();
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        ArrayList restrictions = Lists.newArrayList();
        Joinable rootPath = this.getRootPath();
        ArrayList mappings = Lists.newArrayList();
        for (Mapping mapping : this.mapping.getChildren()) {
            if (!(mapping instanceof BasicMapping)) continue;
            mappings.add((BasicMapping)mapping);
        }
        Collections.sort(mappings, new Comparator<BasicMapping<?, ?>>(){

            @Override
            public int compare(BasicMapping<?, ?> o1, BasicMapping<?, ?> o2) {
                return o1.getAttribute().getAttributeId().compareTo(o2.getAttribute().getAttributeId());
            }
        });
        for (BasicMapping basicMapping : mappings) {
            BasicColumn column = basicMapping.getColumn();
            restrictions.add(rootPath.getTableAlias(query, column.getTable()) + "." + column.getName());
        }
        return restrictions.toArray(new String[restrictions.size()]);
    }

    @Override
    public X handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        Object instance = this.getParentPath().handle(query, session, row);
        return this.mapping.get(instance);
    }

    public StaticTypeExpression<X> type() {
        return new StaticTypeExpression(this, this.getModel().getJavaType());
    }
}

