/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.path;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.criteria.JoinType;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractTypeExpression;
import org.batoo.jpa.core.impl.criteria.expression.EntityTypeExpression;
import org.batoo.jpa.core.impl.criteria.expression.StaticTypeExpression;
import org.batoo.jpa.core.impl.criteria.join.AbstractFrom;
import org.batoo.jpa.core.impl.criteria.join.FetchImpl;
import org.batoo.jpa.core.impl.criteria.join.FetchParentImpl;
import org.batoo.jpa.core.impl.criteria.join.Joinable;
import org.batoo.jpa.core.impl.criteria.join.MapJoinImpl;
import org.batoo.jpa.core.impl.criteria.path.ParentPath;
import org.batoo.jpa.core.impl.jdbc.AbstractTable;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;

public class EntityPath<Z, X>
extends ParentPath<Z, X>
implements Joinable {
    private final FetchImpl<Z, X> fetchRoot;
    private final String pathName;
    private final EntityTypeImpl<X> entity;

    public EntityPath(ParentPath<?, Z> parent, String pathName, EntityTypeImpl<X> entity) {
        super(parent, entity.getJavaType());
        this.pathName = pathName;
        this.entity = entity;
        this.fetchRoot = parent.getFetchRoot().join(pathName, JoinType.LEFT);
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getParentPath().generateJpqlRestriction(query));
        builder.append(".").append(this.pathName);
        return builder.toString();
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        StringBuilder builder = new StringBuilder();
        if (this.getParentPath() instanceof AbstractFrom && StringUtils.isNotBlank((String)this.getParentPath().getAlias())) {
            builder.append(this.getParentPath().getAlias());
        } else {
            builder.append(this.getParentPath().generateJpqlSelect(null, false));
        }
        builder.append(".").append(this.pathName);
        if (selected && StringUtils.isNotBlank((String)this.getAlias())) {
            builder.append(" as ").append(this.getAlias());
        }
        return builder.toString();
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        return this.fetchRoot.generateSqlSelect(query, selected, false);
    }

    @Override
    public EntityTypeImpl<?> getEntity() {
        return this.entity;
    }

    @Override
    public FetchParentImpl<?, X> getFetchRoot() {
        return this.fetchRoot;
    }

    @Override
    protected <C, Y> Mapping<? super X, C, Y> getMapping(String name) {
        Mapping mapping = this.entity.getRootMapping().getChild(name);
        if (mapping == null) {
            throw this.cannotDereference(name);
        }
        return mapping;
    }

    public EntityTypeImpl<X> getModel() {
        return this.entity;
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        return this.fetchRoot.getSqlRestrictionFragments(query, MapJoinImpl.MapSelectType.VALUE);
    }

    @Override
    public String getTableAlias(BaseQueryImpl<?> query, AbstractTable table) {
        return this.getFetchRoot().getTableAlias(query, table);
    }

    @Override
    public X handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return this.fetchRoot.handle(session, row);
    }

    public AbstractTypeExpression<X> type() {
        if (this.entity.getRootType().getInheritanceType() != null) {
            return new EntityTypeExpression(this, this.entity.getRootType().getDiscriminatorColumn());
        }
        return new StaticTypeExpression<X>(this, this.getModel().getBindableJavaType());
    }
}

