/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.deployment;

import org.batoo.jpa.common.BatooException;
import org.batoo.jpa.common.log.BLogger;
import org.batoo.jpa.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.deployment.DeploymentManager;
import org.batoo.jpa.core.impl.jdbc.DataSourceImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.jdbc.DDLMode;

public class DdlManager
extends DeploymentManager<EntityTypeImpl<?>> {
    private static final BLogger LOG = BLoggerFactory.getLogger(DdlManager.class);
    private final DataSourceImpl datasource;
    private final DDLMode ddlMode;
    private final DdlPhase ddlPhase;

    public static void perform(DataSourceImpl datasource, MetamodelImpl metamodel, DDLMode ddlMode) throws BatooException {
        new DdlManager(datasource, metamodel, ddlMode, DdlPhase.TABLES).perform();
        new DdlManager(datasource, metamodel, ddlMode, DdlPhase.FOREIGN_KEYS).perform();
    }

    private DdlManager(DataSourceImpl datasource, MetamodelImpl metamodel, DDLMode ddlMode, DdlPhase ddlPhase) {
        super(LOG, "DDL Manager", metamodel, DeploymentManager.Context.ENTITIES);
        this.datasource = datasource;
        this.ddlMode = ddlMode;
        this.ddlPhase = ddlPhase;
    }

    @Override
    public Void perform(EntityTypeImpl<?> type) throws BatooException {
        switch (this.ddlPhase) {
            case TABLES: {
                this.getMetamodel().performTablesDdl(this.datasource, this.ddlMode, type);
                break;
            }
            case FOREIGN_KEYS: {
                this.getMetamodel().performForeignKeysDdl(this.datasource, this.ddlMode, type);
            }
        }
        return null;
    }

    public static enum DdlPhase {
        TABLES,
        FOREIGN_KEYS;

    }
}

