/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.jdbc.AbstractColumn;
import org.batoo.jpa.core.impl.jdbc.DiscriminatorColumn;
import org.batoo.jpa.core.impl.jdbc.ForeignKey;
import org.batoo.jpa.core.impl.jdbc.JoinColumn;
import org.batoo.jpa.core.impl.jdbc.PkColumn;
import org.batoo.jpa.core.impl.model.attribute.AttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.BasicAttribute;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.jdbc.IdType;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.impl.AbstractLocator;
import org.batoo.jpa.parser.metadata.TableMetadata;
import org.batoo.jpa.parser.metadata.UniqueConstraintMetadata;

public abstract class AbstractTable {
    private final AbstractLocator locator;
    private final String catalog;
    private final String schema;
    private String name;
    private final Map<String, AbstractColumn> columns = Maps.newHashMap();
    private final Map<String, String[]> uniqueConstraints = Maps.newHashMap();
    private final List<ForeignKey> foreignKeys = Lists.newArrayList();
    private final Map<EntityTypeImpl<?>, String> insertSqlMap = Maps.newHashMap();
    private final Map<EntityTypeImpl<?>, String> updateSqlMap = Maps.newHashMap();
    private String insertSql;
    private String updateSql;
    private String versionUpdateSql;
    private String versionSelectSql;
    private AbstractColumn[] insertColumns;
    private AbstractColumn[] updateColumns;
    private AbstractColumn[] versionUpdateColumns;
    private AbstractColumn[] selectVersionColumns;
    private final Map<EntityTypeImpl<?>, AbstractColumn[]> insertColumnsMap = Maps.newHashMap();
    private final Map<EntityTypeImpl<?>, AbstractColumn[]> updateColumnsMap = Maps.newHashMap();

    public AbstractTable(String defaultName, TableMetadata metadata) {
        this(metadata);
        if (this.name == null) {
            this.name = defaultName;
        }
    }

    public AbstractTable(TableMetadata metadata) {
        this.locator = metadata != null ? metadata.getLocator() : null;
        this.catalog = metadata != null && StringUtils.isNotBlank((String)metadata.getCatalog()) ? metadata.getCatalog() : null;
        String string = this.schema = metadata != null && StringUtils.isNotBlank((String)metadata.getSchema()) ? metadata.getSchema() : null;
        if (metadata != null) {
            if (StringUtils.isNotBlank((String)metadata.getName())) {
                this.name = metadata.getName();
            }
            for (UniqueConstraintMetadata constraint : metadata.getUniqueConstraints()) {
                this.uniqueConstraints.put(constraint.getName(), constraint.getColumnNames());
            }
        }
    }

    public void addColumn(AbstractColumn column) {
        AbstractColumn existing = this.columns.put(column.getMappingName(), column);
        if (existing != null) {
            throw new MappingException("Duplicate column names " + column.getMappingName() + " on table " + this.name, column.getLocator(), existing.getLocator());
        }
    }

    public void addForeignKey(ForeignKey foreignKey) {
        this.foreignKeys.add(foreignKey);
    }

    private synchronized void generateInsertSql(final EntityTypeImpl<?> type) {
        String sql;
        String string = sql = type != null ? this.insertSqlMap.get(type) : this.insertSql;
        if (sql != null) {
            return;
        }
        final ArrayList insertColumns = Lists.newArrayList();
        Collection filteredColumns = type == null ? this.getColumns() : Collections2.filter(this.getColumns(), (Predicate)new Predicate<AbstractColumn>(){

            public boolean apply(AbstractColumn input) {
                if (input instanceof PkColumn && ((PkColumn)input).getIdType() == IdType.IDENTITY) {
                    return false;
                }
                if (!input.isInsertable()) {
                    return false;
                }
                if (input instanceof DiscriminatorColumn) {
                    return true;
                }
                EntityTypeImpl root = input instanceof JoinColumn && input.getMapping() == null ? (EntityTypeImpl)((JoinColumn)input).getReferencedMapping().getRoot().getType() : (EntityTypeImpl)input.getMapping().getRoot().getType();
                Class parent = root.getJavaType();
                Class javaType = type.getJavaType();
                return parent.isAssignableFrom(javaType);
            }
        });
        Collection columnNames = Collections2.transform((Collection)filteredColumns, (Function)new Function<AbstractColumn, String>(){

            public String apply(AbstractColumn input) {
                insertColumns.add(input);
                return input.getName();
            }
        });
        Collection parameters = Collections2.transform((Collection)filteredColumns, (Function)new Function<AbstractColumn, String>(){

            public String apply(AbstractColumn input) {
                return "?";
            }
        });
        String columnNamesStr = Joiner.on((String)", ").join((Iterable)columnNames);
        String parametersStr = Joiner.on((String)", ").join((Iterable)parameters);
        sql = "INSERT INTO " + this.getQName() + "\n(" + columnNamesStr + ")" + "\nVALUES (" + parametersStr + ")";
        if (type != null) {
            this.insertSqlMap.put(type, sql);
            this.insertColumnsMap.put(type, insertColumns.toArray(new AbstractColumn[insertColumns.size()]));
        } else {
            this.insertSql = sql;
            this.insertColumns = insertColumns.toArray(new AbstractColumn[insertColumns.size()]);
        }
    }

    private synchronized void generateSelectVersionSql(Map<String, AbstractColumn> pkColumns) {
        if (this.versionSelectSql != null) {
            return;
        }
        AbstractColumn versionColumn = null;
        for (AbstractColumn column : this.getColumns()) {
            AttributeImpl<?, ?> attribute = column.getMapping().getAttribute();
            if (!(attribute instanceof BasicAttribute) || !((BasicAttribute)attribute).isVersion()) continue;
            versionColumn = column;
            break;
        }
        final ArrayList selectVersionColumns = Lists.newArrayList();
        Collection restrictions = Collections2.transform(pkColumns.values(), (Function)new Function<AbstractColumn, String>(){

            public String apply(AbstractColumn input) {
                selectVersionColumns.add(input);
                return input.getName() + " = ?";
            }
        });
        String restrictionStr = Joiner.on((String)" AND ").join((Iterable)restrictions);
        this.versionSelectSql = "SELECT " + versionColumn.getName() + " FROM " + this.getQName() + "\nWHERE " + restrictionStr;
        this.selectVersionColumns = selectVersionColumns.toArray(new AbstractColumn[selectVersionColumns.size()]);
    }

    private synchronized void generateUpdateSql(final EntityTypeImpl<?> type, Map<String, AbstractColumn> pkColumns) {
        String sql;
        String string = sql = type != null ? this.updateSqlMap.get(type) : this.insertSql;
        if (sql != null) {
            return;
        }
        final ArrayList updateColumns = Lists.newArrayList();
        Collection filteredColumns = type == null ? this.getColumns() : Collections2.filter(this.getColumns(), (Predicate)new Predicate<AbstractColumn>(){

            public boolean apply(AbstractColumn input) {
                if (input.isPrimaryKey() || input instanceof DiscriminatorColumn) {
                    return false;
                }
                if (!input.isUpdatable()) {
                    return false;
                }
                EntityTypeImpl root = input instanceof JoinColumn && input.getMapping() == null ? (EntityTypeImpl)((JoinColumn)input).getReferencedMapping().getRoot().getType() : (EntityTypeImpl)input.getMapping().getRoot().getType();
                Class parent = root.getJavaType();
                Class javaType = type.getJavaType();
                return parent.isAssignableFrom(javaType);
            }
        });
        Collection columnNames = Collections2.transform((Collection)filteredColumns, (Function)new Function<AbstractColumn, String>(){

            public String apply(AbstractColumn input) {
                if (!input.isPrimaryKey()) {
                    updateColumns.add(input);
                    return input.getName() + " = ?";
                }
                return null;
            }
        });
        Collection restrictions = Collections2.transform(pkColumns.values(), (Function)new Function<AbstractColumn, String>(){

            public String apply(AbstractColumn input) {
                updateColumns.add(input);
                return input.getName() + " = ?";
            }
        });
        String columnNamesStr = Joiner.on((String)", ").skipNulls().join((Iterable)columnNames);
        String restrictionStr = Joiner.on((String)" AND ").join((Iterable)restrictions);
        sql = "UPDATE " + this.getQName() + " SET" + "\n" + columnNamesStr + "\nWHERE " + restrictionStr;
        if (type != null) {
            this.updateSqlMap.put(type, sql);
            this.updateColumnsMap.put(type, updateColumns.toArray(new AbstractColumn[updateColumns.size()]));
        } else {
            this.updateSql = sql;
            this.updateColumns = updateColumns.toArray(new AbstractColumn[updateColumns.size()]);
        }
    }

    private synchronized void generateVersionUpdateSql(Map<String, AbstractColumn> pkColumns) {
        if (this.versionUpdateSql != null) {
            return;
        }
        final ArrayList versionUpdateColumns = Lists.newArrayList();
        for (AbstractColumn column : this.getColumns()) {
            AttributeImpl<?, ?> attribute = column.getMapping().getAttribute();
            if (!(attribute instanceof BasicAttribute) || !((BasicAttribute)attribute).isVersion()) continue;
            versionUpdateColumns.add(column);
            break;
        }
        Collection restrictions = Collections2.transform(pkColumns.values(), (Function)new Function<AbstractColumn, String>(){

            public String apply(AbstractColumn input) {
                versionUpdateColumns.add(input);
                return input.getName() + " = ?";
            }
        });
        String columnNamesStr = ((AbstractColumn)versionUpdateColumns.get(0)).getName() + " = ?";
        String restrictionStr = Joiner.on((String)" AND ").join((Iterable)restrictions);
        this.versionUpdateSql = "UPDATE " + this.getQName() + " SET" + "\n" + columnNamesStr + "\nWHERE " + restrictionStr;
        this.versionUpdateColumns = versionUpdateColumns.toArray(new AbstractColumn[versionUpdateColumns.size()]);
    }

    public String getCatalog() {
        return this.catalog;
    }

    public Set<String> getColumnNames() {
        return this.columns.keySet();
    }

    public Collection<AbstractColumn> getColumns() {
        return this.columns.values();
    }

    public List<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    protected AbstractColumn[] getInsertColumns(EntityTypeImpl<?> entity) {
        if (entity == null) {
            return this.insertColumns;
        }
        return this.insertColumnsMap.get(entity);
    }

    protected String getInsertSql(EntityTypeImpl<?> entity) {
        if (entity == null) {
            if (this.insertSql == null) {
                this.generateInsertSql(null);
            }
            return this.insertSql;
        }
        String sql = this.insertSqlMap.get(entity);
        if (sql == null) {
            this.generateInsertSql(entity);
            sql = this.insertSqlMap.get(entity);
        }
        return sql;
    }

    public AbstractLocator getLocator() {
        return this.locator;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getPkColumnNames() {
        return Collections.emptySet();
    }

    public String getQName() {
        return Joiner.on((String)".").skipNulls().join((Object)this.schema, (Object)this.name, new Object[0]);
    }

    public String getSchema() {
        return this.schema;
    }

    public AbstractColumn[] getSelectVersionColumns() {
        return this.selectVersionColumns;
    }

    protected String getSelectVersionSql(Map<String, AbstractColumn> pkColumns) {
        if (this.versionSelectSql == null) {
            this.generateSelectVersionSql(pkColumns);
        }
        return this.versionSelectSql;
    }

    public Map<String, String[]> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    protected AbstractColumn[] getUpdateColumns(EntityTypeImpl<?> entity) {
        if (entity == null) {
            return this.updateColumns;
        }
        return this.updateColumnsMap.get(entity);
    }

    protected String getUpdateSql(EntityTypeImpl<?> entity, Map<String, AbstractColumn> pkColumns) {
        if (entity == null) {
            if (this.updateSql == null) {
                this.generateUpdateSql(null, pkColumns);
            }
            return this.updateSql;
        }
        String sql = this.updateSqlMap.get(entity);
        if (sql == null) {
            this.generateUpdateSql(entity, pkColumns);
            sql = this.updateSqlMap.get(entity);
        }
        return sql;
    }

    public AbstractColumn[] getVersionUpdateColumns() {
        return this.versionUpdateColumns;
    }

    protected String getVersionUpdateSql(Map<String, AbstractColumn> pkColumns) {
        if (this.updateSql == null) {
            this.generateVersionUpdateSql(pkColumns);
        }
        return this.updateSql;
    }

    protected void setName(String name) {
        this.name = name;
    }
}

