/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.common.reflect.ReflectHelper;
import org.batoo.jpa.core.impl.jdbc.AbstractColumn;
import org.batoo.jpa.core.impl.jdbc.AbstractTable;
import org.batoo.jpa.core.impl.model.attribute.BasicAttribute;
import org.batoo.jpa.core.impl.model.mapping.BasicMapping;
import org.batoo.jpa.core.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.impl.AbstractLocator;
import org.batoo.jpa.parser.metadata.ColumnMetadata;

public class BasicColumn
extends AbstractColumn {
    private AbstractTable table;
    private final int sqlType;
    private final String name;
    private final String columnDefinition;
    private final int length;
    private final AbstractLocator locator;
    private final int precision;
    private final int scale;
    private final String tableName;
    private final boolean nullable;
    private final boolean insertable;
    private final boolean unique;
    private final boolean updatable;
    private final String mappingName;
    private final BasicMapping<?, ?> mapping;
    private final JdbcAdaptor jdbcAdaptor;
    private final EnumType enumType;
    private final Enum<?>[] values;
    private final Method method;
    private final TemporalType temporalType;
    private final Class<?> numberType;

    public BasicColumn(JdbcAdaptor jdbcAdaptor, BasicMapping<?, ?> mapping, int sqlType, ColumnMetadata metadata) {
        this.jdbcAdaptor = jdbcAdaptor;
        this.mapping = mapping;
        this.locator = metadata != null ? metadata.getLocator() : null;
        this.sqlType = sqlType;
        this.mappingName = metadata != null && StringUtils.isNotBlank((String)metadata.getName()) ? metadata.getName() : this.mapping.getAttribute().getName();
        this.name = this.jdbcAdaptor.escape(this.mappingName);
        this.tableName = metadata != null ? metadata.getTable() : "";
        this.columnDefinition = metadata != null ? metadata.getColumnDefinition() : "";
        this.length = metadata != null ? metadata.getLength() : 255;
        this.precision = metadata != null ? metadata.getPrecision() : 0;
        this.scale = metadata != null ? metadata.getScale() : 0;
        this.insertable = metadata != null ? metadata.isInsertable() : true;
        this.nullable = metadata != null ? metadata.isNullable() : true;
        this.unique = metadata != null ? metadata.isUnique() : false;
        this.updatable = metadata != null ? metadata.isUpdatable() : true;
        this.numberType = Number.class.isAssignableFrom(mapping.getAttribute().getJavaType()) ? mapping.getAttribute().getJavaType() : null;
        this.temporalType = ((BasicAttribute)mapping.getAttribute()).getTemporalType();
        this.enumType = ((BasicAttribute)mapping.getAttribute()).getEnumType();
        if (this.enumType != null) {
            Class enumJavaType = mapping.getAttribute().getJavaType();
            try {
                if (this.enumType == EnumType.ORDINAL) {
                    this.values = (Enum[])enumJavaType.getMethod("values", new Class[0]).invoke(null, new Object[0]);
                    this.method = null;
                }
                this.values = null;
                this.method = enumJavaType.getMethod("valueOf", String.class);
            }
            catch (Exception e) {
                throw new MappingException("Unable to map enum type", this.mapping.getAttribute().getLocator());
            }
        } else {
            this.values = null;
            this.method = null;
        }
    }

    public Object convertValue(Object value) {
        if (value == null) {
            return null;
        }
        if (this.temporalType != null) {
            switch (this.temporalType) {
                case DATE: {
                    if (value instanceof Date) {
                        return value;
                    }
                    if (value instanceof java.util.Date) {
                        return new Date(((java.util.Date)value).getTime());
                    }
                    return new Date(((Calendar)value).getTimeInMillis());
                }
                case TIME: {
                    if (value instanceof Time) {
                        return value;
                    }
                    if (value instanceof java.util.Date) {
                        return new Time(((java.util.Date)value).getTime());
                    }
                    return new Time(((Calendar)value).getTimeInMillis());
                }
                case TIMESTAMP: {
                    if (value instanceof Timestamp) {
                        return value;
                    }
                    if (value instanceof java.util.Date) {
                        return new Timestamp(((java.util.Date)value).getTime());
                    }
                    return new Timestamp(((Calendar)value).getTimeInMillis());
                }
            }
        }
        if (this.numberType != null) {
            return ReflectHelper.convertNumber((Number)value, this.numberType);
        }
        if (this.enumType == null) {
            return value;
        }
        Enum enumValue = (Enum)value;
        if (this.enumType == EnumType.ORDINAL) {
            return enumValue.ordinal();
        }
        return enumValue.name();
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public AbstractLocator getLocator() {
        return this.locator;
    }

    public BasicMapping<?, ?> getMapping() {
        return this.mapping;
    }

    @Override
    public String getMappingName() {
        return this.mappingName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public int getSqlType() {
        return this.sqlType;
    }

    @Override
    public AbstractTable getTable() {
        return this.table;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public Object getValue(Object instance) {
        Object value = this.mapping.get(instance);
        return this.convertValue(value);
    }

    @Override
    public boolean isInsertable() {
        return this.insertable;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public boolean isUpdatable() {
        return this.updatable;
    }

    @Override
    public void setTable(AbstractTable table) {
        this.table = table;
        this.table.addColumn(this);
    }

    @Override
    public void setValue(Object instance, Object value) {
        if (value != null && this.enumType != null) {
            if (this.enumType == EnumType.ORDINAL) {
                value = this.values[((Number)value).shortValue()];
            } else {
                try {
                    value = this.method.invoke(null, value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.mapping.set(instance, value);
    }
}

