/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.commons.lang.NotImplementedException;
import org.batoo.jpa.common.BatooException;
import org.batoo.jpa.common.log.BLogger;
import org.batoo.jpa.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.jdbc.ConnectionFactory;
import org.batoo.jpa.core.impl.jdbc.ConnectionImpl;
import org.batoo.jpa.core.impl.manager.OperationTookLongTimeWarning;
import org.batoo.jpa.core.pool.GenericPool;

public class DataSourceImpl
implements DataSource {
    private static final BLogger LOG = BLoggerFactory.getLogger(DataSourceImpl.class);
    static final int MAX_WAIT = 1000;
    private final DataSource datasource;
    private final String jdbcUrl;
    private final String jdbcUser;
    private final String jdbcPassword;
    private final GenericPool<ConnectionImpl> pool;
    private PrintWriter printer;
    private int loginTimeout;
    private boolean open;

    public DataSourceImpl(String datasource) {
        try {
            this.datasource = (DataSource)new InitialContext().lookup(datasource);
        }
        catch (Exception e) {
            throw new BatooException("Unable to lookup datasource: " + datasource, e);
        }
        this.jdbcUrl = null;
        this.jdbcUser = null;
        this.jdbcPassword = null;
        this.pool = null;
        LOG.info("Datasource active: {0}", datasource);
        this.open = true;
    }

    public DataSourceImpl(String jdbcUrl, String jdbcUser, String jdbcPassword) throws SQLException {
        this.jdbcUrl = jdbcUrl;
        this.jdbcUser = jdbcUser;
        this.jdbcPassword = jdbcPassword;
        this.datasource = null;
        this.pool = new GenericPool(new ConnectionFactory(this));
        LOG.info("Datasource active: {0}", this.jdbcUrl);
        this.open = true;
    }

    public void close() {
        if (this.open) {
            LOG.info("Datasource closed: {0}", this.jdbcUrl);
            try {
                if (this.pool != null) {
                    this.pool.close();
                }
            }
            catch (Exception e) {
                LOG.warn(e, "Error while closing connection cache");
            }
        }
        this.open = false;
    }

    @Override
    public ConnectionImpl getConnection() throws SQLException {
        if (!this.open) {
            throw new IllegalStateException("Datasource closed");
        }
        try {
            if (this.pool != null) {
                return this.pool.borrowObject();
            }
            return this.getConnection0();
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException(e);
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new NotImplementedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionImpl getConnection0() throws SQLException {
        long start;
        block9: {
            ConnectionImpl connectionImpl;
            LOG.trace("getConnection()");
            start = System.currentTimeMillis();
            try {
                if (this.datasource == null) break block9;
                connectionImpl = new ConnectionImpl(this.datasource.getConnection(), this.pool);
            }
            catch (Throwable throwable) {
                long time = System.currentTimeMillis() - start;
                if (time > 2500L) {
                    LOG.warn(new OperationTookLongTimeWarning(), "{0} msecs, getConnection()", time);
                } else {
                    LOG.trace("{0} msecs, getConnection()", time);
                }
                throw throwable;
            }
            long time = System.currentTimeMillis() - start;
            if (time > 2500L) {
                LOG.warn(new OperationTookLongTimeWarning(), "{0} msecs, getConnection()", time);
            } else {
                LOG.trace("{0} msecs, getConnection()", time);
            }
            return connectionImpl;
        }
        Connection connection = DriverManager.getConnection(this.jdbcUrl, this.jdbcUser, this.jdbcPassword);
        ConnectionImpl connectionImpl = new ConnectionImpl(connection, this.pool);
        long time = System.currentTimeMillis() - start;
        if (time > 2500L) {
            LOG.warn(new OperationTookLongTimeWarning(), "{0} msecs, getConnection()", time);
        } else {
            LOG.trace("{0} msecs, getConnection()", time);
        }
        return connectionImpl;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.printer;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.printer = out;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }
}

