/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import javax.persistence.DiscriminatorType;
import org.batoo.jpa.core.impl.jdbc.AbstractColumn;
import org.batoo.jpa.core.impl.jdbc.AbstractTable;
import org.batoo.jpa.core.impl.jdbc.EntityTable;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.parser.impl.AbstractLocator;
import org.batoo.jpa.parser.metadata.DiscriminatorColumnMetadata;

public class DiscriminatorColumn
extends AbstractColumn {
    private final EntityTable table;
    private final AbstractLocator locator;
    private final String columnDefinition;
    private final DiscriminatorType discriminatorType;
    private final int length;
    private final String mappingName;
    private final String name;

    public DiscriminatorColumn(EntityTypeImpl<?> entity, DiscriminatorColumnMetadata metadata) {
        this.locator = metadata != null ? metadata.getLocator() : null;
        this.mappingName = metadata != null ? metadata.getName() : "DTYPE";
        this.name = entity.getMetamodel().getJdbcAdaptor().escape(this.mappingName);
        this.table = entity.getPrimaryTable();
        this.columnDefinition = metadata != null ? metadata.getColumnDefinition() : null;
        DiscriminatorType discriminatorType = this.discriminatorType = metadata != null ? metadata.getDiscriminatorType() : DiscriminatorType.STRING;
        this.length = metadata != null ? (metadata.getDiscriminatorType() == DiscriminatorType.CHAR ? 1 : metadata.getLength()) : 31;
        this.table.addColumn(this);
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public AbstractLocator getLocator() {
        return this.locator;
    }

    @Override
    public Mapping<?, ?, ?> getMapping() {
        return null;
    }

    @Override
    public String getMappingName() {
        return this.mappingName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int getSqlType() {
        switch (this.discriminatorType) {
            case CHAR: 
            case STRING: {
                return 12;
            }
        }
        return 4;
    }

    @Override
    public AbstractTable getTable() {
        return this.table;
    }

    @Override
    public String getTableName() {
        return this.table.getName();
    }

    @Override
    public Object getValue(Object instance) {
        return null;
    }

    @Override
    public boolean isInsertable() {
        return true;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public boolean isUpdatable() {
        return true;
    }

    @Override
    public void setTable(AbstractTable table) {
    }

    @Override
    public void setValue(Object instance, Object value) {
    }
}

