/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.manager;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.common.BatooException;
import org.batoo.jpa.common.log.BLogger;
import org.batoo.jpa.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.cache.CacheImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaBuilderImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.jpql.JpqlQuery;
import org.batoo.jpa.core.impl.deployment.DdlManager;
import org.batoo.jpa.core.impl.deployment.LinkManager;
import org.batoo.jpa.core.impl.deployment.NamedQueriesManager;
import org.batoo.jpa.core.impl.jdbc.AbstractJdbcAdaptor;
import org.batoo.jpa.core.impl.jdbc.ConnectionImpl;
import org.batoo.jpa.core.impl.jdbc.DataSourceImpl;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.manager.PersistenceUnitUtilImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.jdbc.DDLMode;
import org.batoo.jpa.core.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.parser.PersistenceParser;
import org.batoo.jpa.parser.impl.AbstractLocator;
import org.batoo.jpa.parser.metadata.NamedQueryMetadata;

public class EntityManagerFactoryImpl
implements EntityManagerFactory {
    private static final BLogger LOG = BLoggerFactory.getLogger(EntityManagerFactoryImpl.class);
    private static final int NO_QUERIES_MAX = 1000;
    private static final int NO_QUERIES_TRIM = 100;
    private final MetamodelImpl metamodel;
    private final DataSourceImpl datasource;
    private final CacheImpl cache;
    private final DDLMode ddlMode;
    private final JdbcAdaptor jdbcAdaptor;
    private final Map<String, Object> properties = Maps.newHashMap();
    private final Map<String, JpqlQuery> namedQueries = Maps.newHashMap();
    private final CriteriaBuilderImpl criteriaBuilder;
    private final PersistenceUnitUtilImpl persistenceUtil;
    private final HashMap<String, JpqlQuery> jpqlCache = Maps.newHashMap();
    private final ClassLoader classloader;
    private final ValidatorFactory validationFactory;
    private final Class<?>[] persistValidators;
    private final Class<?>[] updateValidators;
    private final Class<?>[] removeValidators;
    private boolean open;

    public EntityManagerFactoryImpl(String name, PersistenceParser parser) {
        this.classloader = parser.getClassloader();
        this.prepareProperties(parser);
        boolean hasValidators = parser.hasValidators();
        if (hasValidators) {
            this.validationFactory = Validation.buildDefaultValidatorFactory();
            this.persistValidators = this.getValidatorsFor(parser, "javax.persistence.validation.group.pre-persist");
            this.updateValidators = this.getValidatorsFor(parser, "javax.persistence.validation.group.pre-update");
            this.removeValidators = this.getValidatorsFor(parser, "javax.persistence.validation.group.pre-remove");
        } else {
            this.validationFactory = null;
            this.persistValidators = null;
            this.updateValidators = null;
            this.removeValidators = null;
        }
        this.datasource = this.createDatasource(parser);
        this.cache = new CacheImpl(this, parser.getSharedCacheMode());
        this.ddlMode = this.readDdlMode();
        this.jdbcAdaptor = this.createJdbcAdaptor();
        this.metamodel = new MetamodelImpl(this, this.jdbcAdaptor, parser.getMetadata());
        LinkManager.perform(this.metamodel);
        if (this.ddlMode == DDLMode.DROP) {
            this.metamodel.dropAllTables(this.datasource);
        }
        DdlManager.perform(this.datasource, this.metamodel, this.ddlMode);
        this.metamodel.performSequencesDdl(this.datasource, this.ddlMode);
        this.metamodel.performTableGeneratorsDdl(this.datasource, this.ddlMode);
        this.metamodel.preFillGenerators(this.datasource);
        this.criteriaBuilder = new CriteriaBuilderImpl(this.metamodel);
        NamedQueriesManager.perform(this.metamodel, this.criteriaBuilder);
        this.persistenceUtil = new PersistenceUnitUtilImpl(this);
        this.open = true;
    }

    public void addNamedQuery(String name, JpqlQuery jpqlQuery) {
        if (this.namedQueries.containsKey(name)) {
            throw new IllegalArgumentException("A named query with the same name already exists: " + name);
        }
        this.namedQueries.put(name, jpqlQuery);
    }

    public void addNamedQuery(final String name, Query query) {
        final QueryImpl typedQuery = (QueryImpl)query;
        final String jpql = typedQuery.getCriteriaQuery().getJpql();
        new JpqlQuery(this, this.criteriaBuilder, new NamedQueryMetadata(){

            @Override
            public Map<String, Object> getHints() {
                return typedQuery.getHints();
            }

            @Override
            public AbstractLocator getLocator() {
                return null;
            }

            @Override
            public LockModeType getLockMode() {
                return typedQuery.getLockMode();
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getQuery() {
                return jpql;
            }
        });
    }

    protected void assertOpen() {
        if (!this.open) {
            throw new IllegalStateException("EntityManagerFactory has been previously closed");
        }
    }

    public void close() {
        this.assertOpen();
        this.metamodel.stopIdGenerators();
        this.datasource.close();
        this.open = false;
    }

    private DataSourceImpl createDatasource(PersistenceParser parser) {
        if (StringUtils.isNotBlank((String)parser.getJtaDatasource())) {
            return new DataSourceImpl(parser.getJtaDatasource());
        }
        if (StringUtils.isNotBlank((String)parser.getNonJtaDatasource())) {
            return new DataSourceImpl(parser.getNonJtaDatasource());
        }
        String jdbcDriver = (String)this.getProperty("javax.persistence.jdbc.driver");
        String jdbcUrl = (String)this.getProperty("javax.persistence.jdbc.url");
        String jdbcUser = (String)this.getProperty("javax.persistence.jdbc.user");
        String jdbcPassword = (String)this.getProperty("javax.persistence.jdbc.password");
        try {
            try {
                this.classloader.loadClass(jdbcDriver).newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
            return new DataSourceImpl(jdbcUrl, jdbcUser, jdbcPassword);
        }
        catch (Exception e) {
            throw new BatooException("Datasource cannot be created", e);
        }
    }

    public EntityManagerImpl createEntityManager() {
        this.assertOpen();
        return new EntityManagerImpl(this, this.metamodel, this.datasource, Collections.<String, Object>emptyMap(), this.jdbcAdaptor);
    }

    public EntityManager createEntityManager(Map<String, Object> map) {
        this.assertOpen();
        return new EntityManagerImpl(this, this.metamodel, this.datasource, map, this.jdbcAdaptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JdbcAdaptor createJdbcAdaptor() {
        JdbcAdaptor jdbcAdaptor;
        ConnectionImpl connection = this.datasource.getConnection();
        try {
            jdbcAdaptor = AbstractJdbcAdaptor.getAdapter(this.classloader, connection.getMetaData().getDatabaseProductName());
        }
        catch (Throwable throwable) {
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new BatooException("Unable to get connection from the datasource", e);
            }
        }
        connection.close();
        return jdbcAdaptor;
    }

    public CacheImpl getCache() {
        return this.cache;
    }

    public ClassLoader getClassloader() {
        return this.classloader;
    }

    public CriteriaBuilderImpl getCriteriaBuilder() {
        this.assertOpen();
        return this.criteriaBuilder;
    }

    protected DataSourceImpl getDatasource() {
        return this.datasource;
    }

    protected JdbcAdaptor getJdbcAdaptor() {
        return this.jdbcAdaptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JpqlQuery getJpqlQuery(String qlString) {
        try {
            LOG.debug("JPQL: {0}", qlString);
            JpqlQuery jpqlQuery = this.jpqlCache.get(qlString);
            if (jpqlQuery == null) {
                jpqlQuery = new JpqlQuery(this, qlString);
                if (this.jpqlCache.size() == 1000) {
                    EntityManagerFactoryImpl entityManagerFactoryImpl = this;
                    synchronized (entityManagerFactoryImpl) {
                        if (this.jpqlCache.size() == 1000) {
                            JpqlQuery[] queries = Lists.newArrayList(this.jpqlCache.values()).toArray(new JpqlQuery[this.jpqlCache.size()]);
                            Arrays.sort(queries, new Comparator<JpqlQuery>(){

                                @Override
                                public int compare(JpqlQuery o1, JpqlQuery o2) {
                                    if (o1.getLastUsed() > o2.getLastUsed()) {
                                        return 1;
                                    }
                                    return -1;
                                }
                            });
                            for (int i = 0; i < 100; ++i) {
                                this.jpqlCache.remove(queries[i].getQueryString());
                            }
                        }
                    }
                }
                this.jpqlCache.put(qlString, jpqlQuery);
            }
            return jpqlQuery;
        }
        catch (Exception e) {
            if (e.getCause() instanceof PersistenceException) {
                throw (PersistenceException)e.getCause();
            }
            if (e.getCause() instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e.getCause();
            }
            throw new PersistenceException("Cannot parse query: " + e.getMessage(), (Throwable)e);
        }
    }

    public MetamodelImpl getMetamodel() {
        return this.metamodel;
    }

    public JpqlQuery getNamedQuery(String name) {
        return this.namedQueries.get(name);
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.persistenceUtil;
    }

    public Class<?>[] getPersistValidators() {
        return this.persistValidators;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public Class<?>[] getRemoveValidators() {
        return this.removeValidators;
    }

    public Class<?>[] getUpdateValidators() {
        return this.updateValidators;
    }

    public ValidatorFactory getValidationFactory() {
        return this.validationFactory;
    }

    private Class<?>[] getValidatorsFor(PersistenceParser parser, String group) {
        String groups = (String)parser.getProperties().get(group);
        if (StringUtils.isBlank((String)groups)) {
            return new Class[]{Default.class};
        }
        HashSet validationGroups = Sets.newHashSet();
        for (String className : Splitter.on((String)",").trimResults().split((CharSequence)groups)) {
            try {
                validationGroups.add(this.classloader.loadClass(className));
            }
            catch (ClassNotFoundException e) {
                throw new PersistenceException("Cannot load class for validation group: " + className);
            }
        }
        return validationGroups.toArray(new Class[validationGroups.size()]);
    }

    public boolean hasValidators() {
        return this.validationFactory != null;
    }

    public boolean isOpen() {
        return this.open;
    }

    private void prepareProperties(PersistenceParser parser) {
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (!(key instanceof String)) continue;
            this.properties.put((String)key, System.getProperties().get(key));
        }
        this.properties.putAll(parser.getProperties());
    }

    private DDLMode readDdlMode() {
        String ddlMode = (String)this.getProperty("org.batoo.jpa.ddl");
        if (ddlMode == null) {
            return DDLMode.NONE;
        }
        return DDLMode.valueOf(ddlMode.toUpperCase());
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this;
    }
}

