/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.manager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.PluralAttribute;
import javax.sql.DataSource;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.batoo.jpa.common.log.BLogger;
import org.batoo.jpa.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.criteria.CriteriaBuilderImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaDeleteImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaUpdateImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.jpql.JpqlQuery;
import org.batoo.jpa.core.impl.instance.EnhancedInstance;
import org.batoo.jpa.core.impl.instance.ManagedId;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.instance.Status;
import org.batoo.jpa.core.impl.jdbc.ConnectionImpl;
import org.batoo.jpa.core.impl.jdbc.DataSourceImpl;
import org.batoo.jpa.core.impl.manager.EntityManagerFactoryImpl;
import org.batoo.jpa.core.impl.manager.EntityTransactionImpl;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.mapping.AssociationMapping;
import org.batoo.jpa.core.impl.model.mapping.PluralAssociationMapping;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.jdbc.adapter.JdbcAdaptor;

public class EntityManagerImpl
implements EntityManager {
    private static final BLogger LOG = BLoggerFactory.getLogger(EntityManagerImpl.class);
    private final EntityManagerFactoryImpl emf;
    private final MetamodelImpl metamodel;
    private final DataSourceImpl datasource;
    private final JdbcAdaptor jdbcAdaptor;
    private boolean open;
    private EntityTransactionImpl transaction;
    private ConnectionImpl connection;
    private final SessionImpl session;
    private final CriteriaBuilderImpl criteriaBuilder;
    private final Map<String, Object> properties;

    public EntityManagerImpl(EntityManagerFactoryImpl entityManagerFactory, MetamodelImpl metamodel, DataSourceImpl datasource, Map<String, Object> properties, JdbcAdaptor jdbcAdaptor) {
        this.emf = entityManagerFactory;
        this.metamodel = metamodel;
        this.datasource = datasource;
        this.jdbcAdaptor = jdbcAdaptor;
        this.session = new SessionImpl(this, metamodel);
        this.criteriaBuilder = this.emf.getCriteriaBuilder();
        this.properties = properties;
        this.open = true;
    }

    protected void assertOpen() {
        if (!this.open) {
            throw new IllegalStateException("EntityManager has been previously closed");
        }
    }

    public void assertTransaction() {
        this.assertOpen();
        if (this.transaction == null || !this.transaction.isActive()) {
            throw new TransactionRequiredException("No active transaction");
        }
    }

    public <T> void cascadeMerge(EntityTypeImpl<T> type, T entity, MutableBoolean requiresFlush, IdentityHashMap<Object, Object> processed) {
        for (AssociationMapping<?, ?, ?> association : type.getAssociations()) {
            if (association instanceof PluralAssociationMapping) {
                Collection children;
                PluralAssociationMapping mapping = (PluralAssociationMapping)association;
                if (mapping.getAttribute().getCollectionType() == PluralAttribute.CollectionType.MAP) {
                    Map map = (Map)mapping.get(entity);
                    children = map.values();
                } else {
                    children = (Collection)mapping.get(entity);
                }
                if (children == null) continue;
                for (Object child : children) {
                    this.mergeImpl(child, requiresFlush, processed, association.cascadesMerge());
                }
                continue;
            }
            this.mergeImpl(entity, requiresFlush, processed, association.cascadesMerge());
        }
    }

    public void clear() {
        this.assertOpen();
        if (this.transaction != null && this.transaction.isActive()) {
            this.transaction.rollback();
            LOG.warn("Session cleared with active and transaction. Updated persistent types will become stale...");
        }
        this.session.clear();
    }

    public void clearTransaction() {
        this.transaction = null;
    }

    public void close() {
        this.assertOpen();
        if (this.transaction != null && this.transaction.isActive()) {
            this.transaction.rollback();
            LOG.warn("Entity manager closed with an active transaction. Updated persistent types will become stale...");
        }
        this.closeConnection();
        this.open = false;
    }

    protected void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.connection = null;
    }

    public void closeConnectionIfNecessary() {
    }

    public boolean contains(Object entity) {
        this.assertOpen();
        return this.session.get(entity) != null;
    }

    public Query createNamedQuery(String name) {
        return this.createNamedQuery(name, Object.class);
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        JpqlQuery query = this.emf.getNamedQuery(name);
        if (query == null) {
            throw new IllegalArgumentException("No named query found with the name: " + name);
        }
        return query.createTypedQuery(this);
    }

    public Query createNativeQuery(String sqlString) {
        return null;
    }

    public Query createNativeQuery(String sqlString, Class<?> resultClass) {
        return null;
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        return null;
    }

    public Query createQuery(CriteriaDeleteImpl<?> deleteQuery) {
        return new QueryImpl(deleteQuery, this);
    }

    public <T> QueryImpl<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        return new QueryImpl((CriteriaQueryImpl)criteriaQuery, this);
    }

    public Query createQuery(CriteriaUpdateImpl<?> updateQuery) {
        return new QueryImpl(updateQuery, this);
    }

    public Query createQuery(String qlString) {
        return this.emf.getJpqlQuery(qlString).createTypedQuery(this);
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        return this.emf.getJpqlQuery(qlString).createTypedQuery(this);
    }

    public void detach(Object entity) {
        this.assertOpen();
        ManagedInstance<?> instance = this.session.remove(entity);
        if (instance != null) {
            instance.cascadeDetach(this);
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return this.find(entityClass, primaryKey, null, null);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        return this.find(entityClass, primaryKey, lockMode, null);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        if (primaryKey == null) {
            throw new NullPointerException();
        }
        EntityType type = this.metamodel.entity(entityClass);
        if (lockMode == null && type.getRootType().hasVersionAttribute()) {
            lockMode = LockModeType.OPTIMISTIC;
        }
        return this.findImpl(primaryKey, lockMode, properties, (EntityTypeImpl<T>)type);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return this.find(entityClass, primaryKey, null, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T findImpl(Object primaryKey, LockModeType lockMode, Map<String, Object> properties, EntityTypeImpl<T> type) {
        CacheRetrieveMode cacheRetrieveMode = null;
        if (properties != null && (cacheRetrieveMode = (CacheRetrieveMode)properties.get("javax.persistence.cache.retrieveMode")) != null) {
            this.emf.getCache().setCacheRetrieveMode(cacheRetrieveMode);
        }
        CacheStoreMode cacheStoreMode = null;
        if (properties != null && (cacheStoreMode = (CacheStoreMode)properties.get("javax.persistence.cache.storeMode")) != null) {
            this.emf.getCache().setCacheStoreMode(cacheStoreMode);
        }
        this.session.setLoadTracker();
        try {
            ManagedInstance<ManagedId<T>> instance = this.session.get(new ManagedId<T>(primaryKey, type));
            if (instance != null) {
                if (instance.getInstance() instanceof EnhancedInstance) {
                    EnhancedInstance enhanced = (EnhancedInstance)((Object)instance.getInstance());
                    if (enhanced.__enhanced__$$__isInitialized()) {
                        this.lock(instance, lockMode, properties);
                        ManagedId<T> managedId = instance.getInstance();
                        return (T)managedId;
                    }
                } else {
                    this.lock(instance, lockMode, properties);
                    ManagedId<T> managedId = instance.getInstance();
                    return (T)managedId;
                }
            }
            T t = type.performSelect(this, primaryKey, lockMode);
            return t;
        }
        finally {
            this.session.releaseLoadTracker();
            if (cacheRetrieveMode != null) {
                this.emf.getCache().setCacheRetrieveMode(null);
            }
            if (cacheStoreMode != null) {
                this.emf.getCache().setCacheStoreMode(null);
            }
        }
    }

    public void flush() {
        this.assertTransaction();
        try {
            this.session.handleExternals();
            this.session.handleAdditions();
            this.session.cascadeRemovals();
            this.session.handleOrphans();
            this.session.flush(this.getConnection());
        }
        catch (SQLException e) {
            LOG.error(e, "Flush failed");
            throw new PersistenceException("Flush failed", (Throwable)e);
        }
        catch (RuntimeException e) {
            LOG.error(e, "Flush failed");
            throw e;
        }
    }

    public ConnectionImpl getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        try {
            this.joinTransaction();
            this.connection = this.datasource.getConnection();
            return this.connection;
        }
        catch (SQLException e) {
            throw new PersistenceException("Unable to obtain connection from the datasource", (Throwable)e);
        }
    }

    public CriteriaBuilderImpl getCriteriaBuilder() {
        return this.criteriaBuilder;
    }

    public Object getDelegate() {
        this.assertOpen();
        return this;
    }

    public EntityManagerFactoryImpl getEntityManagerFactory() {
        return this.emf;
    }

    public FlushModeType getFlushMode() {
        return null;
    }

    public JdbcAdaptor getJdbcAdaptor() {
        return this.jdbcAdaptor;
    }

    public LockModeType getLockMode(Object entity) {
        ManagedInstance<Object> instance = this.session.get(entity);
        return instance.getLockMode();
    }

    public MetamodelImpl getMetamodel() {
        return this.metamodel;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        if (primaryKey == null) {
            throw new NullPointerException();
        }
        EntityType type = this.metamodel.entity(entityClass);
        ManagedId managedId = new ManagedId(primaryKey, type);
        ManagedInstance instance = this.session.get(managedId);
        if (instance != null) {
            return (T)instance.getInstance();
        }
        instance = type.getManagedInstanceById(this.session, managedId, true);
        this.session.put(instance);
        return (T)instance.getInstance();
    }

    public SessionImpl getSession() {
        return this.session;
    }

    public EntityTransactionImpl getTransaction() {
        if (this.transaction != null) {
            return this.transaction;
        }
        this.assertOpen();
        this.transaction = new EntityTransactionImpl(this, this.getConnection());
        return this.transaction;
    }

    public boolean hasTransactionMarkedForRollback() {
        if (this.transaction != null) {
            return this.transaction.getRollbackOnly();
        }
        return false;
    }

    public boolean isJoinedToTransaction() {
        return false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void isValid(EntityTransactionImpl transaction) {
        if (this.transaction != transaction) {
            throw new PersistenceException("Transaction is stale");
        }
    }

    public void joinTransaction() {
    }

    public void lock(ManagedInstance<?> instance, LockModeType lockMode, Map<String, Object> properties) {
        if (lockMode == LockModeType.OPTIMISTIC || lockMode == LockModeType.OPTIMISTIC_FORCE_INCREMENT) {
            EntityTypeImpl<?> type = instance.getType().getRootType();
            if (!type.hasVersionAttribute()) {
                throw new PersistenceException("OPTIMISTIC and OPTIMISTIC_FORCE_INCREMENT not supported on non-versioned entity " + instance.getType().getName());
            }
            instance.setOptimisticLock();
        }
        if (lockMode == LockModeType.OPTIMISTIC_FORCE_INCREMENT) {
            this.assertTransaction();
            try {
                instance.incrementVersion(this.getConnection(), true);
            }
            catch (SQLException e) {
                throw new PersistenceException("Unable to update version", (Throwable)e);
            }
        }
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.lock(entity, lockMode, null);
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.lock(this.session.get(entity), lockMode, properties);
    }

    public <T> T merge(T entity) {
        this.assertTransaction();
        MutableBoolean requiresFlush = new MutableBoolean(false);
        T mergedEntity = this.mergeImpl(entity, requiresFlush, Maps.newIdentityHashMap(), true);
        if (requiresFlush.booleanValue()) {
            this.flush();
        }
        return mergedEntity;
    }

    public <T> T mergeImpl(T entity, MutableBoolean requiresFlush, IdentityHashMap<Object, Object> processed, boolean cascade) {
        Object existingEntity;
        Object id;
        if (entity == null) {
            return null;
        }
        Object processedEntity = processed.get(entity);
        if (processedEntity != null) {
            return (T)processedEntity;
        }
        ManagedInstance<Object> instance = this.session.get(entity);
        Class<?> clazz = entity.getClass();
        if (entity instanceof EnhancedInstance) {
            clazz = clazz.getSuperclass();
        }
        EntityType type = this.metamodel.entity(clazz);
        if (instance != null) {
            if (instance.getStatus() == Status.REMOVED) {
                throw new IllegalArgumentException("Entity has been previously removed");
            }
            if (instance.getStatus() == Status.MANAGED || instance.getStatus() == Status.NEW) {
                processed.put(entity, instance.getInstance());
                if (instance.getInstance() != entity) {
                    instance.mergeWith(this, entity, requiresFlush, processed);
                } else {
                    this.cascadeMerge((EntityTypeImpl<T>)type, entity, requiresFlush, processed);
                }
                return (T)instance.getInstance();
            }
        }
        if ((id = type.getInstanceId(entity)) != null && (existingEntity = this.find(clazz, id)) != null) {
            instance = ((EnhancedInstance)existingEntity).__enhanced__$$__getManagedInstance();
            processed.put(entity, instance.getInstance());
            instance.mergeWith(this, entity, requiresFlush, processed);
            return (T)instance.getInstance();
        }
        ManagedId managedId = new ManagedId(id, type);
        instance = type.getManagedInstanceById(this.session, managedId, false);
        instance.setStatus(Status.NEW);
        instance.enhanceCollections();
        if (type.getRootType().hasVersionAttribute()) {
            instance.setOptimisticLock();
        }
        this.session.putExternal(instance);
        processed.put(entity, instance.getInstance());
        instance.mergeWith(this, entity, requiresFlush, processed);
        if (!instance.fillIdValues()) {
            requiresFlush.setValue(true);
        }
        return (T)instance.getInstance();
    }

    public void persist(Object entity) {
        this.assertTransaction();
        if (this.persistImpl(entity, Lists.newArrayList())) {
            this.flush();
        }
    }

    public <T> boolean persistImpl(T entity, ArrayList<Object> processed) {
        ManagedInstance<?> instance;
        if (processed.contains(entity)) {
            return false;
        }
        if (entity instanceof EnhancedInstance && (instance = ((EnhancedInstance)entity).__enhanced__$$__getManagedInstance()).getStatus() == Status.DETACHED) {
            throw new EntityExistsException("Entity has been previously detached");
        }
        ManagedInstance<T> existing = this.session.get(entity);
        if (existing != null) {
            processed.add(entity);
            switch (existing.getStatus()) {
                case REMOVED: {
                    existing.setStatus(Status.MANAGED);
                }
                case NEW: 
                case MANAGED: {
                    return existing.cascadePersist(this, processed);
                }
            }
        }
        EntityType type = this.metamodel.entity(entity.getClass());
        ManagedInstance<T> instance2 = type.getManagedInstance(this.session, entity);
        instance2.setStatus(Status.NEW);
        instance2.enhanceCollections();
        if (type.getRootType().hasVersionAttribute()) {
            instance2.setOptimisticLock();
        }
        boolean requiresFlush = !instance2.fillIdValues();
        this.session.putExternal(instance2);
        processed.add(entity);
        return requiresFlush |= instance2.cascadePersist(this, processed);
    }

    public void refresh(Object entity) {
        this.refresh(entity, LockModeType.NONE, null);
    }

    public void refresh(Object entity, LockModeType lockMode) {
        this.refresh(entity, lockMode, null);
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.assertOpen();
        ManagedInstance<?> instance = null;
        if (entity instanceof EnhancedInstance && (instance = ((EnhancedInstance)entity).__enhanced__$$__getManagedInstance()).getSession() == this.session && instance.getStatus() == Status.MANAGED) {
            instance.refresh(this, this.getConnection(), lockMode);
            this.closeConnectionIfNecessary();
            this.lock(instance, lockMode, properties);
            return;
        }
        throw new IllegalArgumentException("entity is not managed");
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.refresh(entity, LockModeType.NONE, properties);
    }

    public void remove(Object entity) {
        EnhancedInstance enhancedInstance;
        ManagedInstance<?> instance;
        if (entity instanceof EnhancedInstance && (instance = (enhancedInstance = (EnhancedInstance)entity).__enhanced__$$__getManagedInstance()).getStatus() == Status.DETACHED) {
            throw new IllegalArgumentException("Entity has been previously detached");
        }
        ManagedInstance<Object> instance2 = this.session.get(entity);
        if (instance2 != null) {
            if (instance2.getStatus() == Status.MANAGED) {
                instance2.setStatus(Status.REMOVED);
                this.session.setChanged(instance2);
                instance2.cascadeRemove(this);
            } else if (instance2.getStatus() == Status.NEW) {
                this.session.remove(instance2.getInstance());
                instance2.setStatus(Status.DETACHED);
                instance2.cascadeRemove(this);
            }
        }
    }

    public void setFlushMode(FlushModeType flushMode) {
    }

    public void setProperty(String propertyName, Object value) {
        this.properties.put(propertyName, value);
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz == DataSource.class) {
            return (T)this.datasource;
        }
        if (clazz == Connection.class) {
            return (T)this.connection;
        }
        return null;
    }
}

