/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.jdbc.adapter;

import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.batoo.jpa.core.impl.jdbc.ForeignKey;
import org.batoo.jpa.core.impl.jdbc.JoinColumn;

public class JdbcForeignKey {
    private static final String FK_NAME = "FK_NAME";
    private static final String PKTABLE_NAME = "PKTABLE_NAME";
    private static final String FKCOLUMN_NAME = "FKCOLUMN_NAME";
    private static final String PKCOLUMN_NAME = "PKCOLUMN_NAME";
    private final String name;
    private final String refTable;
    private final Map<String, String> columns = Maps.newHashMap();

    public JdbcForeignKey(ResultSet metadata) throws SQLException {
        this.name = metadata.getString(FK_NAME);
        this.refTable = metadata.getString(PKTABLE_NAME);
    }

    public void addColumn(ResultSet metadata) throws SQLException {
        String columnName = metadata.getString(FKCOLUMN_NAME);
        String referencedColumnName = metadata.getString(PKCOLUMN_NAME);
        this.columns.put(columnName.toUpperCase(), referencedColumnName);
    }

    public String getName() {
        return this.name;
    }

    public String getRefTable() {
        return this.refTable;
    }

    public boolean matches(ForeignKey foreignKey) {
        if (!this.refTable.equalsIgnoreCase(foreignKey.getReferencedTableName())) {
            return false;
        }
        if (this.columns.size() != foreignKey.getJoinColumns().size()) {
            return false;
        }
        for (JoinColumn joinColumn : foreignKey.getJoinColumns()) {
            String referencedColumnName = this.columns.get(joinColumn.getName().toUpperCase());
            if (referencedColumnName != null && referencedColumnName.equalsIgnoreCase(joinColumn.getReferencedColumnName())) continue;
            return false;
        }
        return true;
    }
}

