/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.pool;

import com.google.common.annotations.Beta;
import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

@Beta
public class GenericPool<T>
implements ObjectPool<T> {
    private static final int MIN_SIZE = 5;
    private static final int MAX_SIZE = 15;
    private final PoolableObjectFactory<T> factory;
    private final Deque<T> pool;
    private boolean active;

    public GenericPool(PoolableObjectFactory<T> factory) {
        this.factory = factory;
        this.pool = new LinkedBlockingDeque<T>();
        this.active = true;
    }

    public void addObject() throws Exception, IllegalStateException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public T borrowObject() throws Exception, NoSuchElementException, IllegalStateException {
        while (this.pool.size() < 5) {
            this.pool.addLast(this.factory.makeObject());
        }
        return this.pool.pollFirst();
    }

    public void clear() throws Exception, UnsupportedOperationException {
        while (this.pool.size() > 0) {
            T item = this.pool.pollFirst();
            if (item == null) continue;
            this.factory.destroyObject(item);
        }
    }

    public void close() throws Exception {
        this.active = false;
        this.clear();
    }

    public int getNumActive() throws UnsupportedOperationException {
        return 0;
    }

    public int getNumIdle() throws UnsupportedOperationException {
        return this.pool.size();
    }

    public void invalidateObject(T obj) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void returnObject(T obj) throws Exception {
        if (this.active) {
            this.pool.addLast(obj);
            this.shrinkTo(15);
        } else {
            this.factory.destroyObject(obj);
        }
    }

    public void setFactory(PoolableObjectFactory<T> factory) throws IllegalStateException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private void shrinkTo(int maxSize) throws Exception {
        while (this.pool.size() > maxSize) {
            T obj = this.pool.getFirst();
            this.factory.destroyObject(obj);
        }
    }
}

