/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.persistence.SharedCacheMode;
import org.batoo.jpa.parser.PersistenceParser;
import org.batoo.jpa.parser.impl.metadata.MetadataImpl;
import org.batoo.jpa.parser.persistence.Persistence;
import org.batoo.jpa.parser.persistence.PersistenceUnitCachingType;

public class AndroidPersistenceParserImpl
implements PersistenceParser {
    private final ClassLoader classloader;
    private final MetadataImpl metadata;
    private final Persistence.PersistenceUnit persistenceUnit;
    private final Map<String, Object> properties = Maps.newHashMap();

    public AndroidPersistenceParserImpl(Map<String, String> properties, String[] classes) {
        this.classloader = Thread.currentThread().getContextClassLoader();
        this.persistenceUnit = new Persistence.PersistenceUnit();
        for (String clazz : classes) {
            this.persistenceUnit.getClazzs().add(clazz);
        }
        this.properties.putAll(properties);
        this.metadata = new MetadataImpl(this.persistenceUnit.getClazzs());
        this.metadata.parse(this.classloader);
    }

    @Override
    public ClassLoader getClassloader() {
        return this.classloader;
    }

    @Override
    public String getJtaDatasource() {
        return this.persistenceUnit.getJtaDataSource();
    }

    @Override
    public MetadataImpl getMetadata() {
        return this.metadata;
    }

    @Override
    public String getNonJtaDatasource() {
        return this.persistenceUnit.getNonJtaDataSource();
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public SharedCacheMode getSharedCacheMode() {
        PersistenceUnitCachingType cacheMode = this.persistenceUnit.getSharedCacheMode();
        return cacheMode == null ? SharedCacheMode.NONE : SharedCacheMode.valueOf((String)cacheMode.name());
    }

    @Override
    public boolean hasValidators() {
        return false;
    }
}

