/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.orm;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import org.batoo.jpa.parser.impl.orm.ChildElement;
import org.batoo.jpa.parser.impl.orm.Element;
import org.batoo.jpa.parser.impl.orm.ParentElement;

public class CascadesElement
extends ParentElement {
    private final Set<CascadeType> cascades = Sets.newHashSet();

    public CascadesElement(ParentElement parent, Map<String, String> attributes) {
        super(parent, attributes, "temporal", "column");
    }

    public Set<CascadeType> getCascades() {
        return this.cascades;
    }

    @Override
    protected void handleChild(Element child) {
        this.getCascades().add(((CascadeElement)child).getCascadeType());
    }

    public static class CascadeRemoveElement
    extends CascadeElement {
        public CascadeRemoveElement(ParentElement parent, Map<String, String> attributes) {
            super(parent, attributes);
        }

        @Override
        public CascadeType getCascadeType() {
            return CascadeType.REMOVE;
        }
    }

    public static class CascadeRefreshElement
    extends CascadeElement {
        public CascadeRefreshElement(ParentElement parent, Map<String, String> attributes) {
            super(parent, attributes);
        }

        @Override
        public CascadeType getCascadeType() {
            return CascadeType.REFRESH;
        }
    }

    public static class CascadePersistElement
    extends CascadeElement {
        public CascadePersistElement(ParentElement parent, Map<String, String> attributes) {
            super(parent, attributes);
        }

        @Override
        public CascadeType getCascadeType() {
            return CascadeType.PERSIST;
        }
    }

    public static class CascadeMergeElement
    extends CascadeElement {
        public CascadeMergeElement(ParentElement parent, Map<String, String> attributes) {
            super(parent, attributes);
        }

        @Override
        public CascadeType getCascadeType() {
            return CascadeType.MERGE;
        }
    }

    private static abstract class CascadeElement
    extends ChildElement {
        public CascadeElement(ParentElement parent, Map<String, String> attributes) {
            super(parent, attributes);
        }

        public abstract CascadeType getCascadeType();
    }

    public static class CascadeDetachElement
    extends CascadeElement {
        public CascadeDetachElement(ParentElement parent, Map<String, String> attributes) {
            super(parent, attributes);
        }

        @Override
        public CascadeType getCascadeType() {
            return CascadeType.DETACH;
        }
    }

    public static class CascadeAllElement
    extends CascadeElement {
        public CascadeAllElement(ParentElement parent, Map<String, String> attributes) {
            super(parent, attributes);
        }

        @Override
        public CascadeType getCascadeType() {
            return CascadeType.ALL;
        }
    }
}

