/*
 * Copyright (c) 2012 - Batoo Software ve Consultancy Ltd.
 * 
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 */
package org.batoo.jpa.parser.impl.orm;

import java.util.Map;

import org.batoo.jpa.parser.metadata.BaseColumnMetadata;

/**
 * 
 * @author hceylan
 * @since 2.0.0
 */
public abstract class BaseColumnElement extends ChildElement implements BaseColumnMetadata {

	private String name;
	private String columnDefinition;
	private boolean insertable;
	private boolean nullable;
	private String table;
	private boolean unique;
	private boolean updatable;

	/**
	 * @param parent
	 *            the metamodel
	 * @param attributes
	 *            the attributes
	 * 
	 * @since 2.0.0
	 */
	public BaseColumnElement(ParentElement parent, Map<String, String> attributes) {
		super(parent, attributes);
	}

	/**
	 * {@inheritDoc}
	 * 
	 */
	@Override
	protected void generate() {
		this.name = this.getAttribute(ATTR_NAME, EMPTY);
		this.columnDefinition = this.getAttribute(ATTR_COLUMN_DEFINITION, EMPTY);
		this.insertable = this.getAttribute(ATTR_INSERTABLE, false);
		this.nullable = this.getAttribute(ATTR_NULLABLE, false);
		this.table = this.getAttribute(ATTR_TABLE, EMPTY);
		this.unique = this.getAttribute(ATTR_UNIQUE, false);
		this.updatable = this.getAttribute(ATTR_UPDATABLE, true);
	}

	/**
	 * Returns the columnDefinition of the ColumnElement.
	 * 
	 * @return the columnDefinition of the ColumnElement
	 * 
	 * @since 2.0.0
	 */
	@Override
	public String getColumnDefinition() {
		return this.columnDefinition;
	}

	/**
	 * {@inheritDoc}
	 * 
	 */
	@Override
	public String getName() {
		return this.name;
	}

	/**
	 * {@inheritDoc}
	 * 
	 */
	@Override
	public String getTable() {
		return this.table;
	}

	/**
	 * {@inheritDoc}
	 * 
	 */
	@Override
	public boolean isInsertable() {
		return this.insertable;
	}

	/**
	 * {@inheritDoc}
	 * 
	 */
	@Override
	public boolean isNullable() {
		return this.nullable;
	}

	/**
	 * {@inheritDoc}
	 * 
	 */
	@Override
	public boolean isUnique() {
		return this.unique;
	}

	/**
	 * {@inheritDoc}
	 * 
	 */
	@Override
	public boolean isUpdatable() {
		return this.updatable;
	}

}
