/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.CacheStoreMode;
import javax.persistence.NoResultException;
import javax.persistence.metamodel.Attribute;
import org.batoo.jpa.core.impl.cache.CacheImpl;
import org.batoo.jpa.core.impl.cache.CacheReference;
import org.batoo.jpa.core.impl.collections.ManagedCollection;
import org.batoo.jpa.core.impl.instance.EnhancedInstance;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.mapping.AssociationMapping;
import org.batoo.jpa.core.impl.model.mapping.BasicMapping;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.core.impl.model.mapping.PluralAssociationMapping;
import org.batoo.jpa.core.impl.model.mapping.PluralMapping;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;

public class CacheInstance
implements Serializable {
    private final Map<String, Object> basicMappings = Maps.newHashMap();
    private final Map<String, List<CacheReference>> pluralMappings = Maps.newHashMap();
    private final Map<String, CacheReference> singularMappings = Maps.newHashMap();
    private final String entityName;
    private final Object id;

    public CacheInstance(CacheImpl cache, ManagedInstance<?> managedInstance) {
        this.entityName = managedInstance.getType().getName();
        this.id = managedInstance.getId().getId();
        EntityTypeImpl<?> type = managedInstance.getType();
        Object instance = managedInstance.getInstance();
        MetamodelImpl metamodel = managedInstance.getSession().getEntityManager().getMetamodel();
        for (BasicMapping<?, ?> basicMapping : type.getBasicMappings()) {
            this.basicMappings.put(basicMapping.getPath(), basicMapping.get(instance));
        }
        for (Mapping mapping : type.getAssociations()) {
            if (mapping instanceof PluralAssociationMapping) {
                this.updateCollection(metamodel, cache, (PluralMapping)((Object)mapping), instance);
                continue;
            }
            Object value = mapping.get(instance);
            if (value == null) {
                this.singularMappings.put(mapping.getPath(), null);
                continue;
            }
            if (value instanceof EnhancedInstance) {
                EnhancedInstance enhancedInstance = (EnhancedInstance)value;
                if (!enhancedInstance.__enhanced__$$__isInitialized()) continue;
                this.singularMappings.put(mapping.getPath(), new CacheReference(metamodel, value));
                continue;
            }
            this.singularMappings.put(mapping.getPath(), new CacheReference(metamodel, value));
        }
        managedInstance.setCache(this);
    }

    public void copyTo(CacheImpl cache, ManagedInstance<?> managedInstance) {
        EntityTypeImpl<?> type = managedInstance.getType();
        Object instance = managedInstance.getInstance();
        EntityManagerImpl em = managedInstance.getSession().getEntityManager();
        MetamodelImpl metamodel = em.getMetamodel();
        for (BasicMapping<?, ?> basicMapping : type.getBasicMappings()) {
            basicMapping.set(instance, this.basicMappings.get(basicMapping.getPath()));
        }
        for (Mapping mapping : type.getAssociationsSingular()) {
            CacheReference reference = this.singularMappings.get(mapping.getPath());
            if (reference == null) continue;
            EntityTypeImpl entity = metamodel.entity(reference.getType());
            mapping.set(managedInstance.getInstance(), em.find(entity.getJavaType(), reference.getId()));
        }
        managedInstance.setCache(this);
    }

    public Collection<?> getCollection(ManagedInstance<?> managedInstance, PluralAssociationMapping<?, ?, ?> mapping) {
        List<CacheReference> children = this.pluralMappings.get(mapping.getPath());
        if (children == null) {
            return null;
        }
        EntityManagerImpl entityManager = managedInstance.getSession().getEntityManager();
        MetamodelImpl metamodel = entityManager.getMetamodel();
        CacheImpl cache = entityManager.getEntityManagerFactory().getCache();
        Object instance = managedInstance.getInstance();
        AssociationMapping<?, ?, ?> inverse = null;
        if (mapping.getInverse() != null && mapping.getInverse().getAttribute().getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_ONE) {
            inverse = mapping.getInverse();
        }
        try {
            ArrayList childEntities = Lists.newArrayList();
            for (int i = 0; i < children.size(); ++i) {
                CacheReference childReference = children.get(i);
                EntityTypeImpl childType = metamodel.entity(childReference.getType());
                Object child = entityManager.find(childType.getJavaType(), childReference.getId());
                if (inverse != null && inverse.get(child) != instance) {
                    return this.handleStale(cache, mapping, managedInstance);
                }
                childEntities.add(child);
            }
            return childEntities;
        }
        catch (NoResultException e) {
            return this.handleStale(cache, mapping, managedInstance);
        }
    }

    public String getEntityName() {
        return this.entityName;
    }

    private Collection<?> handleStale(CacheImpl cache, PluralMapping<?, ?, ?> mapping, ManagedInstance<?> managedInstance) {
        this.pluralMappings.remove(mapping.getPath());
        cache.put(managedInstance);
        return null;
    }

    public String toString() {
        return "CacheInstance [clazz=" + this.entityName + ", id=" + this.id + ", basicMappings=" + this.basicMappings + ", pluralMappings=" + this.pluralMappings + "]";
    }

    public boolean updateCollection(MetamodelImpl metamodel, CacheImpl cache, PluralMapping<?, ?, ?> mapping, Object instance) {
        EntityTypeImpl childType;
        if (mapping.getType() instanceof EntityTypeImpl && cache.getCacheStoreMode((childType = (EntityTypeImpl)mapping.getType()).getRootType()) == CacheStoreMode.BYPASS) {
            return false;
        }
        ArrayList references = Lists.newArrayList();
        ManagedCollection collection = (ManagedCollection)mapping.get(instance);
        if (collection == null) {
            this.pluralMappings.put(mapping.getPath(), references);
            return true;
        }
        if (!collection.isInitialized()) {
            return true;
        }
        if (collection.getDelegate() instanceof List) {
            List delegateList = (List)collection.getDelegate();
            for (int i = 0; i < delegateList.size(); ++i) {
                references.add(new CacheReference(metamodel, delegateList.get(i)));
            }
        } else {
            for (Object child : collection.getDelegate()) {
                references.add(new CacheReference(metamodel, child));
            }
        }
        this.pluralMappings.put(mapping.getPath(), references);
        return true;
    }
}

