/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.cache;

import java.io.Serializable;
import java.text.MessageFormat;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;

public class CacheStats
implements Serializable {
    private static final BLogger LOG = BLoggerFactory.getLogger(CacheStats.class);
    private final String name;
    private int evicts;
    private int puts;
    private int hits;
    private int misses;
    private int qhits;
    private int qmisses;

    CacheStats(String name) {
        this.name = name;
    }

    void evict(Object primaryKey) {
        ++this.evicts;
        LOG.debug("EVICT {0}:{1} | puts:{2} evicts:{3} hits:{4}, misses:{5}", this.name, primaryKey, this.puts, this.evicts, this.hits, this.misses);
    }

    public int evicts() {
        return this.evicts;
    }

    void hit(Object primaryKey) {
        ++this.hits;
        LOG.debug("HIT {0}:{1} | puts:{2} evicts:{3} hits:{4}, misses:{5}", this.name, primaryKey, this.puts, this.evicts, this.hits, this.misses);
    }

    public int hits() {
        return this.hits;
    }

    void miss(Object primaryKey) {
        ++this.misses;
        LOG.debug("MISS {0}:{1} | puts:{2} evicts:{3} hits:{4}, misses:{5}", this.name, primaryKey, this.puts, this.evicts, this.hits, this.misses);
    }

    public int misses() {
        return this.misses;
    }

    void put(Object primaryKey) {
        ++this.puts;
        LOG.debug("PUT {0}:{1} | puts:{2} evicts:{3} hits:{4}, misses:{5}", this.name, primaryKey, this.puts, this.evicts, this.hits, this.misses);
    }

    public int puts() {
        return this.puts;
    }

    void qhit(String sql) {
        ++this.qhits;
        LOG.debug("QHIT {0}:{1} \nputs:{2} evicts:{3} hits:{4}, misses:{5}", this.name, sql, this.puts, this.evicts, this.hits, this.misses);
    }

    public int qhits() {
        return this.qhits;
    }

    void qmiss(String sql) {
        ++this.qmisses;
        LOG.debug("QMISS {0}:{1} \n puts:{2} evicts:{3} hits:{4}, misses:{5}", this.name, sql, this.puts, this.evicts, this.hits, this.misses);
    }

    public int qmisses() {
        return this.qmisses;
    }

    public String toString() {
        return MessageFormat.format("{0} | puts:{1} evicts:{2} hits:{3}, misses:{4}", this.name, this.puts, this.evicts, this.hits, this.misses);
    }
}

