/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.persistence.PersistenceException;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import org.apache.commons.lang.StringUtils;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.common.util.BatooUtils;
import org.batoo.jpa.core.impl.criteria.AbstractSelection;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.RootImpl;
import org.batoo.jpa.core.impl.criteria.SubqueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.expression.ParameterExpressionImpl;
import org.batoo.jpa.core.impl.criteria.expression.PredicateImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;

public abstract class AbstractCriteriaQueryImpl<T>
extends BaseQueryImpl<T>
implements AbstractQuery<T> {
    private static final BLogger LOG = BLoggerFactory.getLogger(AbstractCriteriaQueryImpl.class);
    private Class<T> resultType;
    private boolean internal;
    private final Set<RootImpl<?>> roots = Sets.newHashSet();
    private AbstractSelection<T> selection;
    private PredicateImpl restriction;
    private PredicateImpl groupRestriction;
    private boolean distinct;
    private final List<AbstractExpression<?>> groupList = Lists.newArrayList();
    private final List<ParameterExpressionImpl<?>> parameterOrder = Lists.newArrayList();

    public AbstractCriteriaQueryImpl(MetamodelImpl metamodel, Class<T> resultType) {
        super(metamodel);
        this.resultType = resultType;
    }

    public AbstractQuery<T> distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    protected AbstractSelection<T> ensureSelection() {
        if (this.selection == null) {
            if (this.getRoots().size() == 1) {
                this.selection = (AbstractSelection)this.getRoots().iterator().next();
                return this.selection;
            }
            throw new PersistenceException("Selection is not specified");
        }
        return this.selection;
    }

    public <X> RootImpl<X> from(Class<X> entityClass) {
        EntityType entity = this.getMetamodel().entity((Class)entityClass);
        return this.from(entity);
    }

    public <X> RootImpl<X> from(EntityType<X> entity) {
        RootImpl r = new RootImpl((EntityTypeImpl)entity);
        this.roots.add(r);
        return r;
    }

    @Override
    public String generateJpql() {
        StringBuilder builder = new StringBuilder();
        this.ensureSelection();
        builder.append("select ");
        if (this.distinct) {
            builder.append("distinct ");
        }
        builder.append(this.selection.generateJpqlSelect(this, true));
        Collection roots = Collections2.transform(this.getRoots(), (Function)new Function<Root<?>, String>(){

            public String apply(Root<?> input) {
                String joins;
                RootImpl root = (RootImpl)input;
                StringBuilder builder = new StringBuilder(input.getModel().getName());
                if (StringUtils.isNotBlank((String)input.getAlias())) {
                    builder.append(" as ").append(input.getAlias());
                }
                if (StringUtils.isNotBlank((String)(joins = root.generateJpqlJoins(AbstractCriteriaQueryImpl.this)))) {
                    builder.append("\n").append(BatooUtils.indent(joins));
                }
                return builder.toString();
            }
        });
        builder.append("\nfrom ").append(Joiner.on((String)", ").join((Iterable)roots));
        if (this.getRestriction() != null) {
            builder.append("\nwhere\n\t").append(this.getRestriction().generateJpqlRestriction(this));
        }
        if (this.getGroupList().size() > 0) {
            String groupBy = Joiner.on((String)", ").join((Iterable)Lists.transform(this.getGroupList(), (Function)new Function<Expression<?>, String>(){

                public String apply(Expression<?> input) {
                    return ((AbstractExpression)input).generateJpqlRestriction(AbstractCriteriaQueryImpl.this);
                }
            }));
            builder.append("\ngroup by\n\t").append(groupBy);
        }
        if (this.getGroupRestriction() != null) {
            builder.append("\nhaving\n\t").append(this.getGroupRestriction().generateJpqlRestriction(this));
        }
        return builder.toString();
    }

    @Override
    public String generateSql() {
        this.ensureSelection();
        LOG.debug("Preparing SQL for {0}", LOG.lazyBoxed(this));
        LinkedHashMap joins = Maps.newLinkedHashMap();
        StringBuilder select = new StringBuilder();
        select.append("SELECT");
        if (this.distinct && !this.internal) {
            select.append(" DISTINCT");
        }
        select.append("\n");
        select.append(BatooUtils.indent(this.selection.generateSqlSelect(this, true)));
        ArrayList froms = Lists.newArrayList();
        for (Root<?> r : this.getRoots()) {
            RootImpl root = (RootImpl)r;
            froms.add(root.generateSqlFrom(this));
        }
        String where = this.generateSqlRestriction();
        String groupBy = this.getGroupList().size() == 0 ? null : Joiner.on((String)", ").join((Iterable)Lists.transform(this.getGroupList(), (Function)new Function<Expression<?>, String>(){

            public String apply(Expression<?> input) {
                return ((AbstractExpression)input).generateSqlSelect(AbstractCriteriaQueryImpl.this, false);
            }
        }));
        String having = this.getGroupRestriction() != null ? this.getGroupRestriction().generateSqlRestriction(this) : null;
        for (Root<?> root : this.getRoots()) {
            ((RootImpl)root).generateSqlJoins(this, joins);
        }
        String from = "FROM " + Joiner.on((String)", ").join((Iterable)froms);
        String join = Joiner.on((String)"\n").skipNulls().join(joins.values());
        return Joiner.on((String)"\n").skipNulls().join((Object)select, (Object)from, new Object[]{StringUtils.isBlank((String)join) ? null : BatooUtils.indent(join), StringUtils.isBlank((String)where) ? null : "WHERE\n\t" + where, StringUtils.isBlank((String)groupBy) ? null : "GROUP BY\n\t" + groupBy, StringUtils.isBlank((String)having) ? null : "HAVING\n\t" + having});
    }

    private String generateSqlRestriction() {
        Object[] restrictions = new String[this.getRoots().size() + 1];
        if (this.getRestriction() != null) {
            restrictions[0] = this.restriction.generateSqlRestriction(this);
        }
        int i = 0;
        for (Root<?> root : this.getRoots()) {
            restrictions[++i] = ((RootImpl)root).generateDiscrimination(false);
        }
        String restriction = Joiner.on((String)") AND (").skipNulls().join(restrictions);
        if (StringUtils.isBlank((String)restriction)) {
            return null;
        }
        return "(" + restriction + ")";
    }

    public List<Expression<?>> getGroupList() {
        ArrayList groupList = Lists.newArrayList();
        groupList.addAll(this.groupList);
        return groupList;
    }

    public PredicateImpl getGroupRestriction() {
        return this.groupRestriction;
    }

    public PredicateImpl getRestriction() {
        return this.restriction;
    }

    public Class<T> getResultType() {
        return this.resultType;
    }

    public Set<Root<?>> getRoots() {
        return Sets.newHashSet(this.roots);
    }

    public AbstractSelection<T> getSelection() {
        return this.ensureSelection();
    }

    public AbstractQuery<T> groupBy(Expression<?> ... grouping) {
        this.groupList.clear();
        for (Expression<?> expression : grouping) {
            this.groupList.add((AbstractExpression)expression);
        }
        return this;
    }

    public AbstractQuery<T> groupBy(List<Expression<?>> grouping) {
        this.groupList.clear();
        for (int i = 0; i < grouping.size(); ++i) {
            this.groupList.add((AbstractExpression)grouping.get(i));
        }
        return this;
    }

    public AbstractQuery<T> having(Expression<Boolean> restriction) {
        this.groupRestriction = restriction instanceof PredicateImpl ? (PredicateImpl)restriction : new PredicateImpl((AbstractExpression<Boolean>)((AbstractExpression)restriction));
        return this;
    }

    public AbstractQuery<T> having(Predicate ... restrictions) {
        this.groupRestriction = new PredicateImpl(false, Predicate.BooleanOperator.AND, restrictions);
        return this;
    }

    public AbstractCriteriaQueryImpl<T> internal() {
        this.internal = true;
        this.distinct(true);
        return this;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public boolean isInternal() {
        return this.internal;
    }

    public void registerParameter(ParameterExpressionImpl<?> parameter) {
        this.parameterOrder.add(parameter);
    }

    protected AbstractCriteriaQueryImpl<T> select(Selection<? extends T> selection) {
        this.selection = (AbstractSelection)selection;
        return this;
    }

    @Override
    public <U> SubqueryImpl<U> subquery(Class<U> type) {
        return new SubqueryImpl<U>(this.getMetamodel(), this, type);
    }

    public void updateResultClass(List<Selection<?>> selections) {
        if (selections.size() == 1) {
            Selection<?> selection = selections.get(0);
            this.resultType = selection.getJavaType();
        } else {
            this.resultType = Object[].class;
        }
    }

    public AbstractQuery<T> where(Expression<Boolean> restriction) {
        if (restriction instanceof PredicateImpl) {
            PredicateImpl predicate = (PredicateImpl)restriction;
            if (predicate.getExpressions().size() > 0) {
                this.restriction = predicate;
            }
        } else {
            this.restriction = new PredicateImpl((AbstractExpression<Boolean>)((AbstractExpression)restriction));
        }
        return this;
    }

    public AbstractQuery<T> where(Predicate ... restrictions) {
        this.restriction = new PredicateImpl(false, Predicate.BooleanOperator.AND, restrictions);
        return this;
    }
}

