/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.PersistenceException;
import javax.persistence.Tuple;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.Selection;
import org.batoo.common.reflect.ConstructorAccessor;
import org.batoo.common.reflect.ReflectHelper;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.AbstractSelection;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.TupleImpl;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.impl.AbstractLocator;

public class CompoundSelectionImpl<X>
extends AbstractSelection<X>
implements CompoundSelection<X> {
    private final List<AbstractSelection<?>> selections = Lists.newArrayList();
    private ConstructorAccessor constructor;
    private List<String> aliases;

    public CompoundSelectionImpl(Class<X> javaType, List<Selection<?>> selections) {
        super(javaType);
        for (Selection<?> selection : selections) {
            this.selections.add((AbstractSelection)selection);
        }
        if (javaType != Object[].class && javaType != Tuple.class) {
            try {
                Class[] parameters = new Class[this.selections.size()];
                for (int i = 0; i < this.selections.size(); ++i) {
                    parameters[i] = this.selections.get(i).getJavaType();
                }
                this.constructor = ReflectHelper.createConstructor(javaType.getConstructor(parameters));
            }
            catch (Exception e) {
                throw new MappingException("Embeddable type does not have a default constructor", new AbstractLocator[0]);
            }
        }
    }

    public CompoundSelectionImpl(Class<X> javaType, Selection<?> ... selections) {
        this(javaType, Lists.newArrayList((Object[])selections));
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, final boolean selected) {
        return Joiner.on((String)", ").join((Iterable)Lists.transform(this.selections, (Function)new Function<AbstractSelection<?>, String>(){

            public String apply(AbstractSelection<?> input) {
                return input.generateJpqlSelect(null, selected);
            }
        }));
    }

    @Override
    public String generateSqlSelect(final AbstractCriteriaQueryImpl<?> query, final boolean selected) {
        return Joiner.on((String)",\n").join((Iterable)Lists.transform(this.selections, (Function)new Function<AbstractSelection<?>, String>(){

            public String apply(AbstractSelection<?> input) {
                return input.generateSqlSelect(query, selected);
            }
        }));
    }

    private List<String> getAliases() {
        if (this.aliases != null) {
            return this.aliases;
        }
        this.aliases = Lists.newArrayList();
        for (AbstractSelection<?> selection : this.selections) {
            this.aliases.add(selection.getAlias());
        }
        return this.aliases;
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        throw new UnsupportedOperationException();
    }

    @Override
    public X handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        Object[] values = new Object[this.selections.size()];
        for (int i = 0; i < this.selections.size(); ++i) {
            values[i] = this.selections.get(i).handle(query, session, row);
        }
        if (this.getJavaType() == Tuple.class) {
            return (X)new TupleImpl(this.getAliases(), this.selections, values);
        }
        try {
            return (X)(this.constructor != null ? this.constructor.newInstance(values) : values);
        }
        catch (Exception e) {
            throw new PersistenceException("Cannot construct result object", (Throwable)e);
        }
    }

    @Override
    public boolean isEntityList() {
        for (AbstractSelection<?> selection : this.selections) {
            if (selection.isEntityList()) continue;
            return false;
        }
        return true;
    }
}

