/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.CriteriaModify;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.path.AbstractPath;
import org.batoo.jpa.core.impl.model.MetamodelImpl;

public class CriteriaUpdateImpl<T>
extends CriteriaModify<T> {
    private final Map<AbstractPath<?>, AbstractExpression<?>> updates = Maps.newHashMap();

    public CriteriaUpdateImpl(MetamodelImpl metamodel) {
        super(metamodel);
    }

    @Override
    public String generateJpql() {
        StringBuilder builder = new StringBuilder();
        builder.append("update " + this.getRoot().getEntity().getName());
        if (this.getRestriction() != null) {
            builder.append("\nwhere\n\t").append(this.getRestriction().generateJpqlRestriction(this));
        }
        return builder.toString();
    }

    @Override
    public String generateSql() {
        String update = Joiner.on((String)",").join((Iterable)Collections2.transform(this.updates.entrySet(), (Function)new Function<Map.Entry<AbstractPath<?>, AbstractExpression<?>>, String>(){

            public String apply(Map.Entry<AbstractPath<?>, AbstractExpression<?>> input) {
                return "\t" + input.getKey().getSqlRestrictionFragments(CriteriaUpdateImpl.this)[0] + " = " + input.getValue().getSqlRestrictionFragments(CriteriaUpdateImpl.this)[0];
            }
        }));
        String sqlRestriction = this.generateSqlRestriction();
        return "UPDATE " + this.getRoot().generateSqlFrom(this) + " SET\n" + update + (StringUtils.isNotBlank((String)sqlRestriction) ? "\nWHERE " + sqlRestriction : "");
    }

    private String generateSqlRestriction() {
        if (this.getRestriction() == null && this.getRoot().getEntity().getRootType().getInheritanceType() == null) {
            return null;
        }
        String sqlRestriction = this.getRestriction().generateSqlRestriction(this);
        if (this.getRoot().getEntity().getRootType().getInheritanceType() == null) {
            return sqlRestriction;
        }
        return "(" + sqlRestriction + ") AND (" + this.getRoot().generateDiscrimination(true) + ")";
    }

    @Override
    public boolean isQuery() {
        return false;
    }

    public <Y> CriteriaUpdateImpl<T> set(Path<Y> attribute, Expression<? extends Y> value) {
        this.updates.put((AbstractPath)attribute, (AbstractExpression)value);
        return this;
    }

    @Override
    public CriteriaUpdateImpl<T> where(Expression<Boolean> restriction) {
        return (CriteriaUpdateImpl)super.where(restriction);
    }

    @Override
    public CriteriaUpdateImpl<T> where(Predicate ... restrictions) {
        return (CriteriaUpdateImpl)super.where(restrictions);
    }
}

