/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.expression.DateTimeFunctionType;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class DateTimeExpression
extends AbstractExpression<Integer> {
    private final DateTimeFunctionType type;
    private final AbstractExpression<?> x;
    private String alias;

    public DateTimeExpression(DateTimeFunctionType type, Expression<?> x) {
        super(Integer.class);
        this.type = type;
        this.x = (AbstractExpression)x;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        String xExpr = this.x.generateJpqlRestriction(query);
        return MessageFormat.format(this.type.jpqlFragment, xExpr);
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (StringUtils.isNotBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        String xExpr = this.x.getSqlRestrictionFragments(query)[0];
        return new String[]{MessageFormat.format(query.getJdbcAdaptor().getDateTimeFunctionTemplate(this.type), xExpr)};
    }

    @Override
    public Integer handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return (Integer)row.getObject(this.alias);
    }
}

