/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractParameterExpressionImpl;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.type.TypeImpl;

public class EntityConstantExpression<T>
extends AbstractParameterExpressionImpl<T> {
    private final T value;
    private Object position;

    public EntityConstantExpression(TypeImpl<T> type, T value) {
        super(type, value.getClass());
        this.value = value;
    }

    @Override
    protected void ensureAlias(BaseQueryImpl<?> query) {
        if (this.position == null) {
            this.position = query.getAlias(this);
            if (StringUtils.isBlank((String)this.getAlias())) {
                this.alias("const" + this.position);
            }
        }
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        if (Number.class.isAssignableFrom(this.getJavaType())) {
            return this.value.toString();
        }
        return "'" + this.value.toString() + "'";
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        return this.generateJpqlRestriction(query);
    }

    @Override
    public T handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return this.value;
    }

    public void setParameter(MetamodelImpl metamodel, Connection connection, Object[] parameters, MutableInt sqlIndex) {
        super.setParameter(metamodel, connection, parameters, sqlIndex, this.value);
    }
}

